/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import com.google.common.base.Strings;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.GenerateOtpResponse;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchEmailOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchMobileOtpRequest;
import in.gov.uidai.ec.ecmpapi.xml.genericotp.MatchOtpResponse;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Email;
import in.gov.uidai.ec.service.enrollment.model.Mobile;
import in.gov.uidai.ec.telemetry.TelemetryMetrics;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.demographics.OtpValidationDelegate;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpControl
implements IDemoTabConstants,
IOnScreenDisplayAware {
    private static int retryMobOtpCount = 0;
    private static int retryEmailOtpCount = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(OtpControl.class);
    private IOnScreenDisplay osd;
    private IResourceBundleContext enrolRbCtxt;
    private EnrollmentService enrollmentService;

    public void setEnrolmentService(EnrollmentService enrolmentService) {
        this.enrollmentService = enrolmentService;
    }

    public void setResourceBundleContext(IResourceBundleContext rbCtxt) {
        this.enrolRbCtxt = rbCtxt;
    }

    @EventHandler(name="hID_Otp_Submit", method="actionPerformed")
    public void otpSubmit(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        JComponent parent = (JComponent)evt.getEvent().getSource();
        IViewElement otpEntered = (IViewElement)view.getElementMap().get("eID_Otp");
        String mobile = this.enrollmentService.getDemographics().getContact().getMobile().number();
        String sid = this.enrollmentService.getSid();
        if (!OtpValidationDelegate.isOtpValid(otpEntered)) {
            return;
        }
        ++retryMobOtpCount;
        MatchMobileOtpRequest request = new MatchMobileOtpRequest();
        request.setOtp((String)otpEntered.get("text"));
        request.setMobile(mobile);
        request.setSid(sid);
        LOGGER.info("Making Match Mobile OTP Request");
        ModalVisualExecutionContext veCtxt = new ModalVisualExecutionContext((Component)parent, false, new L10nDecorator(this.enrolRbCtxt, false));
        Utils.showProgressBar((IVisualExecutionContext)veCtxt, "Matching OTP ... ");
        try {
            MatchOtpResponse matchResponse = this.enrollmentService.getOauthGwApiService().matchMobOtp(request);
            Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
            if (matchResponse.getStatus().equalsIgnoreCase("Success")) {
                if (matchResponse.getResponseData().getResponseCode().equalsIgnoreCase("Y")) {
                    LOGGER.info("Otp Request successfully completed");
                    L10nOptionPaneBuilder.getInstance().showInfoUC((Object)("Otp verified successfully for mobile number : " + this.enrollmentService.getDemographics().getContact().getMobile().number()));
                    if (this.enrollmentService.isNewEnrollmentUC()) {
                        this.osd.dispose(evt.getScaffoldId());
                        this.osd.disposeView(evt.getViewId());
                    } else {
                        this.osd.dispose(evt.getScaffoldId());
                        this.osd.disposeView(evt.getViewId());
                    }
                    this.enrollmentService.getDemographics().getContact().getMobile().setMobileVerified(true);
                } else {
                    TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/genericOtp/match", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                    if (retryMobOtpCount >= 3) {
                        L10nOptionPaneBuilder.getInstance().showError((Object)"Exceeded the maximum Match limit, Please Regenerate Otp", (Component)parent, new Object[0]);
                        ILiteScaffold pScaf = this.osd.getScaffold(evt.getScaffoldId());
                        if (pScaf != null) {
                            this.osd.dispose(pScaf.getId());
                        }
                        retryMobOtpCount = 0;
                    } else {
                        L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"OTP Mismatch ! Please Enter Correct Otp", (Component)parent, new Object[0]);
                    }
                    LOGGER.info("Otp validation Failed");
                }
            } else {
                L10nOptionPaneBuilder.getInstance().showErrorUC(matchResponse.getErrorDetail() != null ? CommonUtilsUC.getErrorMessage((UosResponse)matchResponse) : matchResponse.getStatus(), (Component)parent, matchResponse.getErrorCode() != null ? matchResponse.getErrorCode() : ErrorCodes.UC_OTP_002.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        }
        catch (OnlineGatewayException e) {
            Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
            LOGGER.error("Error While Matching Otp", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    @EventHandler(name="hID_Email_Otp_Submit", method="actionPerformed")
    public void onEmailOtpSubmit(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        JComponent parent = (JComponent)evt.getEvent().getSource();
        IViewElement otpEntered = (IViewElement)view.getElementMap().get("eID_email_otp");
        String email = this.enrollmentService.getDemographics().getContact().getEmail().email();
        String sid = this.enrollmentService.getSid();
        if (!OtpValidationDelegate.isOtpValid(otpEntered)) {
            return;
        }
        ++retryEmailOtpCount;
        LOGGER.info("Making Match Email OTP Request");
        ModalVisualExecutionContext veCtxt = new ModalVisualExecutionContext((Component)parent, false, new L10nDecorator(this.enrolRbCtxt, false));
        Utils.showProgressBar((IVisualExecutionContext)veCtxt, "Matching OTP ... ");
        try {
            MatchEmailOtpRequest request = new MatchEmailOtpRequest();
            request.setOtp((String)otpEntered.get("text"));
            request.setEmail(email);
            request.setSid(sid);
            MatchOtpResponse matchResponse = this.enrollmentService.getOauthGwApiService().matchEmailOtp(request);
            Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
            if (matchResponse.getStatus().equalsIgnoreCase("Success")) {
                if (matchResponse.getResponseData().getResponseCode().equalsIgnoreCase("Y")) {
                    LOGGER.info("Otp Request successfully completed");
                    L10nOptionPaneBuilder.getInstance().showInfoUC((Object)("Otp verified successfully for email : " + this.enrollmentService.getDemographics().getContact().getEmail().email()));
                    this.osd.dispose(evt.getScaffoldId());
                    this.enrollmentService.getDemographics().getContact().getEmail().setEmailVerified(true);
                } else {
                    TelemetryService.getTelemetryServiceInstance().postMetricsData("/uos/ext/genericEmailOtp/match", TelemetryMetrics.EXCEPTIONS, 1L, new String[0]);
                    if (retryEmailOtpCount >= 3) {
                        L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Exceeded the maximum Match limit, Please Regenerate Otp", (Component)parent);
                        ILiteScaffold pScaf = this.osd.getScaffold(evt.getScaffoldId());
                        if (pScaf != null) {
                            this.osd.dispose(pScaf.getId());
                        }
                        retryEmailOtpCount = 0;
                    } else {
                        L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"OTP Mismatch ! Please Enter Correct Otp", (Component)parent);
                    }
                    LOGGER.info("Otp validation Failed");
                }
            } else {
                L10nOptionPaneBuilder.getInstance().showErrorUC(matchResponse.getErrorDetail() != null ? CommonUtilsUC.getErrorMessage((UosResponse)matchResponse) : matchResponse.getStatus(), (Component)parent, CommonUtilsUC.getErrorCode((UosResponse)matchResponse, ErrorCodes.UC_OTP_002.getErrorCode()), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        }
        catch (OnlineGatewayException e) {
            Utils.cancelProgressBar((IVisualExecutionContext)veCtxt);
            LOGGER.error("Error While Matching Otp", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    @EventHandler(name="mobile_resend_otp", method="actionPerformed")
    public void onResendMobileOtp(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
        Utils.showProgressBar(veCtxt, "Generating OTP ... ");
        LOGGER.info("Making Generic Mobile OTP Request");
        try {
            Mobile mobile = this.enrollmentService.getDemoContactDetails().getMobile();
            GenerateOtpResponse otpResponse = this.enrollmentService.getOauthGwApiService().otpRequestSubmit(true, mobile.number());
            Utils.cancelProgressBar(veCtxt);
            LOGGER.info("Mobile otp Request successfully completed");
            if (!otpResponse.getResult().equalsIgnoreCase("Y")) {
                LOGGER.error(otpResponse.getMessage());
                L10nOptionPaneBuilder.getInstance().showErrorUC(otpResponse.getMessage(), (Component)parent, Strings.isNullOrEmpty((String)otpResponse.getResponseCode()) ? ErrorCodes.UC_OTP_006.getErrorCode() : otpResponse.getResponseCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(otpResponse.getMessage()), CommonUtilsUC.getErrorCode((UosResponse)otpResponse, ErrorCodes.UC_OTP_006.getErrorCode()), new String[0]);
            }
        }
        catch (OnlineGatewayException e) {
            Utils.cancelProgressBar(veCtxt);
            LOGGER.error("Error While Generating Mobile Otp", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    private IVisualExecutionContext createVisualExecutionContext() {
        return new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
    }

    @EventHandler(name="email_resend_otp", method="actionPerformed")
    public void onResendEmailOtp(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
        Utils.showProgressBar(veCtxt, "Generating OTP ... ");
        LOGGER.info("Making Generic Email OTP Request");
        try {
            Email email = this.enrollmentService.getDemoContactDetails().getEmail();
            GenerateOtpResponse otpResponse = this.enrollmentService.getOauthGwApiService().otpRequestSubmit(false, email.email());
            Utils.cancelProgressBar(veCtxt);
            LOGGER.info("Email otp Request successfully completed");
            if (!otpResponse.getResult().equalsIgnoreCase("Y")) {
                LOGGER.error(otpResponse.getMessage());
                L10nOptionPaneBuilder.getInstance().showErrorUC(otpResponse.getMessage(), (Component)parent, Strings.isNullOrEmpty((String)otpResponse.getResponseCode()) ? ErrorCodes.UC_OTP_006.getErrorCode() : otpResponse.getResponseCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(otpResponse.getMessage()), CommonUtilsUC.getErrorCode((UosResponse)otpResponse, ErrorCodes.UC_OTP_006.getErrorCode()), new String[0]);
            }
        }
        catch (OnlineGatewayException e) {
            Utils.cancelProgressBar(veCtxt);
            LOGGER.error("Error While Generating Email Otp", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showErrorUC(e.getMessage(), (Component)parent, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    @EventHandler(name="hID_Otp_Escape", method="actionPerformed")
    public void onEscCloseWin(ILiteEvent evt) {
        retryMobOtpCount = 0;
        retryEmailOtpCount = 0;
        this.osd.dispose(evt.getScaffoldId());
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }
}

