/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.service.pincode.PostalAddress;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;

public class PinCodeListRenderer
extends JLabel
implements ListCellRenderer {
    public PinCodeListRenderer() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this;
        }
        PostalAddress postAddr = (PostalAddress)value;
        StringBuilder dispText = new StringBuilder("<html>");
        dispText.append(postAddr.getPinCode().getAddressCode());
        if (isSelected) {
            dispText.append(" <font color='#eeeeee'>(");
        } else {
            dispText.append(" <font color='#888888'>(");
        }
        dispText.append(postAddr.getState().getAddressValue()).append(" - ").append(postAddr.getDistrict().getAddressValue()).append(postAddr.getSubDistrict().getAddressValue() != null ? " - " + postAddr.getSubDistrict().getAddressValue() : "").append(" - ").append(postAddr.getVtc().getAddressValue()).append(")");
        this.setText(dispText.toString());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        return this;
    }
}

