/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.demographics;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.MandatoryLabelBuilder;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class ResidentTypePanel
implements IDemoTabConstants,
IViewElementComposite {
    final JRadioButton isIndianOpt;
    final JRadioButton isNRIOpt;
    private final IResourceBundleContext resourceBundleContext;
    LocaleLabel locResidentTypeField;

    public ResidentTypePanel(IResourceBundleContext resourceBundleContext) {
        this.resourceBundleContext = resourceBundleContext;
        this.isIndianOpt = new JRadioButton();
        this.isIndianOpt.setActionCommand("INDIAN-RESIDENT");
        this.isIndianOpt.setName("indianResident");
        this.isIndianOpt.setSelected(true);
        this.isNRIOpt = new JRadioButton();
        this.isNRIOpt.setActionCommand("NRI");
        this.isNRIOpt.setName("nri");
        ButtonGroup residentTypeGrp = new ButtonGroup();
        residentTypeGrp.add(this.isIndianOpt);
        residentTypeGrp.add(this.isNRIOpt);
        this.locResidentTypeField = new LocaleLabel(resourceBundleContext, "label-tlit:demotab.indian.resident");
        new ToggleButtonAssociation(this.isIndianOpt).deselect(this.isNRIOpt);
        new ToggleButtonAssociation(this.isNRIOpt).deselect(this.isIndianOpt);
    }

    public JComponent create(boolean isOnline) {
        double[][] stdGuides = new double[][]{ViewUtils.COLS_STD, {5.0, -1.0}};
        double[][] formGuides = new double[][]{ViewUtils.COLS_STD_FORM, {22.0}};
        TransparentBox result = new TransparentBox((LayoutManager)new TableLayout((double[][])stdGuides));
        TransparentBox leftForm = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuides));
        result.add((Component)leftForm, (Object)"1, 1, full, full");
        TransparentBox rightForm = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuides));
        ComponentOrientation co = ComponentOrientation.getOrientation(this.resourceBundleContext.getLocale());
        rightForm.setComponentOrientation(co);
        result.add((Component)rightForm, (Object)"3, 1, full, full");
        if (isOnline) {
            Font fontLoc = this.locResidentTypeField.getFont();
            this.locResidentTypeField.setFont(new Font(fontLoc.getName(), 0, 15));
            leftForm.add((Component)new MandatoryLabelBuilder(this.resourceBundleContext).createUC(LabelKeysDemoTab.RESIDENT_TYPE.toString()), (Object)"0, 0, right, full");
            rightForm.add((Component)new MandatoryLabelBuilder(this.resourceBundleContext).createLocalUC("label-tlit:demotab.resident.type"), (Object)"0, 0, right, full");
        } else {
            leftForm.add((Component)new MandatoryLabelBuilder(this.resourceBundleContext).create(LabelKeysDemoTab.RESIDENT_TYPE.toString()), (Object)"0, 0, right, full");
            rightForm.add((Component)new MandatoryLabelBuilder(this.resourceBundleContext).createLocal("label-tlit:demotab.resident.type"), (Object)"0, 0, right, full");
        }
        leftForm.add((Component)this.getResidentTypePanel(this.resourceBundleContext, isOnline), (Object)"2, 0, left, full");
        rightForm.add((Component)this.locResidentTypeField, (Object)"2, 0, left, full");
        return result;
    }

    private JComponent getResidentTypePanel(IResourceBundleContext resourceBundleContext, boolean isOnline) {
        double[][] guides = new double[][]{{5.0, 15.0, 5.0, 100.0, 5.0, 15.0, 5.0, 150.0, -1.0}, {22.0}};
        JLabel ind = new JLabel(resourceBundleContext.getMessage((Object)LabelKeysDemoTab.INDIAN_RESIDENT, new Object[0]));
        JLabel nri = new JLabel(resourceBundleContext.getMessage((Object)LabelKeysDemoTab.NON_RESIDENT_INDIAN, new Object[0]));
        if (isOnline) {
            Font font = ind.getFont();
            ind.setFont(new Font(font.getName(), 0, 12));
            nri.setFont(new Font(font.getName(), 0, 12));
        }
        TransparentBox residentTypeBox = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        residentTypeBox.add((Component)this.isIndianOpt, (Object)"1, 0, f, c");
        residentTypeBox.add((Component)ind, (Object)"3, 0, f, c");
        residentTypeBox.add((Component)this.isNRIOpt, (Object)"5, 0, f, c");
        residentTypeBox.add((Component)nri, (Object)"7, 0, f, c");
        return residentTypeBox;
    }

    public void setResidentTypeSelection(boolean isNri) {
        this.isNRIOpt.setSelected(isNri);
        this.isIndianOpt.setSelected(!isNri);
    }
}

