/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.enrollment.model.document.ScannedDoc;
import in.gov.uidai.ec.service.enrollment.model.document.ScannedPage;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.document.DocScanPreviewPeer;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.document.ImageTransformUtils;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysDocuments;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.ImageIconCache;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocScanPreviewController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocScanPreviewController.class);
    private final DocScanPreviewPeer viewElements;
    private final EnrollmentService enrollmentService;
    private final IVisualExecutionContext veCtxt;
    private final IOucDataStore oucDataStore;
    private final IResourceBundleContext resourceBundleContext;
    private int currentPageNo;

    public DocScanPreviewController(DocScanPreviewPeer viewElements, IResourceBundleContext resourceBundleContext) {
        super(viewElements.getView());
        this.viewElements = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.oucDataStore = viewElements.oucDataStore;
        this.veCtxt = viewElements.getView().getVisualExecutionContext();
        this.resourceBundleContext = resourceBundleContext;
        this.currentPageNo = 0;
        this.initView();
    }

    private void initView() {
        boolean nextScanAllowed = this.isNextScanAllowed();
        boolean isVerify = LabelKeysAction.VERIFY.toString().equals(this.enrollmentService.getDocManager().getPreviewType());
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.viewElements.pageNumber.setText("Page No. " + (this.currentPageNo + 1));
            DocumentType docType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
            boolean isDigilockerDocument = this.enrollmentService.getXmlData().containsKey(docType);
            ScannedDoc scannedDoc = this.enrollmentService.getDocManager().getScannedDoc(docType);
            this.viewElements.scanNextPage.setEnabled(nextScanAllowed && !isDigilockerDocument && !isVerify);
            this.viewElements.scanNextPage.setVisible(nextScanAllowed && !isVerify);
            this.addActionListener(this.viewElements.scanNextPage, (ActionEvent e) -> this.onClickScanPage());
            this.addActionListener(this.viewElements.nextPage, this::onClickNextPage);
            this.addActionListener(this.viewElements.prevPage, this::onClickPreviousPage);
            boolean isNextPageButtonEnabled = true;
            isNextPageButtonEnabled = isVerify ? scannedDoc.getTotalScannedPages() > 1 : nextScanAllowed;
            boolean isPreviousPageButtonEnabled = true;
            isPreviousPageButtonEnabled = isVerify ? scannedDoc.getTotalScannedPages() > 1 : nextScanAllowed;
            this.viewElements.nextPage.setEnabled(isNextPageButtonEnabled);
            this.viewElements.nextPage.setVisible(isNextPageButtonEnabled);
            this.viewElements.prevPage.setEnabled(false);
            this.viewElements.prevPage.setVisible(isPreviousPageButtonEnabled);
            this.viewElements.nextPage.setEnabled(scannedDoc.getTotalScannedPages() - 1 != this.currentPageNo);
            this.viewElements.prevPage.setEnabled(0 != this.currentPageNo);
            this.viewElements.imageViewer.setImage(((ScannedPage)scannedDoc.getPages().get(0)).getOriginalScannedDocument());
            this.viewElements.imageViewer.setPageIndex(() -> this.currentPageNo + 1);
            this.addActionListener(this.viewElements.saveBut, this.enrollmentService.getDocManager().getPreviewSaveButtonListener());
        } else {
            this.viewElements.imageViewer.setImage(this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().getOriginalScannedDocument());
            this.viewElements.pageNumber.setText("Page No. " + this.enrollmentService.getDocManager().getScannedDoc().getTotalScannedPages());
            this.viewElements.scanNextPage.setEnabled(this.isNextScanAllowed());
            this.addActionListener(this.viewElements.scanNextPage, (ActionEvent e) -> this.onClickNextPageForEcmp());
            this.addActionListener(this.viewElements.saveBut, this::onScanPreviewSaveButtonForEcmp);
        }
        if (OS.IsWindows()) {
            this.addActionListener(this.viewElements.fixAlignmentButton, (ActionEvent e) -> this.onDocFixAlignment());
            if (this.enrollmentService.isUniversalClientTrnx()) {
                this.addActionListener(this.viewElements.decrementAngle, (ActionEvent e) -> this.rotateDocument(1.0));
                this.addActionListener(this.viewElements.incrementAngle, (ActionEvent e) -> this.rotateDocument(-1.0));
            } else {
                this.addActionListener(this.viewElements.decrementAngle, (ActionEvent e) -> this.rotateDocument(0.0));
                this.addActionListener(this.viewElements.incrementAngle, (ActionEvent e) -> this.rotateDocument(0.0));
                this.viewElements.decrementAngle.addMouseListener(this.mouseActionListener(false));
                this.viewElements.incrementAngle.addMouseListener(this.mouseActionListener(true));
                this.viewElements.roiCaptureButtons.keySet().forEach(button -> button.addActionListener(e -> this.captureROI((JButton)button, e)));
            }
            this.addActionListener(this.viewElements.rotate90Degree, (ActionEvent e) -> this.rotateDocument(-90.0));
            this.addFocusListener(this.viewElements.rotateAngle, this::rotateAngleFocusLost);
            this.addActionListener(this.viewElements.rotateAngle, (ActionEvent e) -> this.rotateDocument(this.getAngleToRotate()));
            this.addActionListener(this.viewElements.originalDocButton, (ActionEvent e) -> this.onShowOriginalImage());
            this.viewElements.decrementAngle.addMouseListener(this.mouseActionListener(false));
            this.viewElements.incrementAngle.addMouseListener(this.mouseActionListener(true));
            this.viewElements.roiCaptureButtons.keySet().forEach(button -> button.addActionListener(e -> this.captureROI((JButton)button, e)));
        }
    }

    private void captureROI(JButton button, ActionEvent e) {
        JLabel jLabel = this.viewElements.roiCaptureButtons.get(button);
        jLabel.setIcon(ImageIconCache.getInst().getIcon("res/ecmp/images/compliance-ok.png"));
    }

    private void onDocFixAlignment() {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        double skew = ImageTransformUtils.computeSkew(docManager.getScannedDoc().getLastScannedPage().getOriginalScannedDocument());
        docManager.getScannedDoc().getLastScannedPage().addRotateAngle(skew);
        double rotateAngle = docManager.getScannedDoc().getLastScannedPage().getRotateAngle();
        this.viewElements.rotateAngle.setText(String.valueOf(-((int)rotateAngle)));
        this.rotateDocument(rotateAngle);
    }

    private void rotateAngleFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.rotateDocument(this.getAngleToRotate());
    }

    private double getAngleToRotate() {
        this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().resetRotateAngle();
        String angle = this.viewElements.rotateAngle.getText();
        int userInput = 0;
        if (StringUtils.isNotBlank((String)angle)) {
            userInput = -Integer.parseInt(angle);
        }
        return userInput;
    }

    private synchronized void rotateDocument(double angleToRotate) {
        try {
            DocumentsManager docManager = this.enrollmentService.getDocManager();
            ScannedPage lastScannedPage = docManager.getScannedDoc().getLastScannedPage();
            docManager.getScannedDoc().getLastScannedPage().addRotateAngle(angleToRotate);
            double rotateAngle = docManager.getScannedDoc().getLastScannedPage().getRotateAngle();
            this.viewElements.rotateAngle.setText(String.valueOf(-((int)rotateAngle)));
            BufferedImage originalScannedDocument = lastScannedPage.getOriginalScannedDocument();
            BufferedImage rotatedImage = ImageTransformUtils.rotateDocument(originalScannedDocument, rotateAngle);
            lastScannedPage.setOriginalScannedDocument(rotatedImage);
            this.viewElements.imageViewer.setImage(rotatedImage);
        }
        catch (Exception e) {
            LOGGER.debug("Error while rotating the document.", (Throwable)e);
        }
    }

    private void onShowOriginalImage() {
        try {
            DocumentsManager docManager = this.enrollmentService.getDocManager();
            ScannedPage lastScannedPage = docManager.getScannedDoc().getLastScannedPage();
            lastScannedPage.resetRotateAngle();
            this.viewElements.rotateAngle.setText(String.valueOf(0));
            BufferedImage originalScannedDocument = lastScannedPage.getOriginalScannedDocument();
            lastScannedPage.setOriginalScannedDocument(originalScannedDocument);
            this.viewElements.imageViewer.setImage(originalScannedDocument);
        }
        catch (Exception e) {
            LOGGER.debug("Error while copying document for showing original document.", (Throwable)e);
        }
    }

    private void onClickScanPage() {
        this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().finalizeDocument();
        if (this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage(this.viewElements.resBundleCtxt.getMessage((Object)MsgKeysDocuments.VEX_DOC_SCAN, new Object[0]));
        }
        ThreadPool.commonPool().submit(() -> {
            DocumentsManager docManager = this.enrollmentService.getDocManager();
            try {
                ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
                BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(ScanMode.COLOR, null, this.enrollmentService);
                if (bufferedImage != null) {
                    docManager.addNextDocument(bufferedImage, scannerInfo.getLastMode());
                    this.viewElements.scanNextPage.setEnabled(this.isNextScanAllowed());
                    this.viewElements.imageViewer.setImage(docManager.getScannedDoc().getLastScannedPage().getOriginalScannedDocument());
                    this.currentPageNo = docManager.getScannedDoc().getTotalScannedPages() - 1;
                    this.viewElements.pageNumber.setText("Page No. " + (this.currentPageNo + 1));
                    this.viewElements.nextPage.setEnabled(docManager.getScannedDoc().getTotalScannedPages() - 1 != this.currentPageNo);
                    this.viewElements.prevPage.setEnabled(0 != this.currentPageNo);
                } else {
                    LOGGER.error("Error while Scanning document.");
                    this.showErrorUC(this.viewElements.scanNextPage, this.resourceBundleContext.getMessage((Object)MsgKeysDocuments.SCAN_ERROR, new Object[0]), ErrorCodes.UC_GEN_008.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
                    docManager.resetDocument();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while Scanning document.", (Throwable)e);
                this.showErrorUC(this.viewElements.scanNextPage, this.resourceBundleContext.getMessage((Object)MsgKeysDocuments.SCAN_ERROR, new Object[0]), ErrorCodes.UC_GEN_005.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
                docManager.resetDocument();
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("*********************Out of memory*************************");
                this.showErrorUC(this.viewElements.scanNextPage, this.resourceBundleContext.getMessage((Object)MsgKeysDocuments.SCAN_ERROR, new Object[0]), ErrorCodes.UC_GEN_006.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
            }
            finally {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
            }
        });
    }

    private void onClickNextPageForEcmp() {
        this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().finalizeDocument();
        if (this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage(this.viewElements.resBundleCtxt.getMessage((Object)MsgKeysDocuments.VEX_DOC_SCAN, new Object[0]));
        }
        new Thread(() -> {
            DocumentsManager docManager = this.enrollmentService.getDocManager();
            try {
                ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
                BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(null, null, this.enrollmentService);
                if (bufferedImage != null) {
                    docManager.addNextDocument(bufferedImage, scannerInfo.getLastMode());
                    this.viewElements.scanNextPage.setEnabled(this.isNextScanAllowed());
                    this.viewElements.imageViewer.setImage(docManager.getScannedDoc().getLastScannedPage().getOriginalScannedDocument());
                    this.viewElements.pageNumber.setText("Page No. " + docManager.getScannedDoc().getTotalScannedPages());
                } else {
                    LOGGER.error("Error while Scanning document.");
                    this.showError(this.viewElements.scanNextPage, (Object)MsgKeysDocuments.SCAN_ERROR);
                    docManager.resetDocument();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while Scanning document.", (Throwable)e);
                this.showError(this.viewElements.scanNextPage, (Object)MsgKeysDocuments.SCAN_ERROR);
                docManager.resetDocument();
            }
            finally {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
            }
        }).start();
    }

    private void onClickNextPage(ActionEvent event) {
        ScannedDoc scannedDoc = this.enrollmentService.getDocManager().getScannedDoc();
        if (scannedDoc.getTotalScannedPages() - 1 != this.currentPageNo) {
            ++this.currentPageNo;
            this.viewElements.pageNumber.setText("Page No. " + (this.currentPageNo + 1));
            this.viewElements.imageViewer.setImage(((ScannedPage)scannedDoc.getPages().get(this.currentPageNo)).getOriginalScannedDocument());
        }
        this.viewElements.nextPage.setEnabled(scannedDoc.getTotalScannedPages() - 1 != this.currentPageNo);
        this.viewElements.prevPage.setEnabled(0 != this.currentPageNo);
    }

    private void onClickPreviousPage(ActionEvent event) {
        ScannedDoc scannedDoc = this.enrollmentService.getDocManager().getScannedDoc();
        if (this.currentPageNo != 0) {
            this.viewElements.nextPage.setEnabled(true);
            --this.currentPageNo;
            this.viewElements.pageNumber.setText("Page No. " + (this.currentPageNo + 1));
            this.viewElements.imageViewer.setImage(((ScannedPage)scannedDoc.getPages().get(this.currentPageNo)).getOriginalScannedDocument());
        }
        this.viewElements.nextPage.setEnabled(scannedDoc.getTotalScannedPages() - 1 != this.currentPageNo);
        this.viewElements.prevPage.setEnabled(0 != this.currentPageNo);
    }

    private boolean isNextScanAllowed() {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        DocumentType docType = docManager.getCurrentDocumentTypeForUploadOrVerify();
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getReferenceDoc(docType);
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        if (docType == DocumentType.ENROL_FORM && this.enrollmentService.isUniversalClientTrnx() && (this.enrollmentService.isForeignResident() || this.enrollmentService.isNRIEnrolment())) {
            return docManager.getScannedDoc().getTotalScannedPages() < this.enrollmentService.getOnlineDocumentService().getPageCountForScan("EnrolForm", docType, this.enrollmentService.isForeignResident() || this.enrollmentService.isNRIEnrolment(), foreignDetail);
        }
        if (referenceDoc == null || referenceDoc.getProof() == null) {
            return false;
        }
        if (this.enrollmentService.isUniversalClientTrnx()) {
            return docManager.getScannedDoc().getTotalScannedPages() < this.enrollmentService.getOnlineDocumentService().getPageCountForScan(referenceDoc.getProof().getDocName(), docType, false, foreignDetail);
        }
        return docManager.getScannedDoc().getTotalScannedPages() < this.enrollmentService.getDocumentService().getPageCountForScan(referenceDoc.getProof().getDocName(), docType);
    }

    private MouseAdapter mouseActionListener(final boolean rotateClockwise) {
        return new MouseAdapter(){
            final Timer timer = new Timer(75, e1 -> {
                ScannedPage lastScannedPage = DocScanPreviewController.this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage();
                lastScannedPage.addRotateAngle(rotateClockwise ? -1.0 : 1.0);
                ((DocScanPreviewController)DocScanPreviewController.this).viewElements.rotateAngle.setText(String.valueOf(-((int)lastScannedPage.getRotateAngle())));
            });

            @Override
            public void mousePressed(MouseEvent e) {
                this.timer.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.timer.stop();
            }
        };
    }

    private void onScanPreviewSaveButtonForEcmp(ActionEvent actionEvent) {
        if (this.veCtxt != null) {
            this.veCtxt.reset();
            this.veCtxt.setMessage("Saving the document. Please wait.");
        }
        new Thread(() -> {
            this.enrollmentService.getDocManager().getScannedDoc().getLastScannedPage().finalizeDocument();
            try {
                this.enrollmentService.getDocManager().convertToPdf();
            }
            catch (Exception e) {
                LOGGER.error("Error while converting image to pdf ", (Throwable)e);
                this.showError(this.viewElements.saveBut, "Error while saving the document. " + e.getMessage());
            }
            finally {
                if (this.veCtxt != null) {
                    this.veCtxt.cancel();
                }
                SwingUtilities.getWindowAncestor((JButton)actionEvent.getSource()).dispose();
            }
        }).start();
    }
}

