/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.util.OS;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.service.document.Annotation;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.documentimageview.DocumentAnnotationsListener;
import in.gov.uidai.ec.swing.documentimageview.DocumentImageViewer;
import in.gov.uidai.ec.swing.documentimageview.FullCaptureCallBack;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.swing.imgvu.ImageViewer;
import in.gov.uidai.ec.swing.imgvu.roi.DocumentAnnotationCaptureCallBack;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.document.CustomRoundedBorder;
import in.gov.uidai.ec.ui.enrol.document.DocScanPreviewController;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsPreference;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationPopup;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocScanPreviewPeer
extends StandardViewPeer {
    protected static final String OK_ICON_PATH = "res/ecmp/images/compliance-ok.png";
    protected static final String ERROR_ICON_PATH = "res/ecmp/images/compliance-error.png";
    protected IResourceBundleContext resBundleCtxt;
    protected IUIPreference uiPref;
    protected EnrollmentService enrollmentService;
    protected IDocumentsPreference docPref;
    protected IOucDataStore oucDataStore;
    protected ImageViewer imageViewer;
    protected JButton originalDocButton;
    protected JButton fixAlignmentButton;
    protected JButton decrementAngle;
    protected JButton incrementAngle;
    protected JButton rotate90Degree;
    protected JButton saveBut;
    protected JTextField rotateAngle;
    protected JButton scanNextPage;
    protected JLabel pageNumber;
    protected Map<JButton, JLabel> roiCaptureButtons = new HashMap<JButton, JLabel>();
    protected DocumentAnnotationsListener docAnnotationListener = new DocumentAnnotationsListener();
    protected JButton prevPage;
    protected JButton nextPage;
    private static final Logger LOGGER = LoggerFactory.getLogger(DocScanPreviewPeer.class);

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.resBundleCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setDocumentsPreference(IDocumentsPreference docPref) {
        this.docPref = docPref;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    protected void prepareImpl() {
        L10nDecorator ldeco = new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false));
        TransparentBox tbox = new TransparentBox();
        tbox.setLayout((LayoutManager)new BorderLayout());
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        tbox.setPreferredSize(new Dimension((int)resolution.getWidth(), (int)resolution.getHeight() - 200));
        tbox.setLocation((int)resolution.getWidth() / 4, 0);
        TransparentBox axnPanel = new TransparentBox((LayoutManager)new FlowLayout(0, 0, 2));
        axnPanel.add(Box.createHorizontalStrut(20));
        axnPanel.add((Component)new JLabel("Zoom Levels: "));
        this.imageViewer = new ImageViewer();
        if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isRoiEnabled(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify())) {
            this.imageViewer = new DocumentImageViewer(this.docAnnotationListener);
        }
        this.imageViewer.setDisplayMode(DisplayMode.AUTO_FIT);
        axnPanel.add((Component)this.imageViewer.getNormalSizeButton());
        axnPanel.add((Component)this.imageViewer.getAutoFitButton());
        axnPanel.add(Box.createHorizontalStrut(20));
        axnPanel.add((Component)new JLabel("Document Type: "));
        JLabel docType = new JLabel(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify().value());
        docType.setPreferredSize(new Dimension(50, 22));
        axnPanel.add((Component)docType);
        if (OS.IsWindows()) {
            axnPanel.add(Box.createHorizontalStrut(20));
            this.originalDocButton = new JButton("Original Document");
            this.originalDocButton.setPreferredSize(new Dimension(140, 22));
            axnPanel.add((Component)this.originalDocButton);
            axnPanel.add(Box.createHorizontalStrut(20));
            this.fixAlignmentButton = new JButton("Auto-Align Document");
            this.fixAlignmentButton.setPreferredSize(new Dimension(140, 22));
            axnPanel.add((Component)this.fixAlignmentButton);
            axnPanel.add(Box.createHorizontalStrut(20));
            JLabel rotateLabel = new JLabel("Rotate");
            axnPanel.add((Component)rotateLabel);
            axnPanel.add(Box.createHorizontalStrut(5));
            this.decrementAngle = new JButton("-");
            this.decrementAngle.setPreferredSize(new Dimension(22, 22));
            axnPanel.add((Component)this.decrementAngle);
            axnPanel.add(Box.createHorizontalStrut(3));
            this.rotateAngle = new JTextField("0");
            this.rotateAngle.setHorizontalAlignment(0);
            this.rotateAngle.setPreferredSize(new Dimension(35, 22));
            axnPanel.add((Component)this.rotateAngle);
            axnPanel.add(Box.createHorizontalStrut(3));
            this.incrementAngle = new JButton("+");
            this.incrementAngle.setPreferredSize(new Dimension(22, 22));
            axnPanel.add((Component)this.incrementAngle);
            axnPanel.add(Box.createHorizontalStrut(20));
            this.rotate90Degree = new JButton("Rotate 90 Degrees");
            this.rotate90Degree.setPreferredSize(new Dimension(140, 22));
            axnPanel.add((Component)this.rotate90Degree);
        }
        if (!this.enrollmentService.isOnlineUpdate()) {
            this.pageNumber = new JLabel("Page No. 1");
            this.scanNextPage = new JButton("Scan Next Page");
            this.saveBut = new JButton(this.resBundleCtxt.getMessage((Object)LabelKeysAction.SAVE, new Object[0]));
            this.saveBut.setEnabled(true);
            ldeco.localize((AbstractButton)this.saveBut, (Object)LabelKeysAction.SAVE, new Object[0]);
            TransparentBox bottomPanel = new TransparentBox((LayoutManager)new FlowLayout(1, 0, 2));
            bottomPanel.add((Component)this.pageNumber);
            bottomPanel.add(Box.createHorizontalStrut(30));
            bottomPanel.add((Component)this.scanNextPage);
            tbox.add((Component)this.imageViewer, (Object)"Center");
            bottomPanel.add(Box.createHorizontalStrut(20));
            bottomPanel.add((Component)this.saveBut);
            tbox.add((Component)axnPanel, (Object)"North");
            tbox.add((Component)bottomPanel, (Object)"South");
            this.setContentPane((JComponent)tbox);
            this.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)tbox, false));
            new DocScanPreviewController(this, this.resBundleCtxt);
        } else {
            this.pageNumber = new JLabel("Page No. 1");
            LabelKeysAction saveButtonLabel = this.getSaveButtonLabel();
            this.saveBut = new JButton(this.resBundleCtxt.getMessage((Object)saveButtonLabel, new Object[0]));
            this.saveBut.setEnabled(false);
            ldeco.localize((AbstractButton)this.saveBut, (Object)saveButtonLabel, new Object[0]);
            TransparentBox bottomPanel = new TransparentBox((LayoutManager)new FlowLayout(1, 0, 2));
            bottomPanel.add((Component)this.pageNumber);
            bottomPanel.add(Box.createHorizontalStrut(25));
            if (this.enrollmentService.getDocManager().getPreviewType().equals(LabelKeysAction.VERIFY.toString()) && this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify() != DocumentType.SIGNED_ACK_SLIP && this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify() != DocumentType.ENROL_FORM) {
                double[][] guides = new double[][]{{0.1, 0.9}, {0.98}};
                TransparentBox imageDisplayPanel = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
                JPanel buttonsPanel = new JPanel();
                buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 1));
                buttonsPanel.add((Component)this.getSelectRoiLabelUC());
                try {
                    List rois = this.enrollmentService.getRoiList(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify());
                    List annotations = Annotation.getAnnotations((List)rois);
                    for (Annotation annotation : annotations) {
                        if (!this.enrollmentService.isForeignResident() && annotation.getPartLabel().contains("Date")) continue;
                        buttonsPanel.add((Component)this.createButtonForUC(annotation));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in setting annotations for verify preview", (Throwable)e);
                    TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_188.getErrorCode(), new String[0]);
                    L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_GEN_188.getReason(), (Component)this.getContentPane(), new Object[]{ErrorCodes.UC_GEN_188.getErrorCode(), "Please try again..."});
                }
                this.docAnnotationListener.add(new FullCaptureCallBack(){

                    @Override
                    public void onFullCapture(List<Annotation> annotations) {
                        DocScanPreviewPeer.this.enrollmentService.getDocManager().setAnnotations(DocScanPreviewPeer.this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify(), annotations);
                        DocScanPreviewPeer.this.saveBut.setEnabled(true);
                    }

                    @Override
                    public void resetFullCapture() {
                        DocScanPreviewPeer.this.saveBut.setEnabled(false);
                    }
                });
                imageDisplayPanel.add((Component)buttonsPanel, (Object)"0, 0, center, top");
                imageDisplayPanel.add((Component)this.imageViewer, (Object)"1, 0, full, full");
                tbox.add((Component)imageDisplayPanel, (Object)"Center");
            } else {
                this.saveBut.setEnabled(true);
                tbox.add((Component)this.imageViewer, (Object)"Center");
            }
            bottomPanel.add(Box.createHorizontalStrut(20));
            bottomPanel.add((Component)this.saveBut);
            bottomPanel.add(Box.createHorizontalStrut(20));
            this.scanNextPage = new JButton("Scan Next Page");
            bottomPanel.add((Component)this.scanNextPage);
            boolean isDigilockerDocument = this.enrollmentService.getDocumentFetchType() != null && this.enrollmentService.getDocumentFetchType().equalsIgnoreCase("digilocker");
            this.scanNextPage.setEnabled(!isDigilockerDocument || !this.enrollmentService.getDocManager().getPreviewType().equals(LabelKeysAction.UPLOAD.toString()));
            bottomPanel.add(Box.createHorizontalStrut(20));
            this.nextPage = new JButton("Next Page");
            this.nextPage.setEnabled(false);
            bottomPanel.add((Component)this.nextPage);
            bottomPanel.add(Box.createHorizontalStrut(20));
            this.prevPage = new JButton("Previous Page");
            this.prevPage.setEnabled(false);
            bottomPanel.add((Component)this.prevPage);
            tbox.add((Component)axnPanel, (Object)"North");
            tbox.add((Component)bottomPanel, (Object)"South");
            this.setContentPane((JComponent)tbox);
            this.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)tbox, false));
            new DocScanPreviewController(this, this.resBundleCtxt);
        }
    }

    private TransparentBox getSelectRoiLabelUC() {
        JLabel selectRoiLbl = new JLabel("Capture ROIs");
        String toolTip = "Draw a rectangle around the ROI (Region of Interest) by clicking the below buttons";
        selectRoiLbl.setFont(new Font(selectRoiLbl.getFont().getName(), 1, 16));
        JTextArea instructionLbl = new JTextArea(toolTip);
        instructionLbl.setWrapStyleWord(true);
        instructionLbl.setLineWrap(true);
        instructionLbl.setEditable(false);
        double[][] stdGuides = new double[][]{{-1.0}, {60.0, 22.0, 100.0}};
        TransparentBox transparentBox = new TransparentBox((LayoutManager)new TableLayout((double[][])stdGuides));
        transparentBox.add((Component)selectRoiLbl, (Object)"0, 1, c, c");
        String constraints = "0, 2, c, c";
        transparentBox.add((Component)instructionLbl, (Object)constraints);
        return transparentBox;
    }

    private TransparentBox createButtonForUC(final Annotation annotation) {
        double[][] stdGuides = new double[][]{{-1.0, 200.0, 15.0, 25.0, -1.0}, {7.0, 22.0}};
        TransparentBox result = new TransparentBox((LayoutManager)new BorderLayout());
        String displayLabel = this.getDisplayLabel(annotation.getDisplayName());
        final JButton button = new JButton("<html>" + displayLabel + "</html>");
        button.setPreferredSize(new Dimension(130, 60));
        button.setActionCommand(annotation.toString());
        if (annotation.isMandatory()) {
            SwingUtilities.invokeLater(() -> this.showFieldError(button));
        }
        final JLabel statusLbl = new JLabel();
        statusLbl.setPreferredSize(new Dimension(20, 20));
        if (annotation.isMandatory()) {
            statusLbl.setIcon(ImageIconCache.getInst().getIcon(ERROR_ICON_PATH));
        }
        result.add((Component)button);
        result.add((Component)button, (Object)"West");
        result.add((Component)statusLbl, (Object)"East");
        DocumentAnnotationCaptureCallBack captureCallBack = new DocumentAnnotationCaptureCallBack(){

            @Override
            public void onSuccessCapture() {
                statusLbl.setIcon(ImageIconCache.getInst().getIcon(DocScanPreviewPeer.OK_ICON_PATH));
                if (annotation.isMandatory()) {
                    DocScanPreviewPeer.this.clearFieldError(button);
                }
            }

            @Override
            public void onResetCapture() {
                statusLbl.setIcon(ImageIconCache.getInst().getIcon(DocScanPreviewPeer.ERROR_ICON_PATH));
                if (annotation.isMandatory()) {
                    SwingUtilities.invokeLater(() -> DocScanPreviewPeer.this.showFieldError(button));
                }
            }
        };
        this.docAnnotationListener.registerCallback(annotation, captureCallBack);
        button.addActionListener(e -> this.docAnnotationListener.select(annotation));
        this.roiCaptureButtons.put(button, statusLbl);
        return result;
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
        this.imageViewer.clear();
    }

    private void showFieldError(JComponent component) {
        component.setBorder(new CustomRoundedBorder(Color.decode("#FA6444"), 7));
        NotificationPopup toolTip = NotificationPopup.getToolTip((JComponent)component);
        toolTip.setToolTipText("This is mandatory", false);
        toolTip.setLocation(NotificationLocation.RIGHT);
        component.repaint();
    }

    private void clearFieldError(JComponent component) {
        component.setBorder(new CustomRoundedBorder(Color.decode("#6d89ab"), 7));
        NotificationPopup.getToolTip((JComponent)component).setToolTipText(null, false);
        component.repaint();
    }

    private String getDisplayLabel(String name) {
        StringBuilder stringBuilder = new StringBuilder();
        int cnt = 0;
        for (String s : name.split(" ")) {
            stringBuilder.append(s);
            stringBuilder.append(" ");
            if (++cnt % 4 != 0) continue;
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private LabelKeysAction getSaveButtonLabel() {
        try {
            String previewType = this.enrollmentService.getDocManager().getPreviewType();
            if (previewType.equals(LabelKeysAction.UPLOAD.toString()) && !this.enrollmentService.getDocManager().isDocumentUploaded(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify())) {
                return LabelKeysAction.UPLOAD;
            }
            if (previewType.equals(LabelKeysAction.VERIFY.toString())) {
                return LabelKeysAction.VERIFY;
            }
            if (previewType.equals(LabelKeysAction.PREVIEW.toString())) {
                return LabelKeysAction.PREVIEW;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in creating save button label for Doc Scan Preview", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_184.getErrorCode(), new String[0]);
        }
        return LabelKeysAction.CLOSE;
    }
}

