/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.scan.IDocScan;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.icas.scan.ScannerProp;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.shared.ILastSelectedFilePaths;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentUtils
implements IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentUtils.class);
    private static final String[] FILE_TYPES = new String[]{"pdf"};
    private static DocumentUtils instance;
    private IDocScan twainScan;
    private ILastSelectedFilePaths lastSelPaths;
    private IPreferenceStore prefStore;
    private IOucDataStore oucDataStore;

    private DocumentUtils() {
        instance = this;
    }

    public static DocumentUtils getInstance() {
        if (instance == null) {
            instance = new DocumentUtils();
        }
        return instance;
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    public void setTwainScan(IDocScan twainScan) {
        this.twainScan = twainScan;
    }

    public void setLastSelectedFilePaths(ILastSelectedFilePaths lsfp) {
        this.lastSelPaths = lsfp;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    public String[] getScannerDeviceList() {
        String[] deviceList = null;
        try {
            deviceList = this.twainScan.getDeviceList();
        }
        catch (Exception e) {
            LOGGER.error("Could not load the scanner list, error: " + e);
        }
        finally {
            this.twainScan.close();
        }
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage acquireImage(ScanMode scanMode, String fileName, EnrollmentService enrollmentService) {
        BufferedImage bufferedImage = null;
        try {
            ScannerProp scanProp = new ScannerProp();
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            if (null != enrollmentService && enrollmentService.isUniversalClientTrnx()) {
                scanProp.setDpi(250);
            } else {
                scanProp.setDpi(300);
            }
            scanProp.setMode(scanMode != null ? scanMode : ScanMode.fromString((String)scannerInfo.getLastMode()));
            this.twainScan.setSource(scannerInfo.getLastScanner());
            this.twainScan.showUI(false);
            this.twainScan.setProperties(scanProp);
            if (StringUtils.isBlank((String)fileName)) {
                bufferedImage = this.twainScan.acquireImage();
            } else {
                this.twainScan.acquireImage(fileName);
            }
        }
        catch (StationInfoStoreException | IOException e) {
            LOGGER.error("Failed to get last selected scanner settings from OTA Update Client due to : ", e);
        }
        finally {
            this.twainScan.close();
        }
        return bufferedImage;
    }

    public File selectPdfFileFromBrowser(Component component) {
        String lastDocAttachPath = this.lastSelPaths.getDocAttachPath();
        JFileChooser browser = new JFileChooser(lastDocAttachPath);
        browser.setMultiSelectionEnabled(false);
        browser.setApproveButtonText("Attach");
        browser.setDialogTitle("Document Attachment");
        browser.setFileSelectionMode(0);
        browser.setAcceptAllFileFilterUsed(false);
        browser.addChoosableFileFilter(new FileNameExtensionFilter("PDF Files", FILE_TYPES));
        int status = browser.showOpenDialog(component);
        if (status == 0) {
            File file = browser.getSelectedFile();
            if (!file.getParent().equalsIgnoreCase(lastDocAttachPath)) {
                this.lastSelPaths.setDocAttachPath(file.getParent());
                this.prefStore.save();
            }
            return file;
        }
        return null;
    }
}

