/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.document.DocumentsAttachViewPeer;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysDocuments;
import in.gov.uidai.swing.ImageIconCache;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsAttachController
extends ControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentsAttachController.class);
    private static final String OK_ICON_PATH = "res/ecmp/images/compliance-ok.png";
    private static final String ERROR_ICON_PATH = "res/ecmp/images/compliance-error.png";
    private static final String DOC_ATTACH_TIP = "Document attached";
    private static final String DOC_NOT_ATTACH_TIP = "Document not attached";
    private final DocumentsAttachViewPeer viewElements;
    private final EnrollmentService enrollmentService;
    private final ActionListener showPreviewListener;
    private final IOucDataStore oucDataStore;

    public DocumentsAttachController(DocumentsAttachViewPeer viewElements) {
        super(viewElements.getView());
        this.viewElements = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.oucDataStore = viewElements.oucDataStore;
        this.showPreviewListener = (ActionListener)viewElements.evtCtxt.getEventListener("hID_ShowPreview", ActionListener.class);
        this.initView();
    }

    private void initView() {
        this.setIconStatus(DocumentType.RECEIPT);
        this.setIconStatus(DocumentType.ENROL_FORM);
        this.setSaveButtonStatus();
        this.enrollmentService.getDocManager().addChangeListener(e -> this.setIconStatus(DocumentType.RECEIPT));
        this.enrollmentService.getDocManager().addChangeListener(e -> this.setIconStatus(DocumentType.ENROL_FORM));
        this.enrollmentService.getDocManager().addChangeListener(e -> this.setSaveButtonStatus());
        this.addActionListener(this.viewElements.receiptAttachBtn, (ActionEvent e) -> this.attachDocument(e, DocumentType.RECEIPT));
        this.addActionListener(this.viewElements.enrolFormAttachBtn, (ActionEvent e) -> this.attachDocument(e, DocumentType.ENROL_FORM));
        this.addActionListener(this.viewElements.receiptScanBtn, (ActionEvent e) -> this.scanDocument(e, DocumentType.RECEIPT));
        this.addActionListener(this.viewElements.enrolFormScanBtn, (ActionEvent e) -> this.scanDocument(e, DocumentType.ENROL_FORM));
    }

    public void attachDocument(ActionEvent evt, DocumentType documentType) {
        JButton parent = (JButton)evt.getSource();
        try {
            File file = DocumentUtils.getInstance().selectPdfFileFromBrowser(parent);
            if (file != null) {
                this.enrollmentService.getDocManager().setCurrentOperatingDocType(documentType);
                DocumentsManager docMan = this.enrollmentService.getDocManager();
                docMan.resetDocument();
                docMan.setDocumentBytes(file);
                String error = docMan.getAttachedDoc().getError();
                if (StringUtils.isNotBlank((String)error)) {
                    docMan.resetDocument();
                    throw new Exception(error);
                }
            }
        }
        catch (Exception e) {
            this.showError(parent, e.getMessage());
            LOGGER.error("Failed to attach document. " + e.getMessage());
        }
    }

    private void scanDocument(ActionEvent evt, DocumentType docType) {
        try {
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            this.enrollmentService.getDocManager().setCurrentOperatingDocType(docType);
            BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(null, null, this.enrollmentService);
            if (bufferedImage == null) {
                throw new Exception("Failed to capture image");
            }
            this.enrollmentService.getDocManager().addNextDocument(bufferedImage, scannerInfo.getLastMode());
            this.showPreviewListener.actionPerformed(evt);
        }
        catch (Exception e) {
            this.enrollmentService.getDocManager().resetDocument();
            this.showError((JButton)evt.getSource(), (Object)MsgKeysDocuments.SCAN_ERROR);
            LOGGER.error("Error while Scanning document.", (Throwable)e);
        }
    }

    private void setSaveButtonStatus() {
        boolean isReceiptAttached = StringUtils.isBlank((String)this.enrollmentService.getDocManager().getError(DocumentType.RECEIPT));
        boolean isEnrolFormAttached = StringUtils.isBlank((String)this.enrollmentService.getDocManager().getError(DocumentType.ENROL_FORM));
        this.viewElements.saveButton.setEnabled(isReceiptAttached && isEnrolFormAttached);
    }

    private void setIconStatus(DocumentType documentType) {
        String toolTip;
        boolean docAttached = StringUtils.isBlank((String)this.enrollmentService.getDocManager().getError(documentType));
        String iconPath = docAttached ? OK_ICON_PATH : ERROR_ICON_PATH;
        String string = toolTip = docAttached ? DOC_ATTACH_TIP : DOC_NOT_ATTACH_TIP;
        if (documentType == DocumentType.RECEIPT) {
            this.viewElements.receiptStatusLbl.setIcon(ImageIconCache.getInst().getIcon(iconPath));
            this.viewElements.receiptStatusLbl.setToolTipText(toolTip);
        }
        if (documentType == DocumentType.ENROL_FORM) {
            this.viewElements.enrolFormStatusLbl.setIcon(ImageIconCache.getInst().getIcon(iconPath));
            this.viewElements.enrolFormStatusLbl.setToolTipText(toolTip);
        }
    }
}

