/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.document.ScannedPage;
import in.gov.uidai.ec.swing.imgvu.DisplayMode;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsConstants;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysDocuments;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsControl
implements IOnScreenDisplayAware,
IDocumentsConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentsControl.class);
    private IOnScreenDisplay osd;
    private IResourceBundleContext rbCtxt;
    private EnrollmentService enrollmentService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setResourceBundleContext(IResourceBundleContext rbc) {
        this.rbCtxt = rbc;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Show_DocDialogue", method="actionPerformed")
    public void onDocDialogueLoad(ILiteEvent evt) {
        ILiteView printView = this.osd.getView(evt.getViewId());
        Window parent = this.osd.getWindowForScaffold(evt.getScaffoldId());
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        ((IViewElement)eMap.get("eID_CompleteEnrollment")).set("enable", (Object)false);
        IVisualExecutionContext veCtxt = printView.getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysDocuments.VEX_DOCWIN_LOAD, new Object[0]));
        }
        try {
            String sId = this.osd.compose(evt.getScaffoldId(), "docAttachWin", "documentAttachView");
            this.osd.display(sId, ScaffoldPlacement.CENTERED);
        }
        catch (Exception e) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysDocuments.WIN_LOAD_ERROR, (Component)parent, new Object[0]);
            LOGGER.debug("Error while loading documents attachment window", (Throwable)e);
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(name="hID_Documents_AttachSave", method="actionPerformed")
    public void onDocumentsSave(ILiteEvent evt) {
        String printScafId = this.osd.getScaffold(evt.getScaffoldId()).getParentId();
        String packetConfirmViewId = this.osd.getScaffold(printScafId).getViewId();
        Map eMap = this.osd.getView(packetConfirmViewId).getElementMap();
        IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(this.rbCtxt.getMessage((Object)MsgKeysDocuments.VEX_DOC_SAVE, new Object[0]));
        }
        try {
            ((IViewElement)eMap.get("eID_CompleteEnrollment")).set("enable", (Object)true);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
        }
        this.osd.dispose(evt.getScaffoldId());
    }

    @EventHandler(name="hID_ShowPreview", method="actionPerformed")
    public void showPreview(ILiteEvent evt) {
        String scafID = this.osd.compose("docScanPreviewWin", "docScanPreview");
        this.osd.display(scafID, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_ScanPreview_Close", method="windowClosing")
    public void onScanPreviewCloseButton(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
        if (!this.enrollmentService.isOnlineUpdate() && this.enrollmentService.getDocManager() != null) {
            this.enrollmentService.getDocManager().resetDocument();
        }
    }

    @GenericEventHandler(value="preview")
    public void previewDocument(DocumentType docType) {
        BufferedImage document = ((ScannedPage)this.enrollmentService.getDocManager().getScannedDoc(docType).getPages().get(0)).getOriginalScannedDocument();
        String scaffoldId = this.osd.compose("displayPreviewImageWin", "displayImageView");
        ((IViewElement)this.osd.getView(this.osd.getScaffold(scaffoldId).getViewId()).getElementMap().get("eID_display_image_preview")).set("image", (Object)document).set("displayMode", (Object)DisplayMode.AUTO_FIT);
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="scan_config", method="actionPerformed")
    public void scanConfig(ILiteEvent event) {
        String scaffoldId = this.osd.compose("scanConfigWin", "scannerConfigViewPeer");
        this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
    }
}

