/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.icas.util.OS;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.RotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.springframework.beans.factory.InitializingBean;

public class ImageTransformUtils
implements InitializingBean {
    public static BufferedImage rotateDocument(BufferedImage bi, double skewAngle) {
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        Mat originalImage = new Mat(bi.getHeight(), bi.getWidth(), CvType.CV_8UC3);
        originalImage.put(0, 0, data);
        Mat image = new Mat();
        Point center = new Point((double)(originalImage.width() / 2), (double)(originalImage.height() / 2));
        Mat rotImage = Imgproc.getRotationMatrix2D((Point)center, (double)skewAngle, (double)1.0);
        double cos = Math.abs(rotImage.get(0, 0)[0]);
        double sin = Math.abs(rotImage.get(0, 1)[0]);
        int newWidth = (int)((double)originalImage.height() * sin + (double)originalImage.width() * cos);
        int newHeight = (int)((double)originalImage.height() * cos + (double)originalImage.width() * sin);
        int newCenterX = (newWidth - originalImage.width()) / 2;
        int newCenterY = (newHeight - originalImage.height()) / 2;
        rotImage.put(0, 2, new double[]{rotImage.get(0, 2)[0] + (double)newCenterX});
        rotImage.put(1, 2, new double[]{rotImage.get(1, 2)[0] + (double)newCenterY});
        Size size = new Size((double)newWidth, (double)newHeight);
        Imgproc.warpAffine((Mat)originalImage, (Mat)image, (Mat)rotImage, (Size)size, (int)4, (int)0, (Scalar)new Scalar(255.0, 255.0, 255.0));
        BufferedImage rotatedImage = image.channels() > 1 ? new BufferedImage(image.width(), image.height(), 5) : new BufferedImage(image.width(), image.height(), 10);
        byte[] imageData = ((DataBufferByte)rotatedImage.getRaster().getDataBuffer()).getData();
        image.get(0, 0, imageData);
        return rotatedImage;
    }

    public static double computeSkew(BufferedImage bi) {
        int kernelSize = 3;
        int cannyLowerThreshold = 25;
        int cannyUpperThreshold = 50;
        Mat image = new Mat();
        Mat blur = new Mat();
        Mat edged = new Mat();
        Mat dilate = new Mat();
        Mat erode = new Mat();
        int maxValIdx = 0;
        double area = 0.0;
        ArrayList contours = new ArrayList();
        byte[] data = ((DataBufferByte)bi.getRaster().getDataBuffer()).getData();
        Mat mat = new Mat(bi.getHeight(), bi.getWidth(), CvType.CV_8UC3);
        mat.put(0, 0, data);
        Mat img = new Mat();
        Imgproc.cvtColor((Mat)mat, (Mat)img, (int)6);
        Imgproc.adaptiveThreshold((Mat)img, (Mat)img, (double)255.0, (int)0, (int)0, (int)15, (double)40.0);
        Core.bitwise_not((Mat)img, (Mat)img);
        Mat kernel = Imgproc.getStructuringElement((int)0, (Size)new Size((double)kernelSize, (double)kernelSize));
        Imgproc.morphologyEx((Mat)img, (Mat)image, (int)3, (Mat)kernel);
        Imgproc.GaussianBlur((Mat)image, (Mat)blur, (Size)new Size(7.0, 7.0), (double)0.0);
        Imgproc.Canny((Mat)blur, (Mat)edged, (double)cannyLowerThreshold, (double)cannyUpperThreshold);
        Imgproc.dilate((Mat)edged, (Mat)dilate, (Mat)kernel, (Point)new Point(-1.0, -1.0), (int)6);
        Imgproc.erode((Mat)dilate, (Mat)erode, (Mat)kernel, (Point)new Point(-1.0, -1.0), (int)3);
        Imgproc.findContours((Mat)erode, contours, (Mat)new Mat(), (int)1, (int)2);
        for (int contourIdx = 0; contourIdx < contours.size(); ++contourIdx) {
            Rect rect = Imgproc.boundingRect((Mat)((Mat)contours.get(contourIdx)));
            if (!((double)(rect.height * rect.width) > area)) continue;
            area = rect.height * rect.width;
            maxValIdx = contourIdx;
        }
        RotatedRect rotatedRect = Imgproc.minAreaRect((MatOfPoint2f)new MatOfPoint2f(((MatOfPoint)contours.get(maxValIdx)).toArray()));
        double skew = rotatedRect.angle;
        skew = (skew %= 90.0) < -45.0 ? skew + 90.0 : skew;
        return skew %= 90.0;
    }

    public void afterPropertiesSet() {
        if (OS.IsWindows()) {
            System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        }
    }
}

