/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.document;

import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.ButtonFactory;
import in.gov.uidai.ec.swing.TipListCellRenderer;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsPreference;
import in.gov.uidai.ec.ui.enrol.document.ScannerConfigController;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDocuments;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class ScannerConfigComposite
implements IViewElementComposite {
    protected final IDocumentsPreference docPref;
    private final TransparentBox scannerArea;
    private final IResourceBundleContext rbCtxt;
    private final boolean showScanMode;
    protected ILiteView view;
    protected IPreferenceStore prefStore;
    protected IOucDataStore oucDataStore;
    protected JComboBox<String> scannerList;
    protected JButton refreshBtn;
    protected JRadioButton colorOpt;
    private boolean isOnline;

    public ScannerConfigComposite(IResourceBundleContext rbCtxt, IDocumentsPreference docPref, IOucDataStore oucDataStore, ILiteView view, IPreferenceStore prefStore, boolean showScanMode) {
        this.rbCtxt = rbCtxt;
        this.docPref = docPref;
        this.oucDataStore = oucDataStore;
        this.showScanMode = showScanMode;
        this.scannerArea = this.createScannerConfigArea();
        this.view = view;
        this.prefStore = prefStore;
    }

    public ScannerConfigComposite(IResourceBundleContext rbCtxt, IDocumentsPreference docPref, IOucDataStore oucDataStore, ILiteView view, IPreferenceStore prefStore, boolean showScanMode, boolean isOnline) {
        this.rbCtxt = rbCtxt;
        this.docPref = docPref;
        this.oucDataStore = oucDataStore;
        this.showScanMode = showScanMode;
        this.isOnline = isOnline;
        this.scannerArea = this.createScannerConfigArea();
        this.view = view;
        this.prefStore = prefStore;
    }

    private TransparentBox createScannerConfigArea() {
        double[][] guides = new double[][]{{470.0, 20.0, 30.0, -1.0}, {10.0, 30.0, 12.0, 25.0, 5.0}};
        TransparentBox result = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.scannerList = new JComboBox();
        this.scannerList.setRenderer(new TipListCellRenderer(this.scannerList));
        this.scannerList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.scannerList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        result.add((Component)new PanelBuilder().createPanel(LabelKeysDocuments.SCANNER.toString(), this.scannerList, false, this.rbCtxt), (Object)"0, 1, right, full");
        this.refreshBtn = new ButtonFactory(this.rbCtxt).createButton("res/ecmp/images/but-refresh.png", "Refresh list");
        this.refreshBtn.setPreferredSize(new Dimension(25, 25));
        result.add((Component)this.refreshBtn, (Object)"2, 1, full, full");
        JComponent scanModeArea = this.createScanModeArea();
        if (this.showScanMode) {
            result.add((Component)scanModeArea, (Object)"0, 3, left, full");
        }
        new ScannerConfigController(this);
        return result;
    }

    private JComponent createScanModeArea() {
        this.colorOpt = new JRadioButton(this.rbCtxt.getMessage((Object)LabelKeysDocuments.COLOR, new Object[0]));
        this.colorOpt.setActionCommand("COLOR");
        this.colorOpt.setName("Color");
        ButtonGroup scanModeGrp = new ButtonGroup();
        scanModeGrp.add(this.colorOpt);
        TransparentBox scanModePanel = new TransparentBox((LayoutManager)new FlowLayout());
        scanModePanel.add((Component)this.colorOpt);
        String label = LabelKeysDocuments.SCAN_MODE.toString();
        return new PanelBuilder().createPanel(label, (JComponent)scanModePanel, null, null, false, this.rbCtxt, true);
    }

    public JComponent toSwing() {
        return this.scannerArea;
    }
}

