/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.fingerprint;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.FingerPrint;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.fingerprint.FingerPrintTabViewPeer;
import in.gov.uidai.ec.ui.enrol.fingerprint.IFingerTabConstants;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

class FingerPrintController
extends EnrollmentControllerBase
implements IFingerTabConstants {
    private final FingerPrintTabViewPeer viewElements;
    private final HashMap<String, HashMap<String, Object>> evtParams = new HashMap<String, HashMap<String, Object>>(){
        {
            this.put("eID_FingerTab_LeftSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_LeftSlap");
                }
            });
            this.put("eID_FingerTab_RightSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_RightSlap");
                }
            });
            this.put("eID_FingerTab_ThumbSlap", new HashMap<String, Object>(){
                {
                    this.put("prm_BioFieldName", "eID_FingerTab_ThumbSlap");
                }
            });
        }
    };

    FingerPrintController(ILiteView view, FingerPrintTabViewPeer viewElements, EnrollmentService enrollmentService, int maxCaptureAttempts, int tabIndex) {
        super(view, enrollmentService, 3, tabIndex);
        this.viewElements = viewElements;
        enrollmentService.getFingerPrint().setMaxCaptureAttempt(maxCaptureAttempts);
        this.initView();
    }

    private void initView() {
        IEventContext evtCtxt = this.viewElements.evtCtxt;
        FingerPrint fingerPrint = this.enrollmentService.getFingerPrint();
        Biometrics leftSlap = fingerPrint.getLeftSlap();
        Biometrics rightSlap = fingerPrint.getRightSlap();
        Biometrics bothThumbs = fingerPrint.getBothThumbs();
        BiometricsCaptureField leftSlapField = this.viewElements.fingerPrintPanel.leftSlapField;
        BiometricsCaptureField rightSlapField = this.viewElements.fingerPrintPanel.rightSlapField;
        BiometricsCaptureField thumbSlapField = this.viewElements.fingerPrintPanel.thumbSlapField;
        this.addListenersOnBiometricField(evtCtxt, leftSlap, leftSlapField, "eID_FingerTab_LeftSlap");
        this.addListenersOnBiometricField(evtCtxt, rightSlap, rightSlapField, "eID_FingerTab_RightSlap");
        this.addListenersOnBiometricField(evtCtxt, bothThumbs, thumbSlapField, "eID_FingerTab_ThumbSlap");
        fingerPrint.addFingerprintBiometricExceptionChangeListener(this::onBiometricsExceptionChange);
        fingerPrint.addMandatoryChangeListener(this::onFingerPrintMandatoryChange);
        fingerPrint.addValidityChangeListener(this::updateTabValidityState);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.addActionListener(this.viewElements.navigationPanel.nextBut, this::onNextButtonClick);
        this.addActionListener(this.viewElements.navigationPanel.previousBut, this::onPrevButtonClick);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateChange);
    }

    private void addListenersOnBiometricField(IEventContext evtCtxt, Biometrics biometrics, BiometricsCaptureField biometricsField, String slapEid) {
        biometricsField.addQSSActionListener((ActionListener)evtCtxt.getEventListener("hID_QSS_Slap", ActionListener.class, (Map)this.evtParams.get(slapEid)));
        biometricsField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSS_Slap_Capture", IBiometricsListener.class, (Map)this.evtParams.get(slapEid)));
        biometricsField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_FingerCapture", IBiometricsListener.class));
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> biometrics.addCaptureAttempt(captureAttempt));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> biometrics.deleteCaptureAttempt(captureAttempt));
        biometricsField.addBestCaptureAttemptChangeListeners((pos, bestAttempt) -> biometrics.setBestAttempt(bestAttempt));
        biometricsField.addCaptureAttemptClearChangeListener(pos -> biometrics.clearAttempts());
    }

    private void onViewLoadComplete(Object o) {
        AgeDob ageDob = this.enrollmentService.getDemoPersonalDetails().getAgeDob();
        boolean enable = this.enrollmentService.isBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() && ageDob.isValid() && !ageDob.isChild();
        super.updateTabInteractionState(enable);
    }

    private void onBiometricUpdateChange(Boolean biometricUpdate) {
        this.viewElements.fingerPrintPanel.leftSlapField.clear();
        this.viewElements.fingerPrintPanel.rightSlapField.clear();
        this.viewElements.fingerPrintPanel.thumbSlapField.clear();
    }

    private void onFingerPrintMandatoryChange(boolean isMandatory) {
        this.viewElements.fingerPrintPanel.leftSlapField.setEnabled(isMandatory);
        this.viewElements.fingerPrintPanel.rightSlapField.setEnabled(isMandatory);
        this.viewElements.fingerPrintPanel.thumbSlapField.setEnabled(isMandatory);
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            super.updateTabInteractionState(isMandatory);
        }
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        boolean leftSlapEnable = true;
        boolean rightSlapEnable = true;
        boolean bothThumbEnable = true;
        if (biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftSlapExceptionApplied()) {
                leftSlapEnable = false;
            }
            if (biometricsExceptionDetail.isRightSlapExceptionApplied()) {
                rightSlapEnable = false;
            }
            if (biometricsExceptionDetail.isBothThumbsExceptionApplied()) {
                bothThumbEnable = false;
            }
        }
        this.viewElements.fingerPrintPanel.leftSlapField.setEnabled(leftSlapEnable);
        this.viewElements.fingerPrintPanel.rightSlapField.setEnabled(rightSlapEnable);
        this.viewElements.fingerPrintPanel.thumbSlapField.setEnabled(bothThumbEnable);
    }
}

