/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.fingerprint;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.NucleusLayout;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureGroup;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FingerPrintPanel
implements IViewElementComposite {
    private final IResourceBundleContext resBundleCtxt;
    private final IUIPreference uiPref;
    private final IClientDeviceManager cdm;
    private final IBioxDataProvider bdp;
    @ExportViewElement(as="eID_FingerTab_LeftSlap", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField leftSlapField;
    @ExportViewElement(as="eID_FingerTab_RightSlap", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField rightSlapField;
    @ExportViewElement(as="eID_FingerTab_ThumbSlap", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField thumbSlapField;
    private AbstractPreviewPlayer previewPlayer;
    private EnrollmentService enrollmentService;

    public FingerPrintPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, IBioxDataProvider bdp) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.bdp = bdp;
    }

    public FingerPrintPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, IBioxDataProvider bdp, EnrollmentService enrollmentService) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.bdp = bdp;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        this.previewPlayer = new PreviewPlayer2();
        L10nDecorator ldeco = new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false));
        this.leftSlapField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_SLAP_LEFT, BiometricPosition.LEFT_SLAP);
        this.rightSlapField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_SLAP_RIGHT, BiometricPosition.RIGHT_SLAP);
        this.thumbSlapField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_THUMBS, BiometricPosition.BOTH_THUMBS);
        BiometricsCaptureGroup capGrp = new BiometricsCaptureGroup();
        capGrp.addField(this.leftSlapField);
        capGrp.addField(this.rightSlapField);
        capGrp.addField(this.thumbSlapField);
        TransparentBox fingerPanel = new TransparentBox((LayoutManager)new NucleusLayout(5, 5));
        fingerPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        fingerPanel.add((Component)this.previewPlayer, (Object)"Center");
        fingerPanel.add((Component)this.leftSlapField);
        fingerPanel.add((Component)this.rightSlapField);
        fingerPanel.add((Component)this.thumbSlapField);
        fingerPanel.setOpaque(true);
        fingerPanel.setBackground(Color.GRAY);
        fingerPanel.setFocusable(true);
        return fingerPanel;
    }

    private BiometricsCaptureField initBiometricsCaptureField(L10nDecorator ldeco, LabelKeysBio label, BiometricPosition biometricPosition) {
        BiometricsCaptureField biometricCaptureField = this.enrollmentService != null && this.enrollmentService.isUniversalClientTrnx() ? new BiometricsCaptureField(label.toString(), biometricPosition, new EnrollmentService[]{this.enrollmentService}) : new BiometricsCaptureField(label.toString(), biometricPosition, new EnrollmentService[0]);
        biometricCaptureField.localize(ldeco);
        biometricCaptureField.setQSSEnabled(true);
        biometricCaptureField.setPreviewPlayer(this.previewPlayer);
        biometricCaptureField.setClientDeviceManager(this.cdm);
        biometricCaptureField.setEnabled(true);
        biometricCaptureField.setBioxDataProvider(this.bdp);
        biometricCaptureField.setForceCaptureMinDelay(this.uiPref.getForceCaptureMinDelay("10s").getValue());
        biometricCaptureField.getFingerMismatchCounter().setMinFingerMismatchAttempts(this.uiPref.getMinFingerMismatchAttempts(4));
        biometricCaptureField.setMaxAttempts(this.uiPref.getMaxCaptureAttempts(5));
        biometricCaptureField.setMinimumSize(new Dimension(200, 150));
        biometricCaptureField.setPreferredSize(new Dimension(300, 350));
        return biometricCaptureField;
    }

    public IBioxDataProvider getBdp() {
        return this.bdp;
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        eftp.addComponent((Component)this.leftSlapField).addComponent((Component)this.rightSlapField).addComponent((Component)this.thumbSlapField);
    }

    public BiometricsCaptureField getLeftSlapField() {
        return this.leftSlapField;
    }

    public BiometricsCaptureField getRightSlapField() {
        return this.rightSlapField;
    }

    public BiometricsCaptureField getThumbSlapField() {
        return this.thumbSlapField;
    }
}

