/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.iris;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.Iris;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.iris.IrisPanel;
import in.gov.uidai.ec.ui.enrol.iris.IrisTabViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;

public class IrisController
extends EnrollmentControllerBase
implements INavigationConstants {
    private final IrisTabViewPeer viewElements;
    private final EnrollmentService enrollmentService;

    IrisController(IrisTabViewPeer viewElements, int tabIndex) {
        super(viewElements.view, viewElements.enrollmentService, 4, tabIndex);
        this.viewElements = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.enrollmentService.getIris().setMaxCaptureAttempt(viewElements.uiPref.getMaxCaptureAttempts(5));
        this.initView();
    }

    private void initView() {
        Iris iris = this.enrollmentService.getIris();
        BiometricsCaptureField leftEyeField = this.viewElements.irisPanel.leftEyeField;
        BiometricsCaptureField rightEyeField = this.viewElements.irisPanel.rightEyeField;
        BiometricsCaptureField bothEyesField = this.viewElements.irisPanel.bothEyesField;
        this.addListenersToBiometricField(iris, leftEyeField, "eID_IrisTab_LeftEye", BiometricPosition.LEFT_IRIS, "hID_QSS_Iris_Capture");
        this.addListenersToBiometricField(iris, rightEyeField, "eID_IrisTab_RightEye", BiometricPosition.RIGHT_IRIS, "hID_QSS_Iris_Capture");
        this.addListenersToBiometricField(iris, bothEyesField, "eID_IrisTab_BothEyes", BiometricPosition.BOTH_IRIS, "hID_QSS_Dual_Iris_Capture");
        this.viewElements.irisPanel.irisCaptureModeOpt.addActionListener(this::onIrisModeOptionChange);
        iris.addIrisBiometricExceptionChangeListener(this::onBiometricsExceptionChange);
        iris.addMandatoryChangeListener(this::onIrisMandatoryChange);
        iris.addValidityChangeListener(this::updateTabValidityState);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.addActionListener(this.viewElements.navigationPanel.nextBut, this::onNextButtonClick);
        this.addActionListener(this.viewElements.navigationPanel.previousBut, this::onPrevButtonClick);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateChange);
    }

    private void addListenersToBiometricField(Iris iris, BiometricsCaptureField biometricsField, String irisEid, BiometricPosition position, String hidQssIrisCapture) {
        this.addQSSListener(irisEid, biometricsField, position, "hID_QSS_Iris", this.viewElements.evtCtxt);
        this.addBioListener(irisEid, biometricsField, hidQssIrisCapture, this.viewElements.evtCtxt);
        biometricsField.addBiometricsListener((IBiometricsListener)this.viewElements.evtCtxt.getEventListener("hID_QSSDedup_IrisCapture", IBiometricsListener.class));
        biometricsField.addCaptureAttemptAdditionChangeListener((arg_0, arg_1) -> ((Iris)iris).setCaptureAttempts(arg_0, arg_1));
        biometricsField.addCaptureAttemptDeletionChangeListener((arg_0, arg_1) -> ((Iris)iris).setDeletedAttempts(arg_0, arg_1));
        biometricsField.addBestCaptureAttemptChangeListeners((arg_0, arg_1) -> ((Iris)iris).setBestAttempt(arg_0, arg_1));
        biometricsField.addCaptureAttemptClearChangeListener(arg_0 -> ((Iris)iris).clearAttempts(arg_0));
    }

    private void onViewLoadComplete(Object o) {
        boolean enable = this.enrollmentService.isBiometricUpdate() || !this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild() && this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAge() >= 5;
        super.updateTabInteractionState(enable);
    }

    private void onBiometricUpdateChange(Boolean biometricUpdate) {
        this.viewElements.irisPanel.bothEyesField.clear();
        this.viewElements.irisPanel.leftEyeField.clear();
        this.viewElements.irisPanel.rightEyeField.clear();
    }

    private void onIrisMandatoryChange(boolean isMandatory) {
        this.viewElements.irisPanel.leftEyeField.setEnabled(isMandatory);
        this.viewElements.irisPanel.rightEyeField.setEnabled(isMandatory);
        this.viewElements.irisPanel.bothEyesField.setEnabled(isMandatory);
        super.updateTabInteractionState(isMandatory);
    }

    private void onIrisModeOptionChange(ActionEvent event) {
        this.enrollmentService.getIris().setCaptureBothIrisSeparately(((JCheckBox)event.getSource()).isSelected());
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        boolean leftIrisEnabled = true;
        boolean rightIrisEnabled = true;
        boolean captureEachEyeSeparately = false;
        if (biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied()) {
            if (biometricsExceptionDetail.isLeftEyeExceptionApplied()) {
                leftIrisEnabled = false;
                captureEachEyeSeparately = true;
            }
            if (biometricsExceptionDetail.isRightEyeExceptionApplied()) {
                rightIrisEnabled = false;
                captureEachEyeSeparately = true;
            }
        }
        IrisPanel irisPanel = this.viewElements.irisPanel;
        irisPanel.leftEyeField.setEnabled(leftIrisEnabled);
        irisPanel.leftEyeField.setVisible(captureEachEyeSeparately);
        irisPanel.rightEyeField.setEnabled(rightIrisEnabled);
        irisPanel.rightEyeField.setVisible(captureEachEyeSeparately);
        irisPanel.bothEyesField.setEnabled(!captureEachEyeSeparately);
        irisPanel.bothEyesField.setVisible(!captureEachEyeSeparately);
        irisPanel.irisCaptureModeOpt.setSelected(captureEachEyeSeparately);
        irisPanel.irisCaptureModeOpt.setEnabled(!captureEachEyeSeparately);
    }

    private void addQSSListener(String fieldName, BiometricsCaptureField field, BiometricPosition bioPos, String hid, IEventContext evtCtxt) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        if (bioPos != null) {
            evtParams.put("prm_BioFieldSubType", (String)bioPos);
            field.addQSSActionListener((ActionListener)evtCtxt.getEventListener(hid, ActionListener.class, evtParams), bioPos);
        } else {
            field.addQSSActionListener((ActionListener)evtCtxt.getEventListener(hid, ActionListener.class, evtParams));
        }
    }

    private void addBioListener(String fieldName, BiometricsCaptureField field, String hid, IEventContext evtCtxt) {
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", fieldName);
        field.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener(hid, IBiometricsListener.class, evtParams));
    }
}

