/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.iris;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.NucleusLayout;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureGroup;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class IrisPanel
implements IViewElementComposite {
    private final IResourceBundleContext resBundleCtxt;
    private final IBioxDataProvider bdp;
    private final IUIPreference uiPref;
    private final IClientDeviceManager cdm;
    @ExportViewElement(as="eID_IrisTab_LeftEye", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField leftEyeField;
    @ExportViewElement(as="eID_IrisTab_RightEye", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField rightEyeField;
    @ExportViewElement(as="eID_IrisTab_BothEyes", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField bothEyesField;
    @ExportViewElement(as="eID_IrisTab_ModeOpt", using=StandardSwingElementFactory.class)
    protected JCheckBox irisCaptureModeOpt;
    private AbstractPreviewPlayer previewPlayer;
    private EnrollmentService enrollmentService;

    IrisPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, IBioxDataProvider bdp) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.bdp = bdp;
    }

    public IrisPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, IBioxDataProvider bdp, EnrollmentService enrollmentService) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.bdp = bdp;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        this.previewPlayer = new PreviewPlayer2();
        L10nDecorator ldeco = new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false));
        this.leftEyeField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_IRIS_LEFT, BiometricPosition.LEFT_IRIS, 450);
        this.rightEyeField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_IRIS_RIGHT, BiometricPosition.RIGHT_IRIS, 450);
        BiometricsCaptureGroup bioGrp = new BiometricsCaptureGroup();
        bioGrp.addField(this.leftEyeField);
        bioGrp.addField(this.rightEyeField);
        this.bothEyesField = this.initBiometricsCaptureField(ldeco, LabelKeysBio.CAPTURE_IRIS_BOTH, BiometricPosition.BOTH_IRIS, 900);
        this.irisCaptureModeOpt = new JCheckBox(this.resBundleCtxt.getMessage((Object)LabelKeysBio.CAPTURE_IRIS_MODE, new Object[0]));
        this.irisCaptureModeOpt.setVisible(false);
        ldeco.localize((AbstractButton)this.irisCaptureModeOpt, (Object)LabelKeysBio.CAPTURE_IRIS_MODE, new Object[0]);
        new ToggleButtonAssociation().forButton(this.irisCaptureModeOpt, true).show(new JComponent[]{this.leftEyeField, this.rightEyeField}).hide(new JComponent[]{this.bothEyesField});
        TransparentBox irisPanel = new TransparentBox((LayoutManager)new NucleusLayout(5, 5));
        irisPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        irisPanel.add((Component)this.previewPlayer, (Object)"Center");
        irisPanel.add((Component)this.rightEyeField);
        irisPanel.add((Component)this.leftEyeField);
        irisPanel.add((Component)this.bothEyesField);
        irisPanel.setOpaque(true);
        irisPanel.setBackground(Color.GRAY);
        irisPanel.setFocusable(true);
        this.leftEyeField.setVisible(false);
        this.rightEyeField.setVisible(false);
        return irisPanel;
    }

    private BiometricsCaptureField initBiometricsCaptureField(L10nDecorator ldeco, LabelKeysBio label, BiometricPosition biometricPosition, int preferredWidth) {
        BiometricsCaptureField biometricCaptureField = this.enrollmentService != null && this.enrollmentService.isUniversalClientTrnx() ? new BiometricsCaptureField(label.toString(), biometricPosition, new EnrollmentService[]{this.enrollmentService}) : new BiometricsCaptureField(label.toString(), biometricPosition, new EnrollmentService[0]);
        biometricCaptureField.localize(ldeco);
        biometricCaptureField.setQSSEnabled(true);
        biometricCaptureField.setPreviewPlayer(this.previewPlayer);
        biometricCaptureField.setClientDeviceManager(this.cdm);
        biometricCaptureField.setBioxDataProvider(this.bdp);
        biometricCaptureField.setMaxAttempts(this.uiPref.getMaxCaptureAttempts(5));
        biometricCaptureField.setEnabled(true);
        biometricCaptureField.setMinimumSize(new Dimension(200, 200));
        biometricCaptureField.setPreferredSize(new Dimension(preferredWidth, 450));
        return biometricCaptureField;
    }

    public void addToFocusTraversalPolicy(ExplicitFocusTraversalPolicy eftp) {
        eftp.addComponent((Component)this.bothEyesField).addComponent((Component)this.rightEyeField).addComponent((Component)this.leftEyeField).addComponent((Component)this.irisCaptureModeOpt);
    }

    public JCheckBox getIrisCaptureModeOption() {
        return this.irisCaptureModeOpt;
    }

    public BiometricsCaptureField getLeftEyeField() {
        return this.leftEyeField;
    }

    public BiometricsCaptureField getRightEyeField() {
        return this.rightEyeField;
    }

    public BiometricsCaptureField getBothEyesField() {
        return this.bothEyesField;
    }
}

