/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.iris;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.NavigationPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.iris.IrisController;
import in.gov.uidai.ec.ui.enrol.iris.IrisPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewTabViewPeer;
import in.gov.uidai.ec.ui.enrol.universalClient.viewPeer.ReviewTabViewPeerUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class IrisTabViewPeer
implements IViewElementComposite,
INavigationConstants {
    protected final ILiteView view;
    protected final EnrollmentService enrollmentService;
    private final IClientDeviceManager cdm;
    private final IBioxDataProvider bioxDataProvider;
    private final IResourceBundleContext rbCtx;
    protected IUIPreference uiPref;
    protected NavigationPanel navigationPanel;
    protected IEventContext evtCtxt;
    protected IrisPanel irisPanel;
    protected ReviewTabViewPeer reviewTab;
    protected ReviewTabViewPeerUC reviewTabUC;
    private TransparentBox irisView;
    private JTabbedPane tabbedPane;
    private int tabIndex;

    public IrisTabViewPeer(EnrolViewPeer enrolViewPeer) {
        this.view = enrolViewPeer.getView();
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.reviewTab = enrolViewPeer.getReviewTab();
        this.reviewTabUC = enrolViewPeer.getReviewTabUC();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.rbCtx = enrolViewPeer.clientRbCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.cdm = enrolViewPeer.cdm;
        this.bioxDataProvider = enrolViewPeer.bdp;
    }

    public void prepare() {
        this.navigationPanel = new NavigationPanel(this.rbCtx, this.uiPref);
        this.irisPanel = new IrisPanel(this.rbCtx, this.uiPref, this.cdm, this.bioxDataProvider);
        if (this.enrollmentService.isUniversalClientTrnx() && this.enrollmentService.getSid() != null) {
            this.irisPanel = new IrisPanel(this.rbCtx, this.uiPref, this.cdm, this.bioxDataProvider, this.enrollmentService);
        }
        this.irisView = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.irisView.add((Component)this.irisPanel.create(), (Object)"Center");
        this.irisView.add((Component)this.navigationPanel.create(this.irisPanel.getIrisCaptureModeOption()), (Object)"South");
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.irisView);
        this.irisPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.navigationPanel.previousBut).addComponent((Component)this.navigationPanel.nextBut);
        new IrisController(this, this.tabIndex);
    }

    public void renderIrisTab() {
        this.tabbedPane.addTab(this.rbCtx.getMessage((Object)LabelKeysTab.IRIS, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createIrisTabLabel());
    }

    private JLabel createIrisTabLabel() {
        String ICON_PATH_ERROR = "res/images/tab-error.png";
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH_ERROR);
        JLabel label = new JLabel(this.rbCtx.getMessage((Object)LabelKeysTab.IRIS, new Object[0]));
        new L10nDecorator(this.rbCtx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.IRIS, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public JComponent toSwing() {
        return this.irisView;
    }
}

