/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import in.gov.uidai.ec.swing.CustomRoundedBorder;
import in.gov.uidai.ec.ui.enrol.operator.TransactionType;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FieldTransactionTypePanel
extends JPanel
implements IViewElementComposite {
    private final TransactionType transactionType;
    private JLabel label;
    private static final Color customBlue = new Color(19, 126, 178);
    private boolean enabled;
    private boolean selected;
    private final CustomRoundedBorder roundedBorderBlue = new CustomRoundedBorder(customBlue, 12, false);
    private final CustomRoundedBorder roundedBorderGray = new CustomRoundedBorder(Color.gray, 12, false);
    private final CustomRoundedBorder roundedFilledBorder = new CustomRoundedBorder(customBlue, 12, true);

    public FieldTransactionTypePanel(TransactionType transactionType) {
        this.transactionType = transactionType;
        this.enabled = true;
        this.selected = false;
        this.label = new JLabel(transactionType.getText());
        this.label.setForeground(customBlue);
        this.label.setFont(new Font("Segoe UI", 1, 14));
        this.setLayout(new GridBagLayout());
        this.add(this.label);
        this.setBorder(this.roundedBorderBlue);
        this.setCursor(new Cursor(12));
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.enabled != b) {
            this.enabled = b;
            if (this.enabled) {
                this.setBorder(this.roundedBorderBlue);
                this.setBackground(Color.WHITE);
                this.label.setForeground(customBlue);
                this.setCursor(new Cursor(12));
            } else {
                this.setBorder(this.roundedBorderGray);
                this.setBackground(Color.WHITE);
                this.label.setForeground(Color.GRAY);
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void setSelected(boolean b) {
        if (this.enabled && this.selected != b) {
            this.selected = b;
            if (this.selected) {
                this.setBorder(this.roundedFilledBorder);
                this.label.setForeground(Color.WHITE);
            } else {
                this.setBorder(this.roundedBorderBlue);
                this.label.setForeground(customBlue);
            }
        }
    }
}

