/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class NoticeBoardPanel
extends JPanel {
    private static final Color BG_COLOR = new Color(255, 255, 200);
    private static final Color HEADER_BG = new Color(255, 230, 150);
    private static final Font HEADER_FONT = new Font("Arial", 1, 18);
    private static final Font BODY_FONT = new Font("Arial", 0, 14);
    private static final int WIDTH = 280;
    private static final int BLINK_DELAY = 500;
    private final JEditorPane htmlPane;
    private List<String> bulletLines;
    private boolean blinkOn = false;
    private Timer blinkTimer;

    public NoticeBoardPanel(List<String> bulletLines, String title) {
        this.bulletLines = bulletLines;
        this.setLayout(new BorderLayout());
        this.setBackground(BG_COLOR);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), new EmptyBorder(5, 10, 10, 10)));
        JLabel header = new JLabel(title, 0);
        header.setFont(HEADER_FONT);
        header.setOpaque(true);
        header.setBackground(HEADER_BG);
        header.setForeground(Color.BLACK);
        header.setBorder(new EmptyBorder(8, 5, 8, 5));
        this.add((Component)header, "North");
        this.htmlPane = new JEditorPane();
        this.htmlPane.setContentType("text/html");
        this.htmlPane.setEditable(false);
        this.htmlPane.setOpaque(false);
        this.htmlPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.htmlPane.setFont(BODY_FONT);
        JScrollPane scroll = new JScrollPane(this.htmlPane);
        scroll.setBorder(null);
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        this.add((Component)scroll, "Center");
        this.updateContent();
        this.startBlinking();
    }

    private void startBlinking() {
        this.blinkTimer = new Timer(500, e -> {
            this.blinkOn = !this.blinkOn;
            this.updateContent();
        });
        this.blinkTimer.start();
    }

    public void stopBlinking() {
        if (this.blinkTimer != null && this.blinkTimer.isRunning()) {
            this.blinkTimer.stop();
        }
    }

    public void setBulletLines(List<String> newLines) {
        this.bulletLines = newLines != null ? newLines : Collections.emptyList();
        this.updateContent();
    }

    private void updateContent() {
        String color = this.blinkOn ? "red" : "black";
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><style>").append("div.entry { margin: 8px 0 8px 20px; line-height: 1.6; color: ").append(color).append("; }").append("hr { border: none; border-top: 1px solid #aaa; margin: 6px 0; }").append("</style></head><body style='margin:0; font-family:Arial; font-size:14px;'>");
        for (int i = 0; i < this.bulletLines.size(); ++i) {
            sb.append("<div class='entry'>").append(this.escape(this.bulletLines.get(i))).append("</div>");
            if (i >= this.bulletLines.size() - 1) continue;
            sb.append("<hr>");
        }
        sb.append("</body></html>");
        this.htmlPane.setText(sb.toString());
        this.htmlPane.setCaretPosition(0);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(280, d.height);
    }

    private String escape(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

