/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import in.gov.uidai.ec.oauthapi.json.srnapi.AgeGroup;
import in.gov.uidai.ec.oauthapi.json.srnapi.RequestType;
import in.gov.uidai.ec.oauthapi.json.srnapi.ResidentType;

public enum TransactionType {
    ADULT_ENROL(Type.N, RequestType.N, ResidentType.CITIZEN, AgeGroup.ABOVE18, "Adult Enrolment (18 Years and above)"),
    CHILD_ENROL_BELOW_5(Type.N, RequestType.N, ResidentType.CITIZEN, AgeGroup.BELOW5, "Child Enrolment (Below 5 years)"),
    CHILD_ENROL_ABOVE_5(Type.N, RequestType.N, ResidentType.CITIZEN, AgeGroup.BELOW18, "Child Enrolment (5 year and below 18 years)"),
    UPDATE(Type.U, RequestType.U, ResidentType.CITIZEN, AgeGroup.ALL, "Update Aadhaar"),
    FIND_AADHAAR(Type.S, RequestType.S, ResidentType.ALL, AgeGroup.ALL, "Find Aadhaar"),
    PVC(Type.S, RequestType.S, ResidentType.ALL, AgeGroup.ALL, "PVC Card");

    private final Type type;
    private final RequestType requestType;
    private final String text;
    private final AgeGroup ageGroup;
    private final ResidentType residentType;

    private TransactionType(Type type, RequestType requestType, ResidentType residentType, AgeGroup ageGroup, String text) {
        this.type = type;
        this.requestType = requestType;
        this.text = text;
        this.residentType = residentType;
        this.ageGroup = ageGroup;
    }

    public Type getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public AgeGroup getAgeGroup() {
        return this.ageGroup;
    }

    public ResidentType getResidentType() {
        return this.residentType;
    }

    public static enum Type {
        N("New Enrolment"),
        U("Update"),
        S("Value Added Services");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

