/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import com.google.common.base.Strings;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.operator.FieldTransactionTypePanel;
import in.gov.uidai.ec.ui.enrol.operator.TransactionType;
import in.gov.uidai.ec.ui.enrol.operator.TransactionTypesViewPeer;
import in.gov.uidai.ec.ui.oponlinelogin.IOperatorOnlineLoginConstants;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class TransactionTypeController
extends EnrollmentControllerBase
implements IOperatorOnlineLoginConstants {
    private final IVisualExecutionContext veCtxt;
    private final TransactionTypesViewPeer view;
    private ActionEvent event;

    public TransactionTypeController(TransactionTypesViewPeer view) {
        super(view.getView(), view.enrollmentService, 0, 0);
        this.veCtxt = view.getView().getVisualExecutionContext();
        this.view = view;
        this.initView();
    }

    private void initView() {
        super.addActionListener(this.view.consentPanel.nextBut, this::onNextButtonClick);
        super.addActionListener(this.view.consentPanel.pacBut, this::onPacAccessClick);
        this.view.transactionTypesPanel.getFieldTransactionTypePanels().forEach(field -> this.addMouseListener((FieldTransactionTypePanel)field));
        JButton disable = new JButton();
        disable.addActionListener((ActionListener)this.view.evtCtxt.getEventListener("enableMenuButtonUC", ActionListener.class));
        disable.doClick();
        this.initFieldTransactionTypePanels();
    }

    private void initFieldTransactionTypePanels() {
        this.view.transactionTypesPanel.getFieldTransactionTypePanels().forEach(field -> {
            switch (field.getTransactionType()) {
                case ADULT_ENROL: 
                case CHILD_ENROL_BELOW_5: 
                case CHILD_ENROL_ABOVE_5: 
                case UPDATE: {
                    field.setEnabled(true);
                    break;
                }
                default: {
                    field.setEnabled(false);
                }
            }
        });
    }

    private void addMouseListener(final FieldTransactionTypePanel clickedField) {
        clickedField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                TransactionTypeController.this.selectField(clickedField);
            }
        });
    }

    private void selectField(FieldTransactionTypePanel clickedField) {
        if (clickedField.isEnabled()) {
            if (this.view.selectedFields.isEmpty()) {
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else if (this.view.selectedFields.contains(clickedField)) {
                this.view.selectedFields.remove(clickedField);
                clickedField.setSelected(false);
            } else if (!clickedField.getTransactionType().getType().equals((Object)TransactionType.Type.U)) {
                this.view.selectedFields.forEach(e -> e.setSelected(false));
                this.view.selectedFields.clear();
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else if (this.view.selectedFields.get(0).getTransactionType().getType().equals((Object)TransactionType.Type.U)) {
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            } else {
                this.view.selectedFields.get(0).setSelected(false);
                this.view.selectedFields.clear();
                this.view.selectedFields.add(clickedField);
                clickedField.setSelected(true);
            }
        }
    }

    @Override
    public void onNextButtonClick(ActionEvent evt) {
        this.event = evt;
        if (this.view.selectedFields.isEmpty()) {
            L10nOptionPaneBuilder.getInstance().showWarningUC((Object)"Please select any transaction type", (Component)evt.getSource());
            return;
        }
        this.view.disableTransactionButtons();
        this.view.selectedFields.forEach(fieldTransactionTypePanel -> this.view.residentInfoTabViewPeerUC.getTransactions().add(fieldTransactionTypePanel.getTransactionType()));
        boolean isUpdate = this.view.residentInfoTabViewPeerUC.getTransactions().contains((Object)TransactionType.UPDATE);
        FieldInfoUtils.setIsEnrollment((!isUpdate ? 1 : 0) != 0);
        if (isUpdate) {
            if (Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
                Utils.showProgressBar(this.veCtxt, "Loading next page, Please wait..");
                ThreadPool.commonPool().submit(() -> {
                    this.renderResidentUpdateInfoScreen();
                    Utils.cancelProgressBar(this.veCtxt);
                });
            } else {
                ((ActionListener)this.view.evtCtxt.getEventListener("initiate update", ActionListener.class)).actionPerformed(evt);
            }
        } else {
            Utils.showProgressBar(this.veCtxt, "Loading next page, Please wait..");
            ThreadPool.commonPool().submit(() -> {
                this.renderResidentInfoScreen();
                Utils.cancelProgressBar(this.veCtxt);
            });
        }
    }

    private void onPacAccessClick(ActionEvent event) {
        ((ActionListener)this.view.evtCtxt.getEventListener("pacInitiate", ActionListener.class)).actionPerformed(event);
    }

    public void renderResidentUpdateInfoScreen() {
        String label = "Resident Update Info";
        this.view.residentUpdateInfoTabViewPeerUC.titleInit(label);
        this.view.residentUpdateInfoTabViewPeerUC.prepare();
        this.view.residentUpdateInfoTabViewPeerUC.renderTab();
        super.onNextButtonClick(this.event);
    }

    public void renderResidentInfoScreen() {
        String label = "";
        switch (this.view.residentInfoTabViewPeerUC.getTransactions().get(0)) {
            case ADULT_ENROL: {
                label = "Adult Enrollment";
                break;
            }
            case CHILD_ENROL_BELOW_5: {
                label = "Child Enrollment";
                break;
            }
            case CHILD_ENROL_ABOVE_5: {
                label = "Minor Enrollment";
            }
        }
        this.view.residentInfoTabViewPeerUC.titleInit(label);
        this.view.residentInfoTabViewPeerUC.prepare();
        this.view.residentInfoTabViewPeerUC.renderTab();
        super.onNextButtonClick(this.event);
    }
}

