/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.operator.IOperatorLoginConstants;
import in.gov.uidai.ec.ui.enrol.operator.TransactionTypePanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TransactionTypeViewPeer
extends StandardViewPeer
implements IEventContextAware,
IViewElementComposite,
IOperatorLoginConstants {
    protected IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;
    private IEventContext evtCtxt;
    protected JButton okButton;
    protected List<JPanel> transactionTypePanels;
    protected TransactionTypePanel enrolmentButton;
    protected TransactionTypePanel demoUpdateButton;
    protected TransactionTypePanel bioUpdateButton;
    protected TransactionTypePanel docUpdateButton;
    protected TransactionTypePanel findAadhaar;
    private EnrollmentService enrollmentService;
    protected TransparentBox tBox;
    private final int COLUMN_SIZE = 1;

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    protected void prepareImpl() {
        this.setMenuBar(null);
        this.enrolmentButton = new TransactionTypePanel("New Enrolment");
        this.demoUpdateButton = new TransactionTypePanel("Demographics Update");
        this.bioUpdateButton = new TransactionTypePanel("Biometrics Update");
        this.docUpdateButton = new TransactionTypePanel("Document Update");
        this.findAadhaar = new TransactionTypePanel("Print Aadhaar");
        this.transactionTypePanels = Arrays.asList(this.enrolmentButton.create(), this.demoUpdateButton.create(), this.bioUpdateButton.create(), this.docUpdateButton.create(), this.findAadhaar.create());
        this.tBox = new TransparentBox();
        int b = 10;
        int vg = 8;
        int hg = 8;
        int cw = 400;
        int rh = 50;
        double[][] guides = new double[][]{{cw}, {rh, rh, rh, rh, rh, rh, rh, rh}};
        TableLayout layout = new TableLayout((double[][])guides);
        layout.setHGap(hg);
        layout.setVGap(vg);
        this.tBox.setLayout((LayoutManager)layout);
        int i = 0;
        for (JPanel countPanel : this.transactionTypePanels) {
            this.addCountPanel(countPanel, ++i);
        }
        JPanel root = new JPanel();
        root.setLayout(new BoxLayout(root, 1));
        root.add((Component)this.tBox);
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(new Dimension(60, 25));
        this.okButton.setFocusable(true);
        this.okButton.addActionListener((ActionListener)this.getEventContext().getEventListener("operatorTransactionType", ActionListener.class));
        this.enrolmentButton.addToggleBoxListener(this::setUcTransaction);
        root.add(this.okButton);
        this.setContentPane(root);
    }

    private void addComponent(JPanel child, int pos) {
        int row = pos / 1;
        int col = pos % 1;
        this.tBox.add((Component)child, (Object)("" + col + ", " + row + ", full, full"));
    }

    private void addCountPanel(JPanel countPanel, int pos) {
        this.addComponent(countPanel, pos);
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
    }

    public void populateEventContext(IEventContext ctxt) {
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    private void setUcTransaction(boolean isNewEnrol) {
        this.enrollmentService.setUpdateType(isNewEnrol);
    }
}

