/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import in.gov.uidai.ec.ui.enrol.operator.FieldTransactionTypePanel;
import in.gov.uidai.ec.ui.enrol.operator.TransactionType;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransactionTypesPanel {
    private final List<FieldTransactionTypePanel> fieldTransactionTypePanels = new ArrayList<FieldTransactionTypePanel>();
    private static final int hg = 120;
    private static final int vg = 20;
    private static final int cw = 360;
    private static final int rh = 45;

    TransactionTypesPanel() {
        Arrays.stream(TransactionType.values()).forEach(t -> this.fieldTransactionTypePanels.add(new FieldTransactionTypePanel((TransactionType)((Object)t))));
    }

    public JComponent create() {
        List<TransparentBox> tboxes = this.createPanels();
        JPanel panel = new JPanel();
        tboxes.forEach(tbox -> {
            panel.add((Component)tbox);
            panel.add(Box.createHorizontalStrut(120));
        });
        return panel;
    }

    private List<TransparentBox> createPanels() {
        ArrayList<TransparentBox> tboxes = new ArrayList<TransparentBox>(3);
        Arrays.stream(TransactionType.Type.values()).map(TransactionType.Type::getText).forEach(text -> {
            double[][] guides = new double[][]{{360.0}, {60.0, 45.0, 45.0, 45.0, 45.0, 45.0, 45.0}};
            TableLayout layout = new TableLayout((double[][])guides);
            layout.setVGap(20);
            TransparentBox tbox = new TransparentBox((LayoutManager)layout);
            tbox.add((Component)this.heading((String)text), (Object)"0, 0, left, full");
            tboxes.add(tbox);
        });
        int i = 1;
        int j = 1;
        int k = 1;
        for (FieldTransactionTypePanel field : this.fieldTransactionTypePanels) {
            switch (field.getTransactionType().getType()) {
                case N: {
                    ((TransparentBox)tboxes.get(0)).add((Component)field, (Object)("0," + i++));
                    break;
                }
                case U: {
                    ((TransparentBox)tboxes.get(1)).add((Component)field, (Object)("0," + j++));
                    break;
                }
                case S: {
                    ((TransparentBox)tboxes.get(2)).add((Component)field, (Object)("0," + k++));
                }
            }
        }
        return tboxes;
    }

    public List<FieldTransactionTypePanel> getFieldTransactionTypePanels() {
        return this.fieldTransactionTypePanels;
    }

    private JLabel heading(String name) {
        JLabel label = new JLabel("<html><b>" + name + "</b></html>");
        label.setFont(new Font("Arial", 1, 18));
        return label;
    }
}

