/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.operator;

import in.gov.uidai.ec.ui.enrol.operator.NoticeBoardPanel;
import in.gov.uidai.ec.ui.enrol.operator.UpdateType;
import in.gov.uidai.ec.ui.enrol.updatecount.FieldUpdateCountPanel;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateTransactionTypePanel {
    private NoticeBoardPanel noticeBoard;
    private final List<FieldUpdateCountPanel> fieldUpdateCountPanels;
    private static final int hg = 120;
    private static final int vg = 20;
    private static final int cw = 360;
    private static final int rh = 45;

    public UpdateTransactionTypePanel() {
        this.fieldUpdateCountPanels = new ArrayList<FieldUpdateCountPanel>();
        Arrays.stream(UpdateType.values()).forEach(t -> this.fieldUpdateCountPanels.add(new FieldUpdateCountPanel((UpdateType)((Object)t))));
    }

    public UpdateTransactionTypePanel(List<String> broadCastList) {
        this.noticeBoard = new NoticeBoardPanel(broadCastList, "Updates Available");
        this.fieldUpdateCountPanels = new ArrayList<FieldUpdateCountPanel>();
        Arrays.stream(UpdateType.values()).forEach(t -> this.fieldUpdateCountPanels.add(new FieldUpdateCountPanel((UpdateType)((Object)t))));
    }

    public JComponent create() {
        List<TransparentBox> tboxes = this.createPanels();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        tboxes.forEach(tbox -> {
            panel.add((Component)tbox);
            panel.add(Box.createHorizontalStrut(120));
        });
        return panel;
    }

    private List<TransparentBox> createPanels() {
        ArrayList<TransparentBox> tboxes = new ArrayList<TransparentBox>(3);
        tboxes.add(this.setHeading(UpdateType.Type.DU.getText()));
        tboxes.add(this.setHeading(UpdateType.Type.OU.getText()));
        tboxes.add(this.setHeading(UpdateType.Type.DOU.getText()));
        int i = 1;
        int j = 1;
        int k = 1;
        for (FieldUpdateCountPanel field : this.fieldUpdateCountPanels) {
            switch (field.getTransactionType().getType()) {
                case DU: 
                case BU: {
                    ((TransparentBox)tboxes.get(0)).add((Component)field, (Object)("0," + i++));
                    break;
                }
                case OU: {
                    ((TransparentBox)tboxes.get(1)).add((Component)field, (Object)("0," + j++));
                    break;
                }
                case DOU: {
                    ((TransparentBox)tboxes.get(2)).add((Component)field, (Object)("0," + k++));
                }
            }
        }
        return tboxes;
    }

    private TransparentBox createNoticeBoardBox() {
        double[][] guides = new double[][]{{360.0}, {60.0, -1.0}};
        TableLayout layout = new TableLayout((double[][])guides);
        layout.setVGap(20);
        TransparentBox tbox = new TransparentBox((LayoutManager)layout);
        tbox.add((Component)this.noticeBoard, (Object)"0,1, center, top");
        return tbox;
    }

    private TransparentBox setHeading(String heading) {
        double[][] guides = new double[][]{{340.0}, {60.0, 45.0, 45.0, 45.0, 45.0, 45.0, 45.0, 45.0}};
        TableLayout layout = new TableLayout((double[][])guides);
        layout.setVGap(20);
        TransparentBox tbox = new TransparentBox((LayoutManager)layout);
        tbox.add((Component)this.heading(heading), (Object)"0, 0, left, full");
        return tbox;
    }

    public List<FieldUpdateCountPanel> getFieldUpdateTypePanels() {
        return this.fieldUpdateCountPanels;
    }

    private JLabel heading(String name) {
        JLabel label = new JLabel("<html><b>" + name + "</b></html>");
        label.setFont(new Font("Arial", 1, 18));
        return label;
    }
}

