/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.osi;

import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.osi.IEnrolOsiConstants;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnrolOsiControl
implements IOnScreenDisplayAware,
IEnrolOsiConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnrolOsiControl.class);
    private IOnScreenDisplay osd;
    private EnrollmentService enrollmentService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    @EventHandler(name="hID_Enrol_OSI_ShowWin", method="actionPerformed")
    public void onEnrolOsiShow(ILiteEvent evt) {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            String scaffoldId = this.osd.compose("confirmAuthViewWin", "confirmBioAuthView");
            this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
        } else {
            Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
            ((IViewElement)eMap.get("eID_ReviewTab_Confirm")).set("enable", (Object)false);
            this.osd.display(this.osd.compose(evt.getScaffoldId(), "enrolOsiWin", "enrolOsiView"), ScaffoldPlacement.CENTERED);
        }
    }

    @EventHandler(name="hID_Enrol_OSI_CloseWin", method="actionPerformed")
    public void onCloseWin(ILiteEvent evt) {
        this.closeWinImpl(evt);
    }

    @EventHandler(name="hID_EnrolOSIEscHandler", method="actionPerformed")
    public void onEscCloseWin(ILiteEvent evt) {
        this.closeWinImpl(evt);
    }

    private void closeWinImpl(ILiteEvent evt) {
        ILiteScaffold osiScaf = this.osd.getScaffold(evt.getScaffoldId());
        Map osiMap = this.osd.getView(osiScaf.getViewId()).getElementMap();
        this.stopCapture(osiMap, "eID_OSI_Finger_OpBio");
        this.stopCapture(osiMap, "eID_OSI_Iris_OpBio");
        this.stopCapture(osiMap, "eID_OSI_Finger_SupBio");
        this.stopCapture(osiMap, "eID_OSI_Iris_SupBio");
        this.stopCapture(osiMap, "eID_OSI_Finger_IntroBio");
        this.stopCapture(osiMap, "eID_OSI_Iris_IntroBio");
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            Map eMap = this.osd.getView(this.osd.getScaffold(osiScaf.getParentId()).getViewId()).getElementMap();
            ((IViewElement)eMap.get("eID_ReviewTab_Confirm")).set("enable", (Object)true);
        }
        this.enrollmentService.getConfirmerDetails().setOperator(null);
        this.enrollmentService.getConfirmerDetails().setIntroducer(null);
        this.enrollmentService.getConfirmerDetails().setSupervisor(null);
        this.osd.dispose(evt.getScaffoldId());
    }

    private void stopCapture(Map<String, IViewElement> osiMap, String key) {
        IViewElement element = osiMap.get(key);
        if (element != null) {
            element.call("stopCapture");
        }
    }
}

