/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.osi;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.onboarding.IOnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.enrol.osi.IEnrolOsiConstants;
import in.gov.uidai.ec.ui.enrol.osi.OsiController;
import in.gov.uidai.ec.ui.enrol.osi.SupervisorListRenderer;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysAction;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysOSI;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.border.SingleLineBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class EnrolOsiViewPeer
extends StandardViewPeer
implements IEnrolOsiConstants {
    @ExportViewElement(as="eID_OSI_Finger_OpBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField opFingerField;
    @ExportViewElement(as="eID_OSI_Iris_OpBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField opIrisField;
    @ExportViewElement(as="eID_OSI_Finger_SupBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField supFingerField;
    @ExportViewElement(as="eID_OSI_Iris_SupBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField supIrisField;
    @ExportViewElement(as="eID_OSI_Finger_IntroBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField introFingerField;
    @ExportViewElement(as="eID_OSI_Iris_IntroBio", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField introIrisField;
    protected ISessionService sessionService;
    protected EnrollmentService enrollmentService;
    protected IBioxDataProvider bioxProv;
    protected IOnboardingService onboardingService;
    protected JButton saveButton;
    protected JLabel introName;
    protected JComboBox<UserCredentials> supIdField;
    protected JCheckBox introNotAvailable;
    protected BiometricsRDAuthPanel bioPanel;
    protected boolean isSupervisorCaptureRequired;
    protected boolean isRDBasedUpdate;
    protected BiometricsAuthService biometricsAuthService;
    protected boolean introFlag;
    private IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;
    private IClientDeviceManager cdm;
    private IPreSyncPreference preSyncPref;
    private L10nDecorator ldeco;

    public void setBiometricsAuthService(BiometricsAuthService biometricsAuthService) {
        this.biometricsAuthService = biometricsAuthService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setClientDeviceManager(IClientDeviceManager cdm) {
        this.cdm = cdm;
    }

    public void setSessionService(ISessionService iSessionService) {
        this.sessionService = iSessionService;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setPreSyncPreference(IPreSyncPreference pref) {
        this.preSyncPref = pref;
    }

    public final void setBioxDataProvider(IBioxDataProvider prov) {
        this.bioxProv = prov;
    }

    public final void setOnboardingService(IOnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    public IEventContext getEventCtx() {
        return super.getEventContext();
    }

    protected void enableImpl(boolean flag) {
        this.getContentPane().setCursor(flag ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(3));
    }

    protected void prepareImpl() {
        this.setMenuBar(null);
        this.isRDBasedUpdate = this.enrollmentService.isRDBasedUpdate();
        this.isSupervisorCaptureRequired = this.enrollmentService.isSupervisorCaptureRequired();
        this.ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        this.introFlag = this.enrollmentService.getReferences().getReferenceIntroducer().isMandatory();
        this.bioPanel = new BiometricsRDAuthPanel(this.rbCtxt, this.uiPref, this.cdm);
        TransparentBox cntPane = new TransparentBox();
        cntPane.setLayout((LayoutManager)new BoxLayout((Container)cntPane, 1));
        cntPane.add((Component)this.createConfirmArea());
        cntPane.add((Component)this.createNavArea());
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false, this.ldeco));
        super.setContentPane((JComponent)cntPane);
        new OsiController(this);
        if (this.isRDBasedUpdate) {
            new BiometricsRDAuthController(this.getView(), this.bioPanel, this.biometricsAuthService);
        }
    }

    protected void disposeImpl() {
    }

    private BiometricsNonRDField createConfirmField(LabelKeysBio labelKeysBio, String exportName, BiometricPosition position) {
        BiometricsNonRDField result = new BiometricsNonRDField(labelKeysBio.toString());
        result.allowForcedCapture(false);
        result.setClientDeviceManager(this.cdm);
        result.localize(this.ldeco);
        HashMap<String, String> evtParams = new HashMap<String, String>();
        evtParams.put("prm_BioFieldName", exportName);
        result.addQSSActionListener((ActionListener)this.getEventContext().getEventListener("hID_QSS_Cfm", ActionListener.class, evtParams));
        result.addBiometricsListener((IBiometricsListener)this.getEventContext().getEventListener("hID_QSS_CfmCapture", IBiometricsListener.class, evtParams));
        result.hidePositionSelector();
        result.setConfirmPositions((IConfirmPositions)new DefaultConfirmPositions(Collections.singletonList(position)));
        return result;
    }

    private JComponent createConfirmArea() {
        double[][] guides = new double[][]{{70.0, 190.0, 5.0, 70.0, 190.0, 5.0, 70.0, 190.0}, {5.0, 22.0, 5.0, 270.0, 5.0, 0.0, 22.0, 270.0, 5.0, 0.0, 5.0, 22.0}};
        if (this.isRDBasedUpdate) {
            guides[1][11] = 0.0;
        }
        if (this.authTypeIsBoth() && this.isRDBasedUpdate) {
            guides[1][5] = 22.0;
            guides[1][9] = 22.0;
        }
        if (this.authTypeIsFinger()) {
            guides[1][3] = 0.0;
            guides[1][6] = 0.0;
            if (this.isRDBasedUpdate) {
                guides[1][9] = 22.0;
            }
        }
        if (this.authTypeIsIris()) {
            guides[1][6] = 0.0;
            guides[1][7] = 0.0;
            if (this.isRDBasedUpdate) {
                guides[1][5] = 22.0;
            }
        }
        TransparentBox confirmArea = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        confirmArea.setBorder((Border)new EmptyBorder(0, 5, 0, 5));
        if (this.authTypeIsFinger() || this.authTypeIsBoth()) {
            if (this.isRDBasedUpdate) {
                confirmArea.add((Component)this.bioPanel.createRDFingerArea(AuthParamType.OPERATOR), (Object)"0, 7, 1, 6, full, full");
                confirmArea.add((Component)this.bioPanel.createRDFingerArea(AuthParamType.SUPERVISOR), (Object)"3, 7, 4, 6, full, full");
                confirmArea.add((Component)this.bioPanel.createRDFingerArea(AuthParamType.HOF), (Object)"6, 7, 7, 6, full, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.OPERATOR, DeviceType.FINGERPRINT_AUTH), (Object)"0, 9, 1, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.SUPERVISOR, DeviceType.FINGERPRINT_AUTH), (Object)"3, 9, 4, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH), (Object)"6, 9, 7, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.OPERATOR, DeviceType.FINGERPRINT_AUTH), (Object)"0, 9, 1, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.SUPERVISOR, DeviceType.FINGERPRINT_AUTH), (Object)"3, 9, 4, 9, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH), (Object)"6, 9, 7, 9, center, full");
                this.bioPanel.getRDBioField(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH).setEnabled(false);
                this.bioPanel.getRDBioField(AuthParamType.SUPERVISOR, DeviceType.FINGERPRINT_AUTH).setEnabled(false);
                this.bioPanel.getRDVerifyButton(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH).setEnabled(false);
                this.bioPanel.getRDVerifyButton(AuthParamType.SUPERVISOR, DeviceType.FINGERPRINT_AUTH).setEnabled(false);
            } else {
                this.opFingerField = this.createConfirmField(LabelKeysBio.OPERATOR_FINGER, "eID_OSI_Finger_OpBio", BiometricPosition.LEFT_INDEX);
                this.opFingerField.setConfirmUid(this.sessionService.getOperatorCredentials().getUid());
                this.supFingerField = this.createConfirmField(LabelKeysBio.SUPERVISOR_FINGER, "eID_OSI_Finger_SupBio", BiometricPosition.LEFT_INDEX);
                this.supFingerField.setEnabled(false);
                this.introFingerField = this.createConfirmField(this.introFlag ? LabelKeysBio.INTRODUCER_FINGER : LabelKeysBio.HOF_FINGER, "eID_OSI_Finger_IntroBio", BiometricPosition.LEFT_INDEX);
                this.introFingerField.setEnabled(false);
                confirmArea.add((Component)this.opFingerField, (Object)"0, 7, 1, 6, full, full");
                confirmArea.add((Component)this.supFingerField, (Object)"3, 7, 4, 6, full, full");
                confirmArea.add((Component)this.introFingerField, (Object)"6, 7, 7, 6, full, full");
            }
        }
        if (this.authTypeIsIris() || this.authTypeIsBoth()) {
            if (this.isRDBasedUpdate) {
                confirmArea.add((Component)this.bioPanel.createRDIrisArea(AuthParamType.OPERATOR), (Object)"0, 3, 1, 2, full, full");
                confirmArea.add((Component)this.bioPanel.createRDIrisArea(AuthParamType.SUPERVISOR), (Object)"3, 3, 4, 2, full, full");
                confirmArea.add((Component)this.bioPanel.createRDIrisArea(AuthParamType.HOF), (Object)"6, 3, 7, 2, full, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.OPERATOR, DeviceType.IRIS_AUTH), (Object)"0, 5, 1, 5, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.SUPERVISOR, DeviceType.IRIS_AUTH), (Object)"3, 5, 4, 5, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyButton(AuthParamType.HOF, DeviceType.IRIS_AUTH), (Object)"6, 5, 7, 5, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.OPERATOR, DeviceType.IRIS_AUTH), (Object)"0, 5, 1, 5, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.SUPERVISOR, DeviceType.IRIS_AUTH), (Object)"3, 5, 4, 5, center, full");
                confirmArea.add((Component)this.bioPanel.createVerifyLabel(AuthParamType.HOF, DeviceType.IRIS_AUTH), (Object)"6, 5, 7, 5, center, full");
                this.bioPanel.getRDBioField(AuthParamType.HOF, DeviceType.IRIS_AUTH).setEnabled(false);
                this.bioPanel.getRDBioField(AuthParamType.SUPERVISOR, DeviceType.IRIS_AUTH).setEnabled(false);
                this.bioPanel.getRDVerifyButton(AuthParamType.HOF, DeviceType.IRIS_AUTH).setEnabled(false);
                this.bioPanel.getRDVerifyButton(AuthParamType.SUPERVISOR, DeviceType.IRIS_AUTH).setEnabled(false);
            } else {
                this.opIrisField = this.createConfirmField(LabelKeysBio.OPERATOR_IRIS, "eID_OSI_Iris_OpBio", BiometricPosition.LEFT_IRIS);
                this.opIrisField.setConfirmUid(this.sessionService.getOperatorCredentials().getUid());
                this.supIrisField = this.createConfirmField(LabelKeysBio.SUPERVISOR_IRIS, "eID_OSI_Iris_SupBio", BiometricPosition.LEFT_IRIS);
                this.supIrisField.setEnabled(false);
                this.introIrisField = this.createConfirmField(this.introFlag ? LabelKeysBio.INTRODUCER_IRIS : LabelKeysBio.HOF_IRIS, "eID_OSI_Iris_IntroBio", BiometricPosition.LEFT_IRIS);
                this.introIrisField.setEnabled(false);
                confirmArea.add((Component)this.opIrisField, (Object)"0, 3, 1, 2, full, full");
                confirmArea.add((Component)this.supIrisField, (Object)"3, 3, 4, 2, full, full");
                confirmArea.add((Component)this.introIrisField, (Object)"6, 3, 7, 2, full, full");
            }
        }
        this.addOpNameSupListAndIntroName(confirmArea);
        if (!this.isRDBasedUpdate) {
            this.introNotAvailable = new JCheckBox(this.rbCtxt.getMessage((Object)LabelKeysOSI.NOT_AVAILABLE, new Object[0]));
            this.ldeco.localize((AbstractButton)this.introNotAvailable, (Object)LabelKeysOSI.NOT_AVAILABLE, new Object[0]);
            this.introNotAvailable.setEnabled(this.introFlag);
            confirmArea.add((Component)this.introNotAvailable, (Object)"6, 11, 7, 11, full, full");
        }
        return confirmArea;
    }

    private void addOpNameSupListAndIntroName(TransparentBox confirmArea) {
        JLabel opName = new JLabel(this.sessionService.getOperatorCredentials().getOperatorId());
        JLabel opLab = new JLabel(this.rbCtxt.getMessage((Object)LabelKeysOSI.OPERATOR, new Object[0]));
        this.ldeco.localize(opLab, (Object)LabelKeysOSI.OPERATOR, new Object[0]);
        confirmArea.add((Component)opLab, (Object)"0, 1, center, full");
        confirmArea.add((Component)opName, (Object)"1, 1, full, full");
        JLabel supLab = new JLabel(this.rbCtxt.getMessage((Object)LabelKeysOSI.SUPERVISOR, new Object[0]));
        this.ldeco.localize(supLab, (Object)LabelKeysOSI.SUPERVISOR, new Object[0]);
        confirmArea.add((Component)supLab, (Object)"3, 1, center, full");
        if (!this.isRDBasedUpdate) {
            this.supIdField = new JComboBox();
            this.supIdField.setRenderer(new SupervisorListRenderer());
            confirmArea.add(this.supIdField, (Object)"4, 1, full, full");
            boolean noBiox = this.bioxProv.getMissingEyes().isEmpty() && this.bioxProv.getMissingFingers().isEmpty();
            this.supIdField.setEnabled(!noBiox);
        }
        this.introName = new JLabel();
        LabelKeysOSI introType = this.introFlag ? LabelKeysOSI.INTRODUCER : LabelKeysOSI.HOF;
        JLabel introLab = new JLabel(this.rbCtxt.getMessage((Object)introType, new Object[0]));
        this.ldeco.localize(introLab, (Object)introType, new Object[0]);
        confirmArea.add((Component)introLab, (Object)"6, 1, center, full");
        confirmArea.add((Component)this.introName, (Object)"7, 1, full, full");
    }

    private JComponent createNavArea() {
        this.saveButton = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.SAVE, new Object[0]));
        this.ldeco.localize((AbstractButton)this.saveButton, (Object)LabelKeysAction.SAVE, new Object[0]);
        this.saveButton.setEnabled(false);
        JButton cancelButton = new JButton(this.rbCtxt.getMessage((Object)LabelKeysAction.CANCEL, new Object[0]));
        this.ldeco.localize((AbstractButton)cancelButton, (Object)LabelKeysAction.CANCEL, new Object[0]);
        cancelButton.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_Enrol_OSI_CloseWin", ActionListener.class));
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 5, 0, 5), (Border)new SingleLineBorder().drawEdges(true, false, false, false).lineColor("#999999").dashInterval("1, 1"));
        TransparentBox navArea = new TransparentBox((LayoutManager)new FlowLayout(1, 5, 10));
        navArea.setBorder((Border)border);
        navArea.add((Component)this.saveButton);
        navArea.add((Component)cancelButton);
        return navArea;
    }

    protected boolean authTypeIsFinger() {
        String authType = this.preSyncPref.getFingerIrisAuthTypeOSI("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.FINGER.toString());
    }

    protected boolean authTypeIsIris() {
        String authType = this.preSyncPref.getFingerIrisAuthTypeOSI("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.IRIS.toString());
    }

    protected boolean authTypeIsBoth() {
        String authType = this.preSyncPref.getFingerIrisAuthTypeOSI("finger");
        return authType != null && authType.equalsIgnoreCase(AuthParamType.BOTH.toString());
    }
}

