/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.osi;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.lvs.LVSException;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.biometrics.lvs.LVSPolicy;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.enrol.BodyPart;
import in.gov.uidai.ec.service.enrollment.BiometricsCapture;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.ConfirmerDetails;
import in.gov.uidai.ec.service.enrollment.model.ReferenceIntroducer;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.UserDetails;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.osi.EnrolOsiViewPeer;
import in.gov.uidai.lvs.model.OnBoardingStatus;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.VerificationStatus;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsiController
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsiController.class);
    private final EnrolOsiViewPeer view;
    private final ISessionService sessionService;
    private final boolean isEnrolmentWithRdBiometric;
    private final boolean isSupervisorCaptureRequired;
    private final ConfirmerDetails confirmerDetails;
    private final Map<RDCaptureType, Boolean> isSignatureVerified = new HashMap<RDCaptureType, Boolean>();
    private final ActionListener eventListener;

    OsiController(EnrolOsiViewPeer viewElements) {
        super(viewElements.getView(), viewElements.enrollmentService, -1, -1);
        this.view = viewElements;
        this.sessionService = viewElements.sessionService;
        this.isEnrolmentWithRdBiometric = viewElements.isRDBasedUpdate;
        this.isSupervisorCaptureRequired = viewElements.isSupervisorCaptureRequired;
        this.confirmerDetails = this.enrollmentService.getConfirmerDetails();
        this.eventListener = (ActionListener)this.view.getEventCtx().getEventListener("hID_Osi_Confirm", ActionListener.class);
        this.initView();
    }

    private void initView() {
        this.initializeIntroducerAndHof();
        if (this.isSupervisorCaptureRequired) {
            this.initSupervisorList();
        }
        this.addStartCaptureListener(this.view.opFingerField, this::onStartCapture);
        this.addStartCaptureListener(this.view.opIrisField, this::onStartCapture);
        this.addStartCaptureListener(this.view.introFingerField, this::onStartCapture);
        this.addStartCaptureListener(this.view.introIrisField, this::onStartCapture);
        this.addStartCaptureListener(this.view.supFingerField, this::onStartCapture);
        this.addStartCaptureListener(this.view.supIrisField, this::onStartCapture);
        this.addBiometricsListener(this.view.supFingerField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.supIrisField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.opFingerField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.opIrisField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.introFingerField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addBiometricsListener(this.view.introIrisField, e -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        this.addActionListener(this.view.introNotAvailable, (ActionEvent e) -> {
            this.enableIntroBioField();
            this.view.saveButton.setEnabled(this.validateBiometrics());
        });
        this.addItemListener(this.view.supIdField, this::onSupervisorSelected);
        this.addActionListener(this.view.supIdField, (ActionEvent e) -> this.view.saveButton.setEnabled(this.validateBiometrics()));
        if (this.isEnrolmentWithRdBiometric) {
            this.view.biometricsAuthService.addBiometricsVerifiedListener(this::onRDSignatureCapture);
        }
        this.addActionListener(this.view.saveButton, this::updateBiometricsDataToModelAndLoadNextScreen);
    }

    private void onStartCapture(String fieldLabel) {
        LOGGER.info("Started new biometric capture for " + fieldLabel);
        this.view.saveButton.setEnabled(false);
    }

    private void updateBiometricsDataToModelAndLoadNextScreen(ActionEvent evt) {
        if (this.isEnrolmentWithRdBiometric) {
            this.eventListener.actionPerformed(evt);
        } else {
            try {
                this.enableBiometricFields(false);
                this.populateOperatorDetails();
                this.populateSupervisorDetails();
                this.populateHofDetails();
                this.populateIntroducerDetails();
                this.eventListener.actionPerformed(evt);
            }
            catch (Exception e) {
                LOGGER.error("Failed to update capture attempt in model", (Throwable)e);
                this.view.saveButton.setEnabled(false);
                this.enableBiometricFields(true);
            }
        }
    }

    private void enableBiometricFields(boolean enable) {
        this.enableBioField(this.view.opFingerField, enable);
        this.enableBioField(this.view.opIrisField, enable);
        this.enableBioField(this.view.supFingerField, enable && this.isSupervisorRequired());
        this.enableBioField(this.view.supFingerField, enable && this.isSupervisorRequired());
        this.enableBioField(this.view.introFingerField, enable && this.isIntroducerRequired());
        this.enableBioField(this.view.introIrisField, enable && this.isIntroducerRequired());
    }

    private void enableBioField(BiometricsNonRDField biometricsNonRDField, boolean enable) {
        if (biometricsNonRDField != null) {
            biometricsNonRDField.setEnabled(enable);
        }
    }

    private boolean isIntroducerRequired() {
        boolean introFlag = this.view.introFlag;
        boolean hofFlag = this.enrollmentService.getReferences().getHofDoc().isMandatory();
        boolean hofdetailFlag = this.enrollmentService.getRelativeDetails().isMandatory();
        return introFlag || hofFlag || hofdetailFlag;
    }

    private boolean isSupervisorRequired() {
        return !this.view.bioxProv.getMissingEyes().isEmpty() || !this.view.bioxProv.getMissingFingers().isEmpty();
    }

    public void initializeIntroducerAndHof() {
        References references = this.enrollmentService.getReferences();
        boolean introFlag = this.view.introFlag;
        if (this.isIntroducerRequired()) {
            this.view.introName.setText(introFlag ? references.getReferenceIntroducer().getName() : references.getReferenceRelative().getName());
            String introUid = references.getReferenceIntroducer().getAadhaarNumber();
            boolean isIntroConfirmPositionsEmpty = new DefaultConfirmPositions(introUid, LVSPolicy.PARTIAL).getAvailable().isEmpty();
            if (this.view.authTypeIsFinger() || this.view.authTypeIsBoth()) {
                if (this.isEnrolmentWithRdBiometric) {
                    this.view.bioPanel.getRDBioField(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH).setEnabled(true);
                    this.view.bioPanel.getRDVerifyButton(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH).setEnabled(true);
                } else {
                    this.view.introFingerField.setEnabled(true);
                    this.view.introFingerField.setConfirmUid(isIntroConfirmPositionsEmpty ? null : introUid);
                }
            }
            if (this.view.authTypeIsIris() || this.view.authTypeIsBoth()) {
                if (this.isEnrolmentWithRdBiometric) {
                    this.view.bioPanel.getRDBioField(AuthParamType.HOF, DeviceType.IRIS_AUTH).setEnabled(true);
                    this.view.bioPanel.getRDVerifyButton(AuthParamType.HOF, DeviceType.IRIS_AUTH).setEnabled(true);
                } else {
                    this.view.introIrisField.setEnabled(true);
                    this.view.introIrisField.setConfirmUid(isIntroConfirmPositionsEmpty ? null : introUid);
                }
            }
        }
    }

    private void initSupervisorList() {
        UserCredentials dummy = new UserCredentials();
        dummy.setFullName("Select ...");
        this.view.supIdField.addItem(dummy);
        try {
            Map userList = LVSLocator.instance().listUsers();
            this.view.onboardingService.getAllSupervisors().stream().filter(cred -> userList.get(cred.getUid()) == OnBoardingStatus.ONBOARD).forEach(cred -> this.view.supIdField.addItem((UserCredentials)cred));
        }
        catch (LVSException e) {
            LOGGER.debug("Error while getting onboarded users", (Throwable)e);
        }
    }

    private void onSupervisorSelected(ItemEvent ie) {
        boolean supSelected;
        if (ie.getStateChange() == 2) {
            return;
        }
        String supUid = ((UserCredentials)ie.getItem()).getUid();
        boolean bl = supSelected = this.view.supIdField.isEnabled() && StringUtils.isNotBlank((String)supUid);
        if (this.view.authTypeIsFinger() || this.view.authTypeIsBoth()) {
            this.view.supFingerField.clearCaptureAttempt();
            this.view.supFingerField.setConfirmUid(supUid);
            this.view.supFingerField.setEnabled(supSelected);
        }
        if (this.view.authTypeIsIris() || this.view.authTypeIsBoth()) {
            this.view.supIrisField.clearCaptureAttempt();
            this.view.supIrisField.setConfirmUid(supUid);
            this.view.supIrisField.setEnabled(supSelected);
        }
        this.confirmerDetails.setSupervisor(null);
    }

    private void onRDSignatureCapture(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        boolean isHofBioVerified;
        UserDetails userDetails;
        this.isSignatureVerified.putIfAbsent(captureType, true);
        BodyPart bodyPart = captureType.getDeviceType() == DeviceType.FINGERPRINT_AUTH ? BodyPart.THUMB_LEFT : BodyPart.IRIS_LEFT;
        BiometricsCapture bioCapture = this.confirmerDetails.getBioCapture(captureAttempt, bodyPart);
        if (captureType.getUserType() == AuthParamType.OPERATOR) {
            userDetails = this.populateOperatorDemoDetails();
            userDetails.setSignature(signature);
            userDetails.setBiometrics(bioCapture);
            this.confirmerDetails.setOperator(userDetails);
        } else if (captureType.getUserType() == AuthParamType.HOF && (userDetails = this.populateHofDemoDetails()) != null) {
            userDetails.setSignature(signature);
            userDetails.setBiometrics(bioCapture);
            this.confirmerDetails.setIntroducer(userDetails);
        }
        boolean isOperatorBioVerified = this.confirmerDetails.getOperator().getSignature() != null;
        boolean bl = isHofBioVerified = this.confirmerDetails.getIntroducer() != null && this.confirmerDetails.getIntroducer().getSignature() != null;
        if (this.view.authTypeIsFinger() || this.view.authTypeIsBoth()) {
            isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.OPERATOR, DeviceType.FINGERPRINT_AUTH), false) != false;
            boolean bl2 = isHofBioVerified = isHofBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.HOF, DeviceType.FINGERPRINT_AUTH), false) != false;
        }
        if (this.view.authTypeIsIris() || this.view.authTypeIsBoth()) {
            isOperatorBioVerified = isOperatorBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.OPERATOR, DeviceType.IRIS_AUTH), false) != false;
            isHofBioVerified = isHofBioVerified && this.isSignatureVerified.getOrDefault(new RDCaptureType(AuthParamType.HOF, DeviceType.IRIS_AUTH), false) != false;
        }
        boolean isHofBioMandatory = this.enrollmentService.getReferences().getHofDoc().isMandatory();
        if (isOperatorBioVerified && (isHofBioVerified || !isHofBioMandatory)) {
            this.view.saveButton.setEnabled(true);
        }
    }

    private void enableIntroBioField() {
        if (this.view.authTypeIsFinger() || this.view.authTypeIsBoth()) {
            this.view.introFingerField.setEnabled(!this.view.introNotAvailable.isSelected());
        }
        if (this.view.authTypeIsIris() || this.view.authTypeIsBoth()) {
            this.view.introIrisField.setEnabled(!this.view.introNotAvailable.isSelected());
        }
    }

    private boolean validateBiometrics() {
        boolean status = true;
        if (this.view.authTypeIsFinger() || this.view.authTypeIsBoth()) {
            status = this.validateBiometrics(this.view.opFingerField, this.view.supFingerField, this.view.introFingerField);
        }
        if (this.view.authTypeIsIris() || this.view.authTypeIsBoth()) {
            status &= this.validateBiometrics(this.view.opIrisField, this.view.supIrisField, this.view.introIrisField);
        }
        return status;
    }

    private boolean isBioCapturedAndValid(BiometricsNonRDField confirmField) {
        return confirmField.getCaptureAttempt() != null && confirmField.getCaptureAttempt().getImage() != null && confirmField.getCaptureAttempt().isPass() && confirmField.getVerificationStatus() != null && !confirmField.getVerificationStatus().equals((Object)VerificationStatus.ERROR);
    }

    private CaptureAttempt getCaptureAttempt(BiometricsNonRDField biometricsNonRDField) throws Exception {
        CaptureAttempt captureAttempt = biometricsNonRDField.getCaptureAttempt();
        if (!this.isBioCapturedAndValid(biometricsNonRDField)) {
            String message = "Failed to process " + biometricsNonRDField.getLabel() + " data. Please capture again.";
            this.showError((JComponent)biometricsNonRDField, message);
            throw new Exception(message);
        }
        return captureAttempt;
    }

    private boolean validateBiometrics(BiometricsNonRDField opConfirmField, BiometricsNonRDField supConfirmField, BiometricsNonRDField introConfirmField) {
        if (!this.isBioCapturedAndValid(opConfirmField)) {
            return false;
        }
        if (this.isSupervisorRequired() && (this.view.supIdField.getSelectedIndex() == 0 || !this.isBioCapturedAndValid(supConfirmField))) {
            return false;
        }
        if (this.isIntroducerRequired()) {
            return this.isBioCapturedAndValid(introConfirmField);
        }
        return true;
    }

    private void populateOperatorDetails() throws Exception {
        UserDetails userDetails = this.populateOperatorDemoDetails();
        if (this.view.authTypeIsFinger()) {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.opFingerField), BodyPart.THUMB_LEFT));
        } else {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.opIrisField), BodyPart.IRIS_LEFT));
        }
        this.populateLVSDetails(userDetails, false);
        this.confirmerDetails.setOperator(userDetails);
    }

    private UserDetails populateOperatorDemoDetails() {
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setUserId(this.sessionService.getOperatorCredentials().getOperatorId());
        userDetails.setUid(this.sessionService.getOperatorCredentials().getUid());
        userDetails.setFullName(this.sessionService.getOperatorCredentials().getFullName());
        return userDetails;
    }

    private void populateSupervisorDetails() throws Exception {
        UserCredentials supervisor = (UserCredentials)this.view.supIdField.getSelectedItem();
        if (supervisor == null || !StringUtils.isNotBlank((String)supervisor.getOperatorId())) {
            return;
        }
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setUserId(supervisor.getOperatorId());
        userDetails.setUid(supervisor.getUid());
        userDetails.setFullName(supervisor.getFullName());
        if (this.view.authTypeIsFinger()) {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.supFingerField), BodyPart.THUMB_LEFT));
        } else {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.supIrisField), BodyPart.IRIS_LEFT));
        }
        this.populateLVSDetails(userDetails, false);
        this.confirmerDetails.setSupervisor(userDetails);
    }

    private void populateHofDetails() throws Exception {
        UserDetails userDetails = this.populateHofDemoDetails();
        if (userDetails == null) {
            return;
        }
        if (this.view.authTypeIsFinger()) {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.introFingerField), BodyPart.THUMB_LEFT));
        } else {
            userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.introIrisField), BodyPart.IRIS_LEFT));
        }
        this.confirmerDetails.setIntroducer(userDetails);
    }

    private UserDetails populateHofDemoDetails() {
        References references = this.enrollmentService.getReferences();
        if (!references.getHofDoc().isMandatory()) {
            return null;
        }
        ReferenceRelative relative = references.getReferenceRelative();
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setFullName(relative.getName());
        userDetails.setFullNameLocal(relative.getNameLocal());
        return userDetails;
    }

    private void populateIntroducerDetails() throws Exception {
        ReferenceIntroducer introducer = this.enrollmentService.getReferences().getReferenceIntroducer();
        if (!introducer.isMandatory()) {
            return;
        }
        UserDetails userDetails = new UserDetails(this.enrollmentService);
        userDetails.setFullName(introducer.getName());
        userDetails.setFullNameLocal(introducer.getNameLocal());
        String uid = introducer.getAadhaarNumber();
        userDetails.setUserId(uid);
        userDetails.setUid(uid);
        this.populateLVSDetails(userDetails, true);
        if (!this.view.introNotAvailable.isSelected()) {
            if (this.view.authTypeIsFinger()) {
                userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.introFingerField), BodyPart.THUMB_LEFT));
            } else {
                userDetails.setBiometrics(this.confirmerDetails.getBioCapture(this.getCaptureAttempt(this.view.introIrisField), BodyPart.IRIS_LEFT));
            }
        }
        this.confirmerDetails.setIntroducer(userDetails);
    }

    public void populateLVSDetails(UserDetails ud, boolean isIntroducer) {
        try {
            OnBoardingStatus obStat = LVSLocator.instance().getStatus(ud.getUid());
            String allowedStatus = OnBoardingStatus.ONBOARD.name() + "|" + OnBoardingStatus.PARTIALLY_BOARDED + "|" + OnBoardingStatus.NOT_BOARDED;
            ud.setAllowedLvsStatus(isIntroducer ? allowedStatus : OnBoardingStatus.ONBOARD.name());
            ud.setCurrentLvsStatus(obStat == null ? OnBoardingStatus.NOT_BOARDED.name() : obStat.name());
            ud.setLvsCheck(true);
        }
        catch (Exception e) {
            ud.setLvsCheck(false);
        }
    }
}

