/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.packetconfirm;

import in.gov.uidai.ec.escapi.DateMismatchException;
import in.gov.uidai.ec.escapi.DerbyDbException;
import in.gov.uidai.ec.escapi.DocumentDetailsException;
import in.gov.uidai.ec.escapi.LanguageCodeMissingException;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.autosyncupload.IAutoSyncUploadService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.pac.PaymentAuthException;
import in.gov.uidai.ec.service.pac.PaymentAuthService;
import in.gov.uidai.ec.service.presync.IPreSyncPreference;
import in.gov.uidai.ec.service.receipt.PrintReceiptDocNameException;
import in.gov.uidai.ec.service.receipt.ReceiptService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.enrol.packetconfirm.IPACConstant;
import in.gov.uidai.ec.ui.enrol.packetconfirm.IPacketConfirmConstants;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteScaffold;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketConfirmControl
implements IOnScreenDisplayAware,
IEventContextAware,
IPacketConfirmConstants,
IPACConstant,
IPreferenceStoreAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketConfirmControl.class);
    private PaymentAuthService paymentAuthService;
    private IResourceBundleContext rbCtxt;
    private IOnScreenDisplay osd;
    private IEventContext evtCtxt;
    private EnrollmentService enrollmentService;
    private IAutoSyncUploadService autoSyncUploadService;
    private IPreSyncPreference preSyncPref;
    private IPreferenceStore prefStore;
    private ReceiptService receiptService;
    private ISessionService sessionService;

    public ISessionService getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setReceiptService(ReceiptService receiptService) {
        this.receiptService = receiptService;
    }

    public void setPaymentAuthService(PaymentAuthService paymentAuthService) {
        this.paymentAuthService = paymentAuthService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    public void setAutoSyncUploadService(IAutoSyncUploadService autoSyncUploadService) {
        this.autoSyncUploadService = autoSyncUploadService;
    }

    public final void setPreSyncPreference(IPreSyncPreference preSyncPref) {
        this.preSyncPref = preSyncPref;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.prefStore = store;
    }

    @EventHandler(name="hID_ValidatePac_ShowWin", method="actionPerformed")
    public void onValidatePacShowWin(ILiteEvent evt) {
        LOGGER.info("validatePacShowWin started");
        String scafId = this.osd.compose(evt.getScaffoldId(), "pacWin", "pacView");
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        LOGGER.info("validatePacShowWin Ends");
    }

    @EventHandler(name="hID_Print_Receipt", method="actionPerformed")
    public void onPrintReceipt(ILiteEvent evt) {
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        ((IViewElement)eMap.get("eID_CompleteEnrollment")).set("enable", (Object)false);
        boolean localLang = (Boolean)((IViewElement)eMap.get("eID_Confirm_LocPrintOpt")).get("isSelected");
        boolean status = false;
        try {
            status = this.receiptService.printEnrolmentReceipt(localLang);
        }
        catch (PrintReceiptDocNameException e) {
            LOGGER.info("Failed to get uploaded document list", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to get uploaded document list information from Enrol Service Client. Please try again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (StationInfoStoreException e) {
            LOGGER.info("Failed to store/retrieve information from Enrol Service Client!!!", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to store/retrieve information from Enrol Service Client. Please try again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (IOException e) {
            LOGGER.info("Failed to connect to Enrol Service Client!!!", (Object[])e.getStackTrace());
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to connect to Enrol Service Client. Make sure it is running.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        if (!status) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Error encountered during print. Please try again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
    }

    @EventHandler(name="hID_CompleteEnrollmentHandler", method="actionPerformed")
    public void onCompleteEnrollment(ILiteEvent evt) {
        String mainwinEnrolEvent;
        String errMsg;
        LOGGER.info("Packet Creation started for EID: " + this.enrollmentService.getEnrolId());
        IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
        veCtxt.reset();
        veCtxt.setMessage("Saving enrolment details. Please wait.");
        this.paymentAuthService.resetPacValidation();
        try {
            String connectType = new String(Files.readAllBytes(Paths.get("./conf/connect.type", new String[0])));
            if (!connectType.equalsIgnoreCase(this.sessionService.getConnectTypeKey())) {
                throw new UnsupportedOperationException();
            }
            LOGGER.info("Connect type from DB ::: " + this.sessionService.getConnectTypeKey());
            LOGGER.info("Connect type from Local ::: " + connectType);
            this.autoSyncUploadService.savePacket();
            this.updateLastTransactionTime();
            LOGGER.info("Successfully created packet for EID: " + this.enrollmentService.getEnrolId());
        }
        catch (IOException e) {
            veCtxt.cancel();
            LOGGER.info("Failed to connect to Enrol Service Client!!!", (Object[])e.getStackTrace());
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to connect to Enrol Service Client. Make sure it is running.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (StationInfoStoreException e) {
            veCtxt.cancel();
            LOGGER.info("Failed to store/retrieve information from Enrol Service Client!!!", (Throwable)e);
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to store/retrieve information from Enrol Service Client. Please try again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (UnsupportedOperationException e) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Client Type Mismatch Error. This enrolment is now invalid and has been deleted. Please do the enrolment again.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (DocumentDetailsException e) {
            veCtxt.cancel();
            errMsg = "POA / POI Document Name/Doc ID missing while creating enrolment. This enrolment is now invalid and has been deleted. Please do the enrolment again.";
            LOGGER.error(errMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (LanguageCodeMissingException e) {
            veCtxt.cancel();
            errMsg = "Language Code is missing while creating enrolment. This enrolment is now invalid and has been deleted. Please do the enrolment again.";
            LOGGER.error(errMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (DateMismatchException e) {
            veCtxt.cancel();
            errMsg = "Enrolment date and system date are mismatch. This enrollment is now invalid and has been deleted. Please do the enrollment again.";
            LOGGER.error(errMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (DerbyDbException e) {
            veCtxt.cancel();
            errMsg = "This enrolment is valid, error has occurred while updating local Derby DB details. Please do the next enrolment.";
            LOGGER.error(errMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (ClientException e) {
            veCtxt.cancel();
            errMsg = "This enrollment is now invalid missing mandatory fields and has been deleted. Please do the enrollment again.";
            LOGGER.error(errMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        catch (Exception e) {
            veCtxt.cancel();
            errMsg = "Error occurred while creating enrolment. This enrolment is now invalid and has been deleted. Please do the enrolment again.";
            LOGGER.error(errMsg + "," + e.getMessage());
            L10nOptionPaneBuilder.getInstance().showError((Object)errMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
        this.closeWindow(evt);
        UpdateType updateType = this.enrollmentService.getUpdateType();
        switch (updateType) {
            case APPOINTMENT_UPDATE: {
                mainwinEnrolEvent = "hID_MainWin_Appointment_Enrol";
                break;
            }
            case ONLINE_UPDATE: {
                mainwinEnrolEvent = "hID_MainWin_Online_Uenrol";
                break;
            }
            case OFFLINE_UPDATE: {
                mainwinEnrolEvent = "hID_MainWin_Uenrol";
                break;
            }
            case NEW_ENROLLMENT: {
                mainwinEnrolEvent = "hID_MainWin_Enrol";
                break;
            }
            case ONLINE_DOC_UPDATE: {
                mainwinEnrolEvent = "hID_MainWin_Online_Doc_Uenrol";
                break;
            }
            case OFFLINE_DOC_UPDATE: {
                mainwinEnrolEvent = "hID_MainWin_Offline_Doc_Uenrol";
                break;
            }
            default: {
                mainwinEnrolEvent = "hID_MainWin_Enrol";
            }
        }
        this.evtCtxt.fireGenericEvent(mainwinEnrolEvent, new Object[0]);
    }

    public void updateLastTransactionTime() {
        long prevTransactionOn;
        long lastTransTime = System.currentTimeMillis();
        if (lastTransTime > (prevTransactionOn = this.preSyncPref.getLastEnrolmentTime())) {
            this.preSyncPref.setLastEnrolmentTime(lastTransTime);
            this.prefStore.save();
        }
    }

    private void closeWindow(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
    }

    @EventHandler(name="hID_Pac_Close_Win", method="actionPerformed")
    public void onPacCloseWin(ILiteEvent evt) {
        this.closeWindow(evt);
    }

    @EventHandler(name="hID_ValidatePac_Win", method="actionPerformed")
    public void validatePac(ILiteEvent evt) {
        LOGGER.info("Payment Validation started");
        IVisualExecutionContext veCtxt = this.osd.getView(evt.getViewId()).getVisualExecutionContext();
        ILiteScaffold scaff = this.osd.getScaffold(evt.getScaffoldId());
        Map eMap = this.osd.getView(scaff.getViewId()).getElementMap();
        String pacCode = (String)((IViewElement)eMap.get("eID_Osi_Pac_Code")).get("text");
        if (StringUtils.isBlank((String)pacCode)) {
            ((IViewElement)eMap.get("eID_Osi_Pac_Code")).mset("notify", new Object[]{"error", this.rbCtxt.getMessage((Object)MsgKeysILV.MANDATORY, new Object[0])});
            return;
        }
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage("Validating Pac code.Please wait.");
        }
        try {
            this.paymentAuthService.makePayment(pacCode);
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            Map packetConfirmElementMap = this.osd.getView(this.osd.getScaffold(scaff.getParentId()).getViewId()).getElementMap();
            ((IViewElement)packetConfirmElementMap.get("eID_Validate_Pac")).set("enable", (Object)false);
            ((IViewElement)packetConfirmElementMap.get("eID_Validate_Pac")).set("text", (Object)"PAC Validated");
            ((IViewElement)packetConfirmElementMap.get("eID_Attach_Documents")).set("enable", (Object)true);
            ((IViewElement)packetConfirmElementMap.get("eID_Print_Receipt")).set("enable", (Object)true);
            L10nOptionPaneBuilder.getInstance().showInfo((Object)"PAC Validation Successful.", (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            this.closeWindow(evt);
        }
        catch (PaymentAuthException e) {
            if (veCtxt != null) {
                veCtxt.cancel();
            }
            String errorMsg = null;
            switch (e.getExceptionType()) {
                case APIUrlMissing: {
                    errorMsg = "Payment API Url is empty. Please contact UIDAI support";
                    break;
                }
                case APIKeyMissing: {
                    errorMsg = "Payment API Key is empty. Please contact UIDAI support";
                    break;
                }
                case APIKeyVersionMissing: {
                    errorMsg = "Payment API Key Version is empty. Please contact UIDAI support";
                    break;
                }
                case InvalidResponseSignature: {
                    errorMsg = "Failed to validate pac response signature. Please try again.";
                    break;
                }
                case InvalidResponseAPIKeyVersion: {
                    errorMsg = "Failed to validate pac response api key version. Please try again.";
                    break;
                }
                case ServiceUnavailable: {
                    errorMsg = "Failed to process the request. Please try again.";
                    break;
                }
                case NotAcceptable: 
                case BadRequest: 
                case AuthorizationFailure: 
                case ServerError: 
                case InvalidRequest: {
                    errorMsg = e.getMessage();
                    break;
                }
                case InternalError: {
                    errorMsg = "Internal error. Please try again.";
                    break;
                }
                case NetworkError: {
                    errorMsg = "Payment Verification failed. Please check your internet connection and try again.";
                    break;
                }
                case ServerNotFound: {
                    errorMsg = "Server not found. Please contact UIDAI support.";
                }
            }
            LOGGER.error(errorMsg);
            L10nOptionPaneBuilder.getInstance().showError((Object)errorMsg, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
        }
    }
}

