/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.packetconfirm;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.session.ISessionService;
import in.gov.uidai.ec.ui.enrol.packetconfirm.IPACConstant;
import in.gov.uidai.ec.ui.enrol.packetconfirm.IPacketConfirmConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysPrint;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PacketConfirmViewPeer
extends StandardViewPeer
implements IPACConstant,
IPacketConfirmConstants {
    @ExportViewElement(as="eID_Confirm_LocPrintOpt", using=StandardSwingElementFactory.class)
    protected JCheckBox localPrintOpt;
    @ExportViewElement(as="eID_Print_Receipt", using=StandardSwingElementFactory.class)
    protected JButton printBut;
    @ExportViewElement(as="eID_Attach_Documents", using=StandardSwingElementFactory.class)
    protected JButton attachDocBtn;
    @ExportViewElement(as="eID_Validate_Pac", using=StandardSwingElementFactory.class)
    protected JButton validatePACBtn;
    @ExportViewElement(as="eID_CompleteEnrollment", using=StandardSwingElementFactory.class)
    protected JButton completeEnrollment;
    private IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;
    private EnrollmentService enrollmentService;
    private ISessionService sessionService;

    public void setSessionService(ISessionService sessionService) {
        this.sessionService = sessionService;
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    protected void enableImpl(boolean flag) {
    }

    protected void prepareImpl() {
        boolean pacVerificationRequired;
        this.setMenuBar(null);
        double[][] guides = new double[][]{{150.0, 110.0, 5.0, 100.0, 5.0, 110.0, 5.0, 110.0, 150.0}, {5.0, 20.0, 5.0, 25.0, 20.0, 22.0, 5.0, -2.0, 10.0}};
        boolean bl = pacVerificationRequired = this.sessionService.isPacValidationSettingEnabled() && this.enrollmentService.isPACValidationRequired();
        if (!pacVerificationRequired) {
            guides[0][1] = 0.0;
            guides[0][2] = 0.0;
        }
        TransparentBox cntPane = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        cntPane.add((Component)this.getAcknowledgementLabel(ldeco), (Object)"0, 1, 8, 1, full, full");
        cntPane.add((Component)this.getEidView(ldeco), (Object)"0, 3, 8, 3, center, full");
        this.localPrintOpt = new JCheckBox(this.rbCtxt.getMessage((Object)LabelKeysPrint.OPT_LOCAL, new Object[0]));
        ldeco.localize((AbstractButton)this.localPrintOpt, (Object)LabelKeysPrint.OPT_LOCAL, new Object[0]);
        if (this.rbCtxt.getLocale().getLanguage().equals("en")) {
            this.localPrintOpt.setEnabled(false);
        }
        cntPane.add((Component)this.localPrintOpt, (Object)"1, 5, 8, 5, left, full");
        this.printBut = new JButton(this.rbCtxt.getMessage((Object)LabelKeysPrint.ACTION_RECEIPT, new Object[0]));
        ldeco.localize((AbstractButton)this.printBut, (Object)LabelKeysPrint.ACTION_RECEIPT, new Object[0]);
        this.printBut.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_Print_Receipt", ActionListener.class));
        cntPane.add((Component)this.printBut, (Object)"3, 7, full, center");
        this.printBut.setEnabled(!pacVerificationRequired);
        this.attachDocBtn = new JButton("Attach Documents");
        this.attachDocBtn.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_Show_DocDialogue", ActionListener.class));
        cntPane.add((Component)this.attachDocBtn, (Object)"5, 7, full, center");
        this.attachDocBtn.setEnabled(!pacVerificationRequired);
        this.validatePACBtn = new JButton("Validate PAC");
        this.validatePACBtn.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_ValidatePac_ShowWin", ActionListener.class));
        cntPane.add((Component)this.validatePACBtn, (Object)"1, 7, full, center");
        this.validatePACBtn.setEnabled(pacVerificationRequired);
        this.completeEnrollment = new JButton(this.rbCtxt.getMessage((Object)LabelKeysPrint.ACTION_ENROL, new Object[0]));
        ldeco.localize((AbstractButton)this.completeEnrollment, (Object)LabelKeysPrint.ACTION_ENROL, new Object[0]);
        this.completeEnrollment.addActionListener((ActionListener)this.getEventContext().getEventListener("hID_CompleteEnrollmentHandler", ActionListener.class));
        cntPane.add((Component)this.completeEnrollment, (Object)"7, 7, full, center");
        this.completeEnrollment.setEnabled(false);
        super.setContentPane((JComponent)cntPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false));
    }

    private TransparentBox getEidView(L10nDecorator ldeco) {
        TransparentBox box = new TransparentBox((LayoutManager)new FlowLayout(1));
        JLabel eidLab = new JLabel(this.rbCtxt.getMessage((Object)LabelKeysPrint.EID, new Object[0]));
        ldeco.localize(eidLab, (Object)LabelKeysPrint.EID, new Object[0]);
        box.add((Component)eidLab);
        JLabel enrolIdField = new JLabel(this.enrollmentService.generateEid().toStringDecorated());
        box.add((Component)enrolIdField);
        return box;
    }

    private JLabel getAcknowledgementLabel(L10nDecorator ldeco) {
        LabelKeysPrint labelKey = null;
        labelKey = this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate() ? LabelKeysPrint.STATUS_DOCUPDATE : (this.enrollmentService.isUpdateEnrollment() ? LabelKeysPrint.STATUS_UENROL : LabelKeysPrint.STATUS_ENROL);
        JLabel acknowledgementLabel = new JLabel(this.rbCtxt.getMessage((Object)labelKey, new Object[0]));
        ldeco.localize(acknowledgementLabel, (Object)labelKey, new Object[0]);
        acknowledgementLabel.setHorizontalAlignment(0);
        acknowledgementLabel.setFont(acknowledgementLabel.getFont().deriveFont(1, 18.0f));
        return acknowledgementLabel;
    }

    protected void disposeImpl() {
    }
}

