/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.photograph;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Dimension;
import javax.swing.JComponent;

public class PhotoPanel
implements IViewElementComposite {
    private final IResourceBundleContext resBundleCtxt;
    private final IUIPreference uiPref;
    private final IClientDeviceManager cdm;
    private AbstractPreviewPlayer previewPlayer;
    private EnrollmentService enrollmentService;
    @ExportViewElement(as="eID_PhotoTab_Face", using=BiometricsElementFactory.class)
    protected BiometricsCaptureField photoField;

    PhotoPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, AbstractPreviewPlayer previewPlayer) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.previewPlayer = previewPlayer;
    }

    public PhotoPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, AbstractPreviewPlayer previewPlayer, EnrollmentService enrollmentService) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.previewPlayer = previewPlayer;
        this.enrollmentService = enrollmentService;
    }

    public JComponent create() {
        this.photoField = this.enrollmentService != null && this.enrollmentService.isUniversalClientTrnx() ? new BiometricsCaptureField(LabelKeysBio.CAPTURE_PHOTO.toString(), BiometricPosition.FACE, new EnrollmentService[]{this.enrollmentService}) : new BiometricsCaptureField(LabelKeysBio.CAPTURE_PHOTO.toString(), BiometricPosition.FACE, new EnrollmentService[0]);
        this.photoField.localize(new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false)));
        this.photoField.setQSSEnabled(true);
        this.photoField.setPreviewPlayer(this.previewPlayer);
        this.photoField.setClientDeviceManager(this.cdm);
        this.photoField.setMaxAttempts(this.uiPref.getMaxCaptureAttempts(5));
        this.photoField.setEnabled(true);
        this.photoField.setMinimumSize(new Dimension(250, 200));
        this.photoField.setPreferredSize(new Dimension(450, 450));
        return this.photoField;
    }

    public BiometricsCaptureField getPhotoField() {
        return this.photoField;
    }
}

