/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.photograph;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.ecmpapi.xml.bioverify.auth.Signature;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.service.biometricsauth.model.RDCaptureType;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Photograph;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.photograph.IPhotoTabConstants;
import in.gov.uidai.ec.ui.enrol.photograph.PhotographTabViewPeer;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.IBiometricsListener;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;

class PhotographController
extends EnrollmentControllerBase
implements IPhotoTabConstants {
    private final HashMap<String, Object> photographEvtParams = new HashMap<String, Object>(){
        {
            this.put("prm_BioFieldName", "eID_PhotoTab_Face");
        }
    };
    private final HashMap<String, Object> residentConfirmEvtParams = new HashMap<String, Object>(){
        {
            this.put("prm_BioFieldName", "eID_PhotoTab_ResidentConfirm");
        }
    };
    private final Photograph photograph;
    private final PhotographTabViewPeer viewElements;

    PhotographController(ILiteView view, PhotographTabViewPeer viewElements) {
        super(view, viewElements.enrollmentService, 2, viewElements.getTabIndex());
        this.viewElements = viewElements;
        this.photograph = viewElements.enrollmentService.getPhotograph();
        this.photograph.setMaxCaptureAttempts(viewElements.uiPref.getMaxCaptureAttempts(5));
        this.initView();
    }

    private void initView() {
        IEventContext evtCtxt = this.viewElements.evtCtxt;
        BiometricsCaptureField photoField = this.viewElements.photoPanel.photoField;
        Biometrics photo = this.photograph.getPhoto();
        BiometricsCaptureField exceptionPhotoField = this.viewElements.exceptionPhotoPanel.exceptionPhotoField;
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_PhotoCapture", IBiometricsListener.class));
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSSDedup_PhotoCapture", IBiometricsListener.class));
        photoField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSS_Face_Capture", IBiometricsListener.class, this.photographEvtParams));
        photoField.addQSSActionListener((ActionListener)evtCtxt.getEventListener("hID_QSS_Face", ActionListener.class, this.photographEvtParams));
        this.addCaptureListeners(photo, photoField);
        if (exceptionPhotoField != null) {
            Biometrics exceptionPhoto = this.photograph.getExceptionPhoto();
            this.addCaptureListeners(exceptionPhoto, exceptionPhotoField);
        }
        this.photograph.addBiometricsExceptionChangeListener(this::onBiometricsExceptionChange);
        this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().addChangeListener(this::onageAgeDobChangeListener);
        this.photograph.addValidityChangeListener(this::onValidityChange);
        this.addActionListener(this.viewElements.navigationPanel.nextBut, this::onNextButtonClick);
        this.addActionListener(this.viewElements.navigationPanel.previousBut, this::onPrevButtonClick);
        this.addEventListenersForNonRdBasedUpdateEnrollment();
        if (this.enrollmentService.isRDBasedUpdate()) {
            AadhaarNo aadhaarNumber = this.enrollmentService.getDemographics().getPersonalDetail().getAadhaarNumber();
            aadhaarNumber.addValidityChangeListener(this::enableRDBioCapture);
            if (aadhaarNumber.getAadhaarNumber() != null) {
                this.enableRDBioCapture(true);
            }
            this.viewElements.biometricsAuthService.addBiometricsVerifiedListener(this::onResidentRDSignatureCapture);
        }
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
    }

    private void addCaptureListeners(Biometrics biometrics, BiometricsCaptureField biometricsField) {
        biometricsField.addCaptureAttemptAdditionChangeListener((pos, captureAttempt) -> biometrics.addCaptureAttempt(captureAttempt));
        biometricsField.addCaptureAttemptDeletionChangeListener((pos, captureAttempt) -> biometrics.deleteCaptureAttempt(captureAttempt));
        biometricsField.addBestCaptureAttemptChangeListeners((pos, bestAttempt) -> biometrics.setBestAttempt(bestAttempt));
        biometricsField.addCaptureAttemptClearChangeListener(pos -> biometrics.clearAttempts());
    }

    private void enableRDBioCapture(Boolean valid) {
        this.viewElements.bioPanel.getRDBioField(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).setEnabled(valid.booleanValue());
        this.viewElements.bioPanel.getRDVerifyButton(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).setEnabled(valid);
    }

    private void addEventListenersForNonRdBasedUpdateEnrollment() {
        if (this.enrollmentService.isRDBasedUpdate()) {
            return;
        }
        BiometricsNonRDField residentConfirmField = this.viewElements.residentConfirmationPanel.residentNonRdConfirmField;
        if (residentConfirmField == null) {
            return;
        }
        IEventContext evtCtxt = this.viewElements.evtCtxt;
        residentConfirmField.addQSSActionListener((ActionListener)evtCtxt.getEventListener("hID_QSS_Cfm", ActionListener.class, this.residentConfirmEvtParams));
        residentConfirmField.addBiometricsListener((IBiometricsListener)evtCtxt.getEventListener("hID_QSS_CfmCapture", IBiometricsListener.class, this.residentConfirmEvtParams));
        residentConfirmField.addCaptureAttemptChangeListeners((captureAttempt, biometricPosition) -> this.photograph.getResidentConfirmation().setCaptureAttempt(captureAttempt, biometricPosition));
        this.addChangeListener(residentConfirmField.positionSel.bioPosList, this::onResidentConfirmationBioCaptureChange);
        this.enrollmentService.addOnViewLoadCompleteListeners(o -> this.onBiometricUpdateTypeChange(this.enrollmentService.isBiometricUpdate()));
        this.photograph.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.photograph.addAgeUpdateChangeListener(this::onUpdateAgeChangeListener);
    }

    private void onResidentConfirmationBioCaptureChange(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        BiometricPosition biometricPosition = (BiometricPosition)((JList)listSelectionEvent.getSource()).getSelectedValue();
        this.photograph.getResidentConfirmation().setMandatory(biometricPosition);
    }

    private void onBiometricUpdateTypeChange(Boolean isBiometricUpdate) {
        this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setEnabled(isBiometricUpdate == false);
        this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setVisible(isBiometricUpdate == false);
        if (!isBiometricUpdate.booleanValue()) {
            this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setEnabled(false);
        }
        this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setVisible(isBiometricUpdate.booleanValue());
    }

    private void onBiometricsExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setEnabled(biometricsExceptionDetail != null && biometricsExceptionDetail.isBiometricExceptionApplied());
        this.viewElements.exceptionPhotoPanel.exceptionPhotoField.clear();
    }

    private void onageAgeDobChangeListener(AgeDob ageDob) {
        if (!this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isUniversalClientTrnx()) {
            if (this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().getAgeGroup().equals((Object)AgeGroup.BELOW5)) {
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setEnabled(true);
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setLabel("Relative Confirmation");
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setVisible(true);
                this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setVisible(false);
                this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setEnabled(false);
            } else {
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setEnabled(false);
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setVisible(false);
                this.viewElements.exceptionPhotoPanel.exceptionPhotoField.setVisible(true);
            }
        }
    }

    private void onUpdateAgeChangeListener(Boolean isAgeUpdate) {
        if (!this.enrollmentService.isOnlineUpdate()) {
            if (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment() || this.enrollmentService.isAdultEnrollment()) {
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setLabel("Relative Confirmation");
            } else {
                this.viewElements.residentConfirmationPanel.residentNonRdConfirmField.setLabel("Resident Confirmation");
            }
        }
    }

    private void onValidityChange(boolean valid) {
        this.updateTabValidityState(valid);
    }

    private void onResidentRDSignatureCapture(RDCaptureType captureType, Signature signature, CaptureAttempt captureAttempt) {
        if (captureType.getUserType() != AuthParamType.RESIDENT) {
            return;
        }
        this.photograph.getResidentConfirmation().setRDBioCapture(signature, captureAttempt);
    }
}

