/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.photograph;

import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.BiometricsAuthService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.shared.NavigationPanel;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthController;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.photograph.ExceptionPhotoPanel;
import in.gov.uidai.ec.ui.enrol.photograph.PhotoPanel;
import in.gov.uidai.ec.ui.enrol.photograph.PhotographController;
import in.gov.uidai.ec.ui.enrol.photograph.ResidentConfirmationPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.NucleusLayout;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.player.AbstractPreviewPlayer;
import in.gov.uidai.swing.bio.player.PreviewPlayer2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class PhotographTabViewPeer
implements IViewElementComposite {
    protected final EnrollmentService enrollmentService;
    protected final IUIPreference uiPref;
    private final ILiteView view;
    private final IResourceBundleContext clientRbCtxt;
    private final IClientDeviceManager cdm;
    private final boolean isUpdateEnrollment;
    private final boolean isPhotographCaptureEnabled;
    private final boolean isRdBasedUpdate;
    protected IEventContext evtCtxt;
    protected PhotoPanel photoPanel;
    protected ExceptionPhotoPanel exceptionPhotoPanel;
    protected NavigationPanel navigationPanel;
    protected ResidentConfirmationPanel residentConfirmationPanel;
    protected BiometricsRDAuthPanel bioPanel;
    protected BiometricsAuthService biometricsAuthService;
    private TransparentBox photographPanel;
    private JTabbedPane tabbedPane;
    private int tabIndex;

    public PhotographTabViewPeer(EnrolViewPeer enrolViewPeer) {
        this.clientRbCtxt = enrolViewPeer.clientRbCtxt;
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.cdm = enrolViewPeer.cdm;
        this.view = enrolViewPeer.getView();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.biometricsAuthService = enrolViewPeer.biometricsAuthService;
        this.isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        this.isPhotographCaptureEnabled = this.enrollmentService.isPhotographCaptureEnabled();
        this.isRdBasedUpdate = this.enrollmentService.isRDBasedUpdate();
    }

    public void prepare() {
        this.bioPanel = new BiometricsRDAuthPanel(this.clientRbCtxt, this.uiPref, this.cdm);
        PreviewPlayer2 previewPlayer = new PreviewPlayer2();
        this.photoPanel = new PhotoPanel(this.clientRbCtxt, this.uiPref, this.cdm, (AbstractPreviewPlayer)previewPlayer);
        if (this.enrollmentService.isUniversalClientTrnx() && this.enrollmentService.getSid() != null) {
            this.photoPanel = new PhotoPanel(this.clientRbCtxt, this.uiPref, this.cdm, (AbstractPreviewPlayer)previewPlayer, this.enrollmentService);
        }
        this.exceptionPhotoPanel = new ExceptionPhotoPanel(this.clientRbCtxt, this.uiPref, this.cdm, (AbstractPreviewPlayer)previewPlayer, this.isUpdateEnrollment);
        this.navigationPanel = new NavigationPanel(this.clientRbCtxt, this.uiPref);
        this.residentConfirmationPanel = new ResidentConfirmationPanel(this.clientRbCtxt, this.uiPref, this.cdm, this.bioPanel);
        TransparentBox centerPanel = new TransparentBox((LayoutManager)new NucleusLayout(5, 5));
        centerPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        centerPanel.add((Component)previewPlayer, (Object)"Center");
        centerPanel.add((Component)this.photoPanel.create());
        if (!this.isPhotographCaptureEnabled) {
            this.photoPanel.photoField.setEnabled(false);
        }
        centerPanel.add((Component)this.exceptionPhotoPanel.create());
        this.exceptionPhotoPanel.exceptionPhotoField.setVisible(this.isPhotographCaptureEnabled);
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            if (this.isRdBasedUpdate) {
                centerPanel.add((Component)this.residentConfirmationPanel.createRDArea());
            } else {
                centerPanel.add((Component)this.residentConfirmationPanel.createNonRDArea());
                this.residentConfirmationPanel.residentNonRdConfirmField.setVisible(this.isUpdateEnrollment);
            }
        }
        centerPanel.setOpaque(true);
        centerPanel.setBackground(Color.GRAY);
        this.photographPanel = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.photographPanel.add((Component)centerPanel, (Object)"Center");
        this.photographPanel.add((Component)this.navigationPanel.create(new Component[0]), (Object)"South");
        this.addTraversal();
        if (this.isRdBasedUpdate) {
            new BiometricsRDAuthController(this.view, this.bioPanel, this.biometricsAuthService);
        }
        new PhotographController(this.view, this);
    }

    private void addTraversal() {
        new ExplicitFocusTraversalPolicy((Container)this.photographPanel).addComponent((Component)this.photoPanel.photoField).addComponent((Component)this.exceptionPhotoPanel.exceptionPhotoField).addComponent((Component)this.residentConfirmationPanel.residentNonRdConfirmField).addComponent((Component)this.navigationPanel.previousBut).addComponent((Component)this.navigationPanel.nextBut);
    }

    public JComponent toSwing() {
        return this.photographPanel;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }
}

