/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.photograph;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.biometricsauth.AuthParamType;
import in.gov.uidai.ec.ui.biometricsauth.BiometricsRDAuthPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysBio;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.bio.confirm.BiometricsNonRDField;
import in.gov.uidai.swing.bio.confirm.BiometricsRDField;
import in.gov.uidai.swing.bio.confirm.DefaultConfirmPositions;
import in.gov.uidai.swing.bio.confirm.IConfirmPositions;
import in.gov.uidai.swing.bio.view.BiometricsElementFactory;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ResidentConfirmationPanel
implements IViewElementComposite {
    private final IResourceBundleContext resBundleCtxt;
    private final IUIPreference uiPref;
    private final IClientDeviceManager cdm;
    private final BiometricsRDAuthPanel bioPanel;
    @ExportViewElement(as="eID_PhotoTab_ResidentConfirm", using=BiometricsElementFactory.class)
    protected BiometricsNonRDField residentNonRdConfirmField;

    ResidentConfirmationPanel(IResourceBundleContext resBundleCtxt, IUIPreference uiPref, IClientDeviceManager cdm, BiometricsRDAuthPanel bioPanel) {
        this.resBundleCtxt = resBundleCtxt;
        this.uiPref = uiPref;
        this.cdm = cdm;
        this.bioPanel = bioPanel;
    }

    protected JComponent createNonRDArea() {
        this.residentNonRdConfirmField = new BiometricsNonRDField(LabelKeysBio.CONFIRM_RESIDENT.toString());
        this.residentNonRdConfirmField.localize(new L10nDecorator(this.resBundleCtxt, this.uiPref.getApplicationLocalize(false)));
        this.residentNonRdConfirmField.setClientDeviceManager(this.cdm);
        ArrayList<BiometricPosition> cfmPosList = new ArrayList<BiometricPosition>();
        cfmPosList.add(BiometricPosition.LEFT_SLAP);
        cfmPosList.add(BiometricPosition.RIGHT_SLAP);
        cfmPosList.add(BiometricPosition.BOTH_THUMBS);
        cfmPosList.add(BiometricPosition.LEFT_IRIS);
        cfmPosList.add(BiometricPosition.RIGHT_IRIS);
        DefaultConfirmPositions cfmPos = new DefaultConfirmPositions(cfmPosList);
        this.residentNonRdConfirmField.setConfirmPositions((IConfirmPositions)cfmPos);
        this.residentNonRdConfirmField.setMinimumSize(new Dimension(250, 200));
        this.residentNonRdConfirmField.setPreferredSize(new Dimension(450, 450));
        return this.residentNonRdConfirmField;
    }

    protected JComponent createRDArea() {
        BiometricsRDField residentRDBioArea = this.bioPanel.createRDFingerAndIrisBioVerifyArea(AuthParamType.RESIDENT);
        residentRDBioArea.setMinimumSize(new Dimension(250, 200));
        residentRDBioArea.setPreferredSize(new Dimension(450, 450));
        residentRDBioArea.setEnabled(false);
        this.bioPanel.getRDVerifyButton(AuthParamType.RESIDENT, DeviceType.FINGER_OR_IRIS).setEnabled(false);
        return residentRDBioArea;
    }
}

