/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.qss;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.ui.enrol.qss.IQSSConstants;
import in.gov.uidai.ec.ui.enrol.qss.QATableEntry;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.swing.bio.confirm.VerificationStatus;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QssControl
implements IOnScreenDisplayAware,
IQSSConstants {
    public static final DecimalFormat SCORE_FORMAT = new DecimalFormat("###.00");
    private static final Logger LOGGER = LoggerFactory.getLogger(QssControl.class);
    private IOnScreenDisplay osd;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    @EventHandler(name="hID_QSS_Close", method="actionPerformed")
    public void onCloseQSS(ILiteEvent evt) {
        this.osd.dispose(evt.getScaffoldId());
        this.osd.disposeView(evt.getViewId());
    }

    @EventHandler(name="hID_QSS_Face_Capture", method="sampleReceived")
    public void onShowFaceQSSCapture(ILiteEvent evt) {
        this.showFingerIrisOrFaceSlapQSS(evt, true, DeviceType.PHOTO);
    }

    @EventHandler(name="hID_QSS_Face", method="actionPerformed")
    public void onShowFaceQSS(ILiteEvent evt) {
        this.showFingerIrisOrFaceSlapQSS(evt, false, DeviceType.PHOTO);
    }

    @EventHandler(name="hID_QSS_Slap_Capture", method="sampleReceived")
    public void onShowSlapQSSCapture(ILiteEvent evt) {
        this.showFingerIrisOrFaceSlapQSS(evt, true, DeviceType.FINGERPRINT);
    }

    @EventHandler(name="hID_QSS_Slap", method="actionPerformed")
    public void onShowSlapQSS(ILiteEvent evt) {
        this.showFingerIrisOrFaceSlapQSS(evt, false, DeviceType.FINGERPRINT);
    }

    @EventHandler(name="hID_QSS_Iris_Capture", method="sampleReceived")
    public void onShowEyeQSSCapture(ILiteEvent evt) {
        this.showFingerIrisOrFaceSlapQSS(evt, true, DeviceType.IRIS);
    }

    private void showFingerIrisOrFaceSlapQSS(ILiteEvent evt, boolean sampleReceived, DeviceType type) {
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        CaptureAttempt attempt = (CaptureAttempt)((IViewElement)eMap.get(evt.getExtraParameters().get("prm_BioFieldName"))).get("currentAttempt");
        if (attempt == null) {
            return;
        }
        Object qssData = attempt.getQSS();
        if (qssData == null) {
            return;
        }
        String qssView = null;
        Compliance compliance = null;
        switch (type) {
            case FINGERPRINT: {
                if (sampleReceived) {
                    compliance = ((FingerprintQSS)qssData).getOverallCompliance();
                }
                qssView = "fingerQssView";
                break;
            }
            case PHOTO: {
                if (sampleReceived) {
                    compliance = ((FaceQSS)qssData).getOverallCompliance();
                }
                qssView = "faceQssView";
                break;
            }
            case IRIS: {
                if (sampleReceived) {
                    compliance = ((IrisQSS)qssData).getOverallCompliance();
                }
                qssView = "irisQssView";
            }
        }
        if (sampleReceived && compliance != null && compliance.equals((Object)Compliance.OK)) {
            return;
        }
        String scafId = this.osd.compose(evt.getScaffoldId(), "qssWin", qssView);
        ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
        switch (type) {
            case FINGERPRINT: {
                this.populateFingerQSS((FingerprintQSS)qssData, view.getElementMap(), sampleReceived);
                break;
            }
            case PHOTO: {
                this.populateFaceQSS((FaceQSS)qssData, view.getElementMap(), sampleReceived);
                break;
            }
            case IRIS: {
                this.populateIrisQSS((IrisQSS)qssData, view.getElementMap(), true);
            }
        }
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_QSS_Dual_Iris_Capture", method="sampleReceived")
    public void onShowDualEyeQSSCapture(ILiteEvent evt) {
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        Map attemptMap = (Map)((IViewElement)eMap.get(evt.getExtraParameters().get("prm_BioFieldName"))).get("currentAttemptMultiPos");
        LOGGER.debug("{}", (Object)attemptMap);
        if (attemptMap == null || attemptMap.isEmpty()) {
            LOGGER.debug("attempt map is null or empty");
            return;
        }
        IrisQSS leftQss = null;
        IrisQSS rightQss = null;
        CaptureAttempt leftAttempt = (CaptureAttempt)attemptMap.get(BiometricPosition.LEFT_IRIS);
        CaptureAttempt rightAttempt = (CaptureAttempt)attemptMap.get(BiometricPosition.RIGHT_IRIS);
        if (leftAttempt != null) {
            leftQss = (IrisQSS)leftAttempt.getQSS();
        }
        if (rightAttempt != null) {
            rightQss = (IrisQSS)rightAttempt.getQSS();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ReflectionToStringBuilder.toString((Object)leftQss));
            LOGGER.debug(ReflectionToStringBuilder.toString((Object)rightQss));
        }
        if (leftQss == null && rightQss == null) {
            LOGGER.debug("both left and right qss are null");
            return;
        }
        Compliance leftCompl = null;
        if (leftQss != null) {
            leftCompl = leftQss.getOverallCompliance();
        }
        Compliance rightCompl = null;
        if (rightQss != null) {
            rightCompl = rightQss.getOverallCompliance();
        }
        if (leftCompl != null && !leftCompl.equals((Object)Compliance.OK) || rightCompl != null && !rightCompl.equals((Object)Compliance.OK)) {
            String scafId = this.osd.compose(evt.getScaffoldId(), "qssWin", "dualIrisQssView");
            ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
            this.populateDualIrisQSS(view.getElementMap(), leftQss, rightQss);
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        } else {
            LOGGER.debug("all qss are complaint");
        }
    }

    @EventHandler(name="hID_QSS_Iris", method="actionPerformed")
    public void onShowEyeQSS(ILiteEvent evt) {
        Object qssData = null;
        BiometricPosition bioPos = (BiometricPosition)evt.getExtraParameters().get("prm_BioFieldSubType");
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        IViewElement bioElement = (IViewElement)eMap.get(evt.getExtraParameters().get("prm_BioFieldName"));
        if (bioPos == null) {
            CaptureAttempt attempt = (CaptureAttempt)bioElement.get("currentAttempt");
            if (attempt == null) {
                return;
            }
            qssData = attempt.getQSS();
        } else {
            Map attemptMap = (Map)bioElement.get("currentAttemptMultiPos");
            if (attemptMap == null || attemptMap.isEmpty()) {
                return;
            }
            CaptureAttempt attempt = (CaptureAttempt)attemptMap.get(bioPos);
            if (attempt != null) {
                qssData = attempt.getQSS();
            }
        }
        if (qssData == null) {
            return;
        }
        String scafId = this.osd.compose(evt.getScaffoldId(), "qssWin", "irisQssView");
        ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
        this.populateIrisQSS((IrisQSS)qssData, view.getElementMap(), false);
        this.osd.display(scafId, ScaffoldPlacement.CENTERED);
    }

    @EventHandler(name="hID_QSS_CfmCapture", method="sampleReceived")
    public void onShowCfmQSSCapture(ILiteEvent evt) {
        VerificationStatus vstat;
        Compliance compliance;
        String pScafId = evt.getScaffoldId();
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        IViewElement bioElement = (IViewElement)eMap.get(evt.getExtraParameters().get("prm_BioFieldName"));
        CaptureAttempt attempt = (CaptureAttempt)bioElement.get("captureAttempt");
        Object qssData = attempt.getQSS();
        if (qssData == null) {
            return;
        }
        if (qssData instanceof FingerprintQSS) {
            compliance = ((FingerprintQSS)qssData).getOverallCompliance();
            if (compliance == null || !compliance.equals((Object)Compliance.OK)) {
                String scafId = this.osd.compose(pScafId, "qssWin", "fingerQssView");
                ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
                this.populateFingerQSS((FingerprintQSS)qssData, view.getElementMap(), true);
                this.osd.display(scafId, ScaffoldPlacement.CENTERED);
                return;
            }
        } else if (qssData instanceof IrisQSS && ((compliance = ((IrisQSS)qssData).getOverallCompliance()) == null || !compliance.equals((Object)Compliance.OK))) {
            String scafId = this.osd.compose(pScafId, "qssWin", "irisQssView");
            ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
            this.populateIrisQSS((IrisQSS)qssData, view.getElementMap(), true);
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
            return;
        }
        if ((vstat = (VerificationStatus)bioElement.get("verifyStat")).equals((Object)VerificationStatus.ERROR)) {
            L10nOptionPaneBuilder.getInstance().showError((Object)"Failed to verify the biometric signature against locally onboarded users.\nPlease try again.", (Component)this.osd.getWindowForScaffold(pScafId), new Object[0]);
            bioElement.call("clearCapture");
        }
    }

    @EventHandler(name="hID_QSS_Cfm", method="actionPerformed")
    public void onShowCfmQSS(ILiteEvent evt) {
        String pScafId = evt.getScaffoldId();
        Map eMap = this.osd.getView(evt.getViewId()).getElementMap();
        CaptureAttempt attempt = (CaptureAttempt)((IViewElement)eMap.get(evt.getExtraParameters().get("prm_BioFieldName"))).get("captureAttempt");
        Object qssData = attempt.getQSS();
        if (qssData == null) {
            return;
        }
        if (qssData instanceof FingerprintQSS) {
            String scafId = this.osd.compose(pScafId, "qssWin", "fingerQssView");
            ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
            this.populateFingerQSS((FingerprintQSS)qssData, view.getElementMap(), false);
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        } else if (qssData instanceof IrisQSS) {
            String scafId = this.osd.compose(pScafId, "qssWin", "irisQssView");
            ILiteView view = this.osd.getView(this.osd.getScaffold(scafId).getViewId());
            this.populateIrisQSS((IrisQSS)qssData, view.getElementMap(), false);
            this.osd.display(scafId, ScaffoldPlacement.CENTERED);
        }
    }

    private void populateFaceQSS(FaceQSS qss, Map<String, IViewElement> eMap, boolean initial) {
        eMap.get("eID_Qss_OverallScore").set("text", (Object)SCORE_FORMAT.format(qss.getOverallScore()));
        eMap.get("eID_Qss_OverallCompliance").set("text", (Object)qss.getOverallCompliance().toString());
        eMap.get("eID_Qss_OverallComment").set("text", (Object)("<html>" + qss.getOverallComments()));
        ArrayList tableData = new ArrayList();
        qss.getQualityFeedback().forEach(fqb -> this.addQATableEntry(initial, fqb.getCompliance(), fqb.getQualityAttribute().toString(), fqb.getScore(), fqb.getComments(), null, tableData));
        eMap.get("eID_Qss_Details").set("value", tableData);
    }

    private void populateFingerQSS(FingerprintQSS qss, Map<String, IViewElement> eMap, boolean initial) {
        eMap.get("eID_Qss_OverallScore").set("text", (Object)SCORE_FORMAT.format(qss.getOverallScore()));
        eMap.get("eID_Qss_OverallCompliance").set("text", (Object)qss.getOverallCompliance().toString());
        eMap.get("eID_Qss_OverallComment").set("text", (Object)("<html>" + qss.getOverallComments()));
        ArrayList tableData = new ArrayList();
        qss.getQualityFeedback().forEach(fqb -> this.addQATableEntry(initial, fqb.getCompliance(), fqb.getQualityAttribute().toString(), fqb.getScore(), fqb.getComments(), null, tableData));
        eMap.get("eID_Qss_Details").set("value", tableData);
    }

    private void populateIrisQSS(IrisQSS qss, Map<String, IViewElement> eMap, boolean initial) {
        eMap.get("eID_Qss_OverallScore").set("text", (Object)SCORE_FORMAT.format(qss.getOverallScore()));
        eMap.get("eID_Qss_OverallCompliance").set("text", (Object)qss.getOverallCompliance().toString());
        eMap.get("eID_Qss_OverallComment").set("text", (Object)("<html>" + qss.getOverallComments()));
        ArrayList tableData = new ArrayList();
        qss.getQualityFeedback().forEach(iqb -> this.addQATableEntry(initial, iqb.getCompliance(), iqb.getQualityAttribute().toString(), iqb.getScore(), iqb.getComments(), null, tableData));
        eMap.get("eID_Qss_Details").set("value", tableData);
    }

    private void populateDualIrisQSS(Map<String, IViewElement> eMap, IrisQSS leftQss, IrisQSS rightQss) {
        ArrayList tableData = new ArrayList();
        if (leftQss != null) {
            eMap.get("eID_Qss_OverallScoreLeft").set("text", (Object)SCORE_FORMAT.format(leftQss.getOverallScore()));
            eMap.get("eID_Qss_OverallComplianceLeft").set("text", (Object)leftQss.getOverallCompliance().toString());
            eMap.get("eID_Qss_OverallCommentLeft").set("text", (Object)("<html>" + leftQss.getOverallComments()));
            leftQss.getQualityFeedback().forEach(iqb -> this.addQATableEntry(true, iqb.getCompliance(), iqb.getQualityAttribute().toString(), iqb.getScore(), iqb.getComments(), "Left Iris", tableData));
        }
        if (rightQss != null) {
            eMap.get("eID_Qss_OverallScoreRight").set("text", (Object)SCORE_FORMAT.format(rightQss.getOverallScore()));
            eMap.get("eID_Qss_OverallComplianceRight").set("text", (Object)rightQss.getOverallCompliance().toString());
            eMap.get("eID_Qss_OverallCommentRight").set("text", (Object)("<html>" + rightQss.getOverallComments()));
            rightQss.getQualityFeedback().forEach(iqb -> this.addQATableEntry(true, iqb.getCompliance(), iqb.getQualityAttribute().toString(), iqb.getScore(), iqb.getComments(), "Right Iris", tableData));
        }
        eMap.get("eID_Qss_DualDetails").set("value", tableData);
    }

    private void addQATableEntry(boolean initial, Compliance compliance, String qualityAttr, double score, String comments, String modality, ArrayList<QATableEntry> tableData) {
        if (initial) {
            switch (compliance) {
                case OK: 
                case NOT_APPLIED: 
                case OPTIONAL: {
                    return;
                }
            }
        }
        QATableEntry entry = new QATableEntry();
        entry.setQualityAttribute(qualityAttr);
        entry.setValue(SCORE_FORMAT.format(score));
        entry.setCompliance(compliance.toString());
        entry.setComment(comments);
        if (modality != null) {
            entry.setModality(modality);
        }
        tableData.add(entry);
    }
}

