/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.qss;

import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.biometrics.postcap.LVSProcessor;
import in.gov.uidai.ec.biometrics.rddup.DedupError;
import in.gov.uidai.ec.biometrics.rddup.DedupStatus;
import in.gov.uidai.ec.biometrics.rddup.IResidentDedupAnalyzer;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.onboarding.OnboardingService;
import in.gov.uidai.ec.service.onboarding.UserCredentials;
import in.gov.uidai.ec.ui.enrol.qss.IQSSDedupConstants;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysCommon;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysQSS;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IOnScreenDisplayAware;
import in.gov.uidai.litef.devapi.IViewElement;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.FingerSegment;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.swing.bio.BiometricsEvent;
import in.gov.uidai.swing.bio.capture.BiometricsCaptureField;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import org.apache.commons.lang.StringUtils;

public class QssDedupControl
implements IOnScreenDisplayAware,
IQSSDedupConstants {
    private IOnScreenDisplay osd;
    private IResidentDedupAnalyzer rddup;
    private IResourceBundleContext rbCtxt;
    private IUIPreference uiPref;
    private OnboardingService onboardingService;

    public void populateOnScreenDisplay(IOnScreenDisplay osd) {
        this.osd = osd;
    }

    public void setResidentDedupAnalyzer(IResidentDedupAnalyzer rddup) {
        this.rddup = rddup;
    }

    public final void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public final void setUIPreference(IUIPreference pref) {
        this.uiPref = pref;
    }

    public void setOnboardingService(OnboardingService onboardingService) {
        this.onboardingService = onboardingService;
    }

    @EventHandler(name="hID_QSSDedup_PhotoCapture", method="componentIsBusy")
    public void onPhotoQSSInProgress(ILiteEvent evt) {
        this.onBioFieldBusy(evt, (Object)MsgKeysQSS.VEX_PHOTO);
    }

    @EventHandler(name="hID_QSSDedup_PhotoCapture", method="componentIsReady")
    public void onPhotoQSSFinished(ILiteEvent evt) {
        this.onBioFieldReady(evt);
    }

    @EventHandler(name="hID_QSSDedup_FingerCapture", method="componentIsBusy")
    public void onFingerQSSInProgress(ILiteEvent evt) {
        this.onBioFieldBusy(evt, (Object)MsgKeysQSS.VEX_FINGER);
    }

    @EventHandler(name="hID_QSSDedup_FingerCapture", method="componentIsReady")
    public void onFingerQSSFinished(ILiteEvent evt) {
        this.onBioFieldReady(evt);
    }

    @EventHandler(name="hID_QSSDedup_IrisCapture", method="componentIsBusy")
    public void onIrisQSSInProgress(ILiteEvent evt) {
        this.onBioFieldBusy(evt, (Object)MsgKeysQSS.VEX_IRIS);
    }

    @EventHandler(name="hID_QSSDedup_IrisCapture", method="componentIsReady")
    public void onIrisQSSFinished(ILiteEvent evt) {
        this.onBioFieldReady(evt);
    }

    @EventHandler(name="hID_QSSDedup_Confirm", method="componentIsBusy")
    public void onConfirmQSSInProgress(ILiteEvent evt) {
        this.onBioFieldBusy(evt, (Object)MsgKeysQSS.VEX_CONFIRM);
    }

    @EventHandler(name="hID_QSSDedup_Confirm", method="componentIsReady")
    public void onConfirmQSSFinished(ILiteEvent evt) {
        this.onBioFieldReady(evt);
    }

    @EventHandler(name="hID_QSSDedup_FingerCapture", method="sampleReceived")
    public void onFingerSampleReceived(ILiteEvent evt) {
        Object[] cids = this.detectDedup(evt, true);
        if (cids.length > 0) {
            ILiteView view = this.osd.getView(evt.getViewId());
            Map eMap = view.getElementMap();
            ((IViewElement)eMap.get("eID_FingerTab_LeftSlap")).mset("delete", cids);
            ((IViewElement)eMap.get("eID_FingerTab_RightSlap")).mset("delete", cids);
            ((IViewElement)eMap.get("eID_FingerTab_ThumbSlap")).mset("delete", cids);
        }
    }

    @EventHandler(name="hID_QSSDedup_FingerCapture", method="sampleDeleted")
    public void onFingerSampleDeleted(ILiteEvent evt) {
        BiometricsEvent bevt = (BiometricsEvent)evt.getEvent();
        Arrays.stream(bevt.getAttemptIds()).forEach(aid -> this.rddup.delete(aid));
    }

    @EventHandler(name="hID_QSSDedup_IrisCapture", method="sampleReceived")
    public void onIrisSampleReceived(ILiteEvent evt) {
        Object[] cids = this.detectDedup(evt, false);
        if (cids.length > 0) {
            ILiteView view = this.osd.getView(evt.getViewId());
            Map eMap = view.getElementMap();
            ((IViewElement)eMap.get("eID_IrisTab_LeftEye")).mset("delete", cids);
            ((IViewElement)eMap.get("eID_IrisTab_RightEye")).mset("delete", cids);
        }
    }

    @EventHandler(name="hID_QSSDedup_IrisCapture", method="sampleDeleted")
    public void onIrisSampleDeleted(ILiteEvent evt) {
        BiometricsEvent bevt = (BiometricsEvent)evt.getEvent();
        Arrays.stream(bevt.getAttemptIds()).forEach(aid -> this.rddup.delete(aid));
    }

    private void onBioFieldBusy(ILiteEvent evt, Object message) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext vxc = view.getVisualExecutionContext();
        if (vxc != null) {
            vxc.reset();
            vxc.setMessage(message.toString());
        }
    }

    private void onBioFieldReady(ILiteEvent evt) {
        ILiteView view = this.osd.getView(evt.getViewId());
        IVisualExecutionContext vxc = view.getVisualExecutionContext();
        if (vxc != null) {
            vxc.cancel();
        }
    }

    private boolean isBioDataMatchesWithOnboardUsers(BiometricsCaptureField capField, String[] attemptIds) {
        ILocalVerificationService lvs;
        List allOnboardedUsers = this.onboardingService.getAllOnboardedUsers();
        if (allOnboardedUsers.size() == 0) {
            return false;
        }
        try {
            lvs = LVSLocator.instance();
        }
        catch (Exception exep) {
            return true;
        }
        for (String attemptId : attemptIds) {
            block6: for (Map.Entry entry : capField.getAllCurrentAttempts().entrySet()) {
                String aid = ((CaptureAttempt)entry.getValue()).getId();
                if (!StringUtils.equalsIgnoreCase((String)attemptId, (String)aid)) continue;
                switch ((BiometricPosition)entry.getKey()) {
                    case LEFT_IRIS: 
                    case RIGHT_IRIS: 
                    case BOTH_IRIS: {
                        LVSProcessor processor = new LVSProcessor(((CaptureAttempt)entry.getValue()).getImage(), (BiometricPosition)entry.getKey());
                        for (UserCredentials users : allOnboardedUsers) {
                            if (!processor.verify(users.getUid(), "iris")) continue;
                            return true;
                        }
                        continue block6;
                    }
                    default: {
                        List templates = ((CaptureAttempt)entry.getValue()).getTemplates();
                        String uid = lvs.identifyUser(templates);
                        if (!StringUtils.isNotBlank((String)uid)) continue block6;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private DedupInput[] createDedupInputs(BiometricsCaptureField capField, String[] attemptIds, boolean fingerPrint) {
        if (!fingerPrint) {
            return new DedupInput[0];
        }
        DedupInput[] ddiList = new DedupInput[attemptIds.length];
        block0: for (int i = 0; i < attemptIds.length; ++i) {
            for (Map.Entry entry : capField.getAllCurrentAttempts().entrySet()) {
                DedupInput ddi;
                String aid = ((CaptureAttempt)entry.getValue()).getId();
                if (!StringUtils.equalsIgnoreCase((String)attemptIds[i], (String)aid)) continue;
                List fingerSegments = ((FingerprintQSS)((CaptureAttempt)entry.getValue()).getQSS()).getFingerSegments();
                HashMap<BiometricPosition, Double> nfiqScoreMap = new HashMap<BiometricPosition, Double>();
                for (FingerSegment fingerSegment : fingerSegments) {
                    nfiqScoreMap.put(fingerSegment.getFingerPosition(), fingerSegment.getQuality());
                }
                List tplList = ((CaptureAttempt)entry.getValue()).getTemplates();
                ddiList[i] = ddi = new DedupInput((BiometricPosition)entry.getKey(), aid, tplList, nfiqScoreMap);
                continue block0;
            }
        }
        return ddiList;
    }

    private boolean isDeleteCurrent(List<DedupError> ddeList, Component msgPeer) {
        JOptionPane optPane;
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        ArrayList<JComponent> messages = new ArrayList<JComponent>();
        for (DedupError dde : ddeList) {
            Object aid2;
            if (dde.getStatus().equals((Object)DedupStatus.BAD_MATCH)) {
                JLabel label = new JLabel(this.rbCtxt.getMessage((Object)MsgKeysQSS.DEDUP_BADMATCH, new Object[]{dde.getConflictingAttempts().size()}));
                ldeco.localize(label, (Object)MsgKeysQSS.DEDUP_BADMATCH, new Object[]{dde.getConflictingAttempts().size()});
                messages.add(label);
            }
            if (!dde.getStatus().equals((Object)DedupStatus.DUPLICATE_BIO)) continue;
            HashMap<BiometricPosition, Integer> posCountMap = new HashMap<BiometricPosition, Integer>();
            List conflictIds = dde.getConflictingAttempts();
            for (Object aid2 : conflictIds) {
                BiometricPosition bpos = this.rddup.getPosition((String)aid2);
                if (posCountMap.containsKey(bpos)) {
                    int value = (Integer)posCountMap.get(bpos) + 1;
                    posCountMap.put(bpos, value);
                    continue;
                }
                posCountMap.put(bpos, 1);
            }
            StringBuilder sb = new StringBuilder();
            aid2 = posCountMap.entrySet().iterator();
            while (aid2.hasNext()) {
                Map.Entry entry = (Map.Entry)aid2.next();
                sb.append(((BiometricPosition)entry.getKey()).name()).append('(').append(entry.getValue()).append(')').append(' ');
            }
            JLabel label = new JLabel(this.rbCtxt.getMessage((Object)MsgKeysQSS.DEDUP_CONFLICT, new Object[]{sb}));
            ldeco.localize(label, (Object)MsgKeysQSS.DEDUP_CONFLICT, new Object[]{sb});
            messages.add(label);
        }
        JRadioButton currentOpt = new JRadioButton(this.rbCtxt.getMessage((Object)MsgKeysQSS.DELETE_CURRENT, new Object[0]));
        ldeco.localize((AbstractButton)currentOpt, (Object)MsgKeysQSS.DELETE_CURRENT, new Object[0]);
        messages.add(currentOpt);
        JRadioButton otherOpt = new JRadioButton(this.rbCtxt.getMessage((Object)MsgKeysQSS.DELETE_OTHER, new Object[0]));
        ldeco.localize((AbstractButton)otherOpt, (Object)MsgKeysQSS.DELETE_OTHER, new Object[0]);
        messages.add(otherOpt);
        ButtonGroup bg = new ButtonGroup();
        bg.add(currentOpt);
        bg.add(otherOpt);
        do {
            optPane = new JOptionPane(messages.toArray(), 3, -1);
            optPane.setOptions(new Object[]{MsgKeysCommon.OK});
            this.localizeRecursive(optPane, ldeco);
            optPane.createDialog(msgPeer, this.rbCtxt.getMessage((Object)MsgKeysCommon.TITLE, new Object[0])).setVisible(true);
        } while (optPane.getValue() == null || !optPane.getValue().equals((Object)MsgKeysCommon.OK) || !currentOpt.isSelected() && !otherOpt.isSelected());
        return currentOpt.isSelected();
    }

    private void localizeRecursive(JComponent root, L10nDecorator ldeco) {
        Component[] components;
        for (Component comp : components = root.getComponents()) {
            if (comp instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)comp;
                ldeco.localize(button, (Object)button.getText(), new Object[0]);
                continue;
            }
            if (!(comp instanceof JComponent)) continue;
            this.localizeRecursive((JComponent)comp, ldeco);
        }
    }

    private Object[] detectDedup(ILiteEvent evt, boolean fingerPrint) {
        Object[] cids = new Object[]{};
        BiometricsEvent bevt = (BiometricsEvent)evt.getEvent();
        if (!(bevt.getSource() instanceof BiometricsCaptureField)) {
            return cids;
        }
        String[] attemptIds = bevt.getAttemptIds();
        if (attemptIds == null || attemptIds.length == 0) {
            return cids;
        }
        BiometricsCaptureField capField = (BiometricsCaptureField)bevt.getSource();
        boolean bioDataMatchesOnboardedUsers = this.isBioDataMatchesWithOnboardUsers(capField, attemptIds);
        if (bioDataMatchesOnboardedUsers) {
            L10nOptionPaneBuilder.getInstance().showError((Object)MsgKeysQSS.DEDUP_ONBOARD, (Component)this.osd.getWindowForScaffold(evt.getScaffoldId()), new Object[0]);
            capField.doDeleteCapture();
            return cids;
        }
        DedupInput[] ddiList = this.createDedupInputs(capField, attemptIds, fingerPrint);
        Window win = this.osd.getWindowForScaffold(evt.getScaffoldId());
        for (DedupInput ddi : ddiList) {
            List ddeList = this.rddup.add(ddi.getPosition(), ddi.getAttemptId(), ddi.getTemplates(), ddi.getNfiqScoreMap());
            this.rddup.stat();
            if (ddeList.isEmpty()) continue;
            if (this.isDeleteCurrent(ddeList, win)) {
                capField.delete(ddi.attemptId);
            } else {
                ArrayList cidList = new ArrayList();
                ddeList.stream().map(DedupError::getConflictingAttempts).forEach(cidList::addAll);
                cids = cidList.toArray();
            }
            this.rddup.stat();
        }
        return cids;
    }

    private static class DedupInput {
        private final BiometricPosition bioPos;
        private final String attemptId;
        private final List<BiometricTemplate> tplList;
        private final HashMap<BiometricPosition, Double> nfiqScoreMap;

        DedupInput(BiometricPosition pos, String attemptId, List<BiometricTemplate> tplList, HashMap<BiometricPosition, Double> nfiqScoreMap) {
            this.bioPos = pos;
            this.attemptId = attemptId;
            this.tplList = tplList;
            this.nfiqScoreMap = nfiqScoreMap;
        }

        BiometricPosition getPosition() {
            return this.bioPos;
        }

        String getAttemptId() {
            return this.attemptId;
        }

        List<BiometricTemplate> getTemplates() {
            return this.tplList;
        }

        HashMap<BiometricPosition, Double> getNfiqScoreMap() {
            return this.nfiqScoreMap;
        }
    }
}

