/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.combo.UidComboField;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.swing.tlit.DirectTranslitAssociation;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.swing.tlit.IMTranslitFieldBuilder;
import in.gov.uidai.ec.ui.enrol.references.IntroducerListRenderer;
import in.gov.uidai.ec.ui.enrol.references.IntroducerOptionHandler;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.InlineValidations;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysRefTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.EidUidFieldBuilder;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.table.TableLayout;
import in.gov.uidai.swing.translit.AbstractIMTranslitField;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class IntroducerPanel
implements IViewElementComposite {
    private final IResourceBundleContext rbc;
    private final IUIPreference pref;
    UidComboField introNameField;
    JFormattedTextField introUidField;
    AbstractIMTranslitField locIntroNameField;

    IntroducerPanel(IResourceBundleContext rbc, IUIPreference pref) {
        this.rbc = rbc;
        this.pref = pref;
    }

    public JComponent create(EnrollmentService enrollmentService) {
        InlineValidations ilv = new InlineValidations(this.rbc);
        IMTranslitFieldBuilder imb = new IMTranslitFieldBuilder(this.pref, this.rbc.getLocale().toString(), enrollmentService);
        ScrollToVisibleFocusHandler svfh = new ScrollToVisibleFocusHandler();
        this.introNameField = new UidComboField();
        ilv.applyFullNameILV(this.introNameField);
        this.introNameField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.introNameField));
        this.introNameField.setOptionHandler(new IntroducerOptionHandler());
        this.introNameField.setMinTextLengthForPopup(4);
        this.introNameField.setListCellRenderer(new IntroducerListRenderer());
        this.introNameField.addFocusListener((FocusListener)svfh);
        this.introNameField.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.introNameField.setEnabled(false);
        this.locIntroNameField = imb.createIMField(this.introNameField, TransliterationHints.NAME, TransliterationHints.PERSIST);
        ilv.applyTransliteratedFullNameILV((JTextField)this.locIntroNameField);
        this.locIntroNameField.getDocument().addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.locIntroNameField));
        this.locIntroNameField.addFocusListener((FocusListener)svfh);
        this.locIntroNameField.addPropertyChangeListener((PropertyChangeListener)new ViewUtils.ClearOnDisableHandler());
        this.locIntroNameField.setEnabled(false);
        this.introUidField = EidUidFieldBuilder.createUidField();
        this.introUidField.addFocusListener((FocusListener)svfh);
        this.introUidField.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.introUidField.setEnabled(false);
        DirectTranslitField locIntroUidField = new DirectTranslitField();
        locIntroUidField.setResourceBundleContext(this.rbc);
        locIntroUidField.setLocale(this.pref.getTransliterationLocale("hi_IN"));
        locIntroUidField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        new DirectTranslitAssociation(locIntroUidField, this.introUidField);
        double[][] formGuides = new double[][]{{210.0, 5.0, 100.0}, {22.0}};
        TransparentBox introducerPanel = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuides));
        introducerPanel.add((Component)this.introNameField, (Object)"0, 0, full, full");
        introducerPanel.add((Component)this.introUidField, (Object)"2, 0, full, full");
        TransparentBox locIntroducerPanel = new TransparentBox((LayoutManager)new TableLayout((double[][])formGuides));
        locIntroducerPanel.add((Component)this.locIntroNameField, (Object)"0, 0, full, full");
        locIntroducerPanel.add((Component)locIntroUidField, (Object)"2, 0, full, full");
        return new PanelBuilder().createPanel(LabelKeysRefTab.VERIFY_INTRO_NAMEUID.toString(), (JComponent)introducerPanel, "label-tlit:verify.intro.nameuid", (JComponent)locIntroducerPanel, false, this.rbc);
    }

    public void setEnabled(boolean enabled) {
        this.introNameField.setEnabled(enabled);
        this.locIntroNameField.setEnabled(enabled);
        this.introUidField.setEnabled(enabled);
    }
}

