/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.swing.ButtonFactory;
import in.gov.uidai.ec.swing.TipListCellRenderer;
import in.gov.uidai.ec.swing.shared.PanelBuilder;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDocuments;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysRefTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PoiPanel
implements IViewElementComposite {
    private final IResourceBundleContext rbc;
    private final boolean isUpdateEnrollment;
    private final boolean isOnline;
    JComboBox<ProofDocument> poiField = new JComboBox();
    JButton scanDoc;
    JButton attachDoc;
    JButton digilocker;
    JLabel statusLbl = new JLabel();

    PoiPanel(IResourceBundleContext rbc, boolean isUpdateEnrollment, boolean isOnline) {
        this.rbc = rbc;
        this.isUpdateEnrollment = isUpdateEnrollment;
        this.isOnline = isOnline;
    }

    public JComponent create() {
        String attachIconPath = "res/ecmp/images/but-attach.png";
        String scanIconPath = "res/ecmp/images/but-scan.png";
        String digilockerIconPath = "res/ecmp/images/but-registry.png";
        double[][] guides = new double[][]{{470.0, 20.0, 30.0, 20.0, 30.0, 20.0, 30.0, 20.0, -1.0}, {10.0, -1.0, 5.0}};
        TransparentBox poiArea = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        this.poiField.setRenderer(new TipListCellRenderer(this.poiField));
        this.poiField.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.poiField.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.poiField.setEnabled(!this.isUpdateEnrollment);
        if (this.isOnline) {
            poiArea.add((Component)new PanelBuilder().createPanel(LabelKeysRefTab.VERIFY_POI.toString(), this.poiField, this.rbc), (Object)"0, 1, right, full");
        } else {
            poiArea.add((Component)new PanelBuilder().createPanel(LabelKeysRefTab.VERIFY_POI.toString(), this.poiField, false, this.rbc), (Object)"0, 1, right, full");
        }
        this.attachDoc = new ButtonFactory(this.rbc).createButton("res/ecmp/images/but-attach.png", this.rbc.getMessage((Object)LabelKeysDocuments.ATTACH, new Object[0]));
        this.attachDoc.setPreferredSize(new Dimension(30, 30));
        this.attachDoc.setVisible(false);
        poiArea.add((Component)this.attachDoc, (Object)"2, 1, left, full");
        this.scanDoc = new ButtonFactory(this.rbc).createButton("res/ecmp/images/but-scan.png", this.rbc.getMessage((Object)LabelKeysDocuments.SCAN, new Object[0]));
        this.scanDoc.setPreferredSize(new Dimension(30, 30));
        this.scanDoc.setEnabled(!this.isUpdateEnrollment);
        poiArea.add((Component)this.scanDoc, (Object)"4, 1, left, full");
        if (this.isOnline && this.isUpdateEnrollment) {
            this.digilocker = new ButtonFactory(this.rbc).createButton("res/ecmp/images/but-registry.png", this.rbc.getMessage((Object)LabelKeysDocuments.ATTACH, new Object[0]));
            this.digilocker.setPreferredSize(new Dimension(30, 30));
            this.digilocker.setEnabled(false);
            poiArea.add((Component)this.digilocker, (Object)"6, 1, left, full");
        }
        this.statusLbl.setEnabled(!this.isUpdateEnrollment);
        this.statusLbl.setVisible(!this.isUpdateEnrollment);
        if (this.isOnline && this.isUpdateEnrollment) {
            poiArea.add((Component)this.statusLbl, (Object)"8, 1, left, full");
        } else {
            poiArea.add((Component)this.statusLbl, (Object)"6, 1, left, full");
        }
        return poiArea;
    }

    public void setEnabled(boolean enabled) {
        this.poiField.setEnabled(enabled);
        this.attachDoc.setEnabled(enabled);
        this.scanDoc.setEnabled(enabled);
        this.statusLbl.setVisible(enabled);
        this.statusLbl.setEnabled(enabled);
    }

    public void disableScan(boolean disabled) {
        this.attachDoc.setEnabled(!disabled);
        this.scanDoc.setEnabled(!disabled);
    }
}

