/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.ui.enrol.references.OnlineQCResultTableModel;
import in.gov.uidai.ec.ui.enrol.references.QCMismatchMessagePanel;
import in.gov.uidai.ec.ui.enrol.references.QCPanel;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.swing.l10n.MsgKeysCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.apache.commons.lang.StringUtils;

public class QCViewPeer
extends StandardViewPeer {
    protected QCPanel qcPanel;
    protected QCMismatchMessagePanel qcMismatchMessagePanel;
    private IResourceBundleContext rbCtxt;
    private EnrollmentService enrollmentService;
    private ActionListener closeListener;
    JButton close;
    JButton overrideBtn;
    private JPanel closePanel;
    private JLabel closeLabel;
    private JPanel overridePanel;
    private JLabel overrideLabel;
    private JPanel overrideRow;
    private JPanel closeRow;
    private static final Color customBlue = new Color(19, 126, 178);

    protected void prepareImpl() {
        this.qcMismatchMessagePanel = new QCMismatchMessagePanel(this.rbCtxt);
        this.qcPanel = new QCPanel();
        TransparentBox cntPane = new TransparentBox();
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        cntPane.setPreferredSize(new Dimension((int)resolution.getWidth() / 2, (int)(10.0 * resolution.getHeight()) / 20));
        if (this.enrollmentService.getDocManager().getDvsResultMap().size() > 0) {
            cntPane.add(Box.createVerticalStrut(5));
            cntPane.add((Component)this.qcMismatchMessagePanel.create());
        }
        cntPane.add(Box.createVerticalStrut(5));
        cntPane.add((Component)this.qcPanel.create());
        cntPane.add(Box.createVerticalStrut(5));
        this.overrideBtn = new JButton("Override");
        this.overrideBtn.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(5, 5));
        this.overrideBtn.setFocusable(true);
        this.overrideBtn.setVisible(false);
        this.overridePanel = new JPanel();
        this.overrideLabel = new JLabel("Override");
        this.closePanel = new JPanel();
        this.closeLabel = new JLabel("Close");
        this.overrideRow = new JPanel();
        this.closeRow = new JPanel();
        this.addPanelToRow(this.overrideRow, this.overridePanel);
        this.addPanelToRow(this.closeRow, this.closePanel);
        this.buttonViewPeer(this.overridePanel, this.overrideLabel);
        this.buttonViewPeer(this.closePanel, this.closeLabel);
        this.addListener(this.overridePanel);
        this.addListener(this.closePanel);
        boolean isDvsFail = this.enrollmentService.getDocManager().getDvsResultMap().values().stream().anyMatch(error -> error.contains("Technical Error"));
        if (this.enrollmentService.getDocManager().getDvsResultMap().size() > 0 && !isDvsFail) {
            cntPane.add((Component)this.overrideRow);
        }
        cntPane.add(Box.createVerticalStrut(5));
        this.close = new JButton("close");
        this.close.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(5, 5));
        this.close.setFocusable(true);
        this.close.setVisible(false);
        cntPane.add((Component)this.closeRow);
        cntPane.setLayout((LayoutManager)new BoxLayout((Container)cntPane, 1));
        this.setContentPane((JComponent)cntPane);
        super.setVisualExecutionContext((IVisualExecutionContext)new ModalVisualExecutionContext((JComponent)cntPane, false));
        this.closeListener = (ActionListener)this.evtCtxt.getEventListener("closeWin", ActionListener.class);
        this.close.addActionListener(this::onCloseButtonClick);
        this.overrideBtn.addActionListener(this::onOverrideButtonClick);
        this.populateDataToTable(this.enrollmentService.getDocManager().getDvsResultMap());
    }

    private void buttonViewPeer(JPanel panel, JLabel label) {
        label.setFont(new Font("Segoe UI", 1, 14));
        label.setForeground(Color.white);
        label.setHorizontalAlignment(0);
        panel.setBackground(customBlue);
        GroupLayout savePanelLayout = new GroupLayout(panel);
        panel.setLayout(savePanelLayout);
        savePanelLayout.setHorizontalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label, GroupLayout.Alignment.TRAILING, -1, 100, Short.MAX_VALUE));
        savePanelLayout.setVerticalGroup(savePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label, GroupLayout.Alignment.TRAILING, -1, 31, Short.MAX_VALUE));
    }

    private void addPanelToRow(JPanel row, JPanel panel) {
        GroupLayout buttonLayout2 = new GroupLayout(row);
        row.setLayout(buttonLayout2);
        buttonLayout2.setHorizontalGroup(buttonLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(panel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        buttonLayout2.setVerticalGroup(buttonLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonLayout2.createSequentialGroup().addContainerGap().addComponent(panel, -2, -1, -2).addContainerGap(17, Short.MAX_VALUE)));
    }

    private void addListener(final JPanel panel) {
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                QCViewPeer.this.selectPanel(panel);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (panel == QCViewPeer.this.overridePanel) {
                    QCViewPeer.this.overrideBtn.doClick();
                } else if (panel == QCViewPeer.this.closePanel) {
                    QCViewPeer.this.close.doClick();
                } else {
                    return;
                }
                QCViewPeer.this.unSelectPanel(panel);
            }
        });
    }

    private void selectPanel(JPanel panel) {
        panel.setBackground(Color.white);
        panel.getComponent(0).setForeground(customBlue);
    }

    private void unSelectPanel(JPanel panel) {
        panel.setBackground(customBlue);
        panel.getComponent(0).setForeground(Color.white);
    }

    public void populateDataToTable(Map<String, List<String>> dvsUnmatched) {
        Object[][] data = new String[3][3];
        if (this.enrollmentService.isHofEnrollment()) {
            data = new String[4][3];
            this.setQCResultTableModel(data[3], "POR", dvsUnmatched.get("POR"));
        } else if (this.enrollmentService.isForeignResident()) {
            data = new String[4][3];
            this.setQCResultTableModel(data[3], "POF", dvsUnmatched.get("POF"));
        }
        this.setQCResultTableModel(data[0], "POI", dvsUnmatched.get("POI"));
        this.setQCResultTableModel(data[1], "POA", dvsUnmatched.get("POA"));
        this.setQCResultTableModel(data[2], "POB", dvsUnmatched.get("POB"));
        ((OnlineQCResultTableModel)this.qcPanel.qcResultsTable.getModel()).setValues(data);
    }

    private void setQCResultTableModel(String[] data, String type, List<String> comments) {
        String displayMsg = "";
        if (comments != null) {
            for (String comment : comments) {
                displayMsg = displayMsg + comment;
                displayMsg = displayMsg + "\n";
            }
            displayMsg = displayMsg + "<br><p color=\"red\">Please upload document again </p>";
        } else {
            displayMsg = "<br><p color=\"green\">Verified</p>";
        }
        References references = this.enrollmentService.getReferences();
        switch (type) {
            case "POI": {
                data[0] = "Identity Proof";
                data[1] = this.documentNameForDisplay(references.getPoi().getProof());
                displayMsg = references.getPoi().getProof().getDocId().length() == 0 ? "N/A" : displayMsg;
                break;
            }
            case "POB": {
                data[0] = "Birth Proof";
                data[1] = this.documentNameForDisplay(references.getPob().getProof());
                displayMsg = references.getPob().getProof().getDocId().length() == 0 ? "N/A" : displayMsg;
                break;
            }
            case "POA": {
                data[0] = "Address Proof";
                data[1] = this.documentNameForDisplay(references.getPoa().getProof());
                displayMsg = references.getPoa().getProof().getDocId().length() == 0 ? "N/A" : displayMsg;
                break;
            }
            case "POR": {
                data[0] = "Relation Proof";
                data[1] = this.documentNameForDisplay(references.getPor().getProof());
                displayMsg = references.getPor().getProof().getDocId().length() == 0 ? "N/A" : displayMsg;
                break;
            }
            case "POF": {
                data[0] = "Additional Proof";
                data[1] = this.documentNameForDisplay(references.getPof().getProof());
                displayMsg = references.getPof().getProof().getDocId().length() == 0 ? "N/A" : displayMsg;
            }
        }
        data[1] = "<html>" + data[1] + "</html>";
        data[2] = "<html>" + displayMsg + "</html>";
    }

    private void onOverrideButtonClick(ActionEvent actionEvent) {
        boolean overrideQcErrors = L10nOptionPaneBuilder.getInstance().showYesNoUC("Are you Sure ?\nDo you want to override the document errors?", (Component)this.qcMismatchMessagePanel.qcErrorMsgLabel.getRootPane()).equals((Object)MsgKeysCommon.YES);
        this.enrollmentService.getDocManager().setDocValidationOverride(overrideQcErrors);
        this.closeListener.actionPerformed(actionEvent);
    }

    private void onCloseButtonClick(ActionEvent actionEvent) {
        this.closeListener.actionPerformed(actionEvent);
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setRbCtxt(IResourceBundleContext rbCtxt) {
        this.rbCtxt = rbCtxt;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }

    private String documentNameForDisplay(ProofDocument proofDocument) {
        if (proofDocument == null) {
            return "N/A";
        }
        String docName = proofDocument.getDocName();
        if (StringUtils.isBlank((String)docName) || StringUtils.equalsIgnoreCase((String)docName, (String)"Select")) {
            return "N/A";
        }
        return docName;
    }
}

