/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references;

import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.FixedWidthTopDownTile;
import in.gov.uidai.ec.swing.shared.HeaderPanel;
import in.gov.uidai.ec.swing.shared.NavigationPanel;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.document.IDocumentsPreference;
import in.gov.uidai.ec.ui.enrol.document.ScannerConfigComposite;
import in.gov.uidai.ec.ui.enrol.fingerprint.FingerPrintTabViewPeer;
import in.gov.uidai.ec.ui.enrol.iris.IrisTabViewPeer;
import in.gov.uidai.ec.ui.enrol.photograph.PhotographTabViewPeer;
import in.gov.uidai.ec.ui.enrol.references.PobPanel;
import in.gov.uidai.ec.ui.enrol.references.ReferencesController;
import in.gov.uidai.ec.ui.enrol.references.RelativeHeaderPanel;
import in.gov.uidai.ec.ui.enrol.references.RelativePanel;
import in.gov.uidai.ec.ui.enrol.references.VerificationPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewTabViewPeer;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.ExplicitFocusTraversalPolicy;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class ReferenceTabViewPeer
implements IViewElementComposite,
INavigationConstants {
    protected final IUIPreference uiPref;
    protected final IDocumentsPreference docPref;
    protected final IOucDataStore oucDataStore;
    protected final IEventContext evtCtxt;
    protected final ILiteView view;
    private final EnrollmentService enrollmentService;
    protected IResourceBundleContext enrolRbctx;
    protected VerificationPanel verificationPanel;
    protected ScannerConfigComposite scannerConfigPanel;
    protected RelativePanel relativePanel;
    protected PobPanel pobPanel;
    protected RelativeHeaderPanel relativeHeaderPanel;
    protected NavigationPanel navigationPanel;
    private FixedWidthTopDownTile mainTile;
    protected JTabbedPane tabbedPane;
    protected PhotographTabViewPeer photoTab;
    protected FingerPrintTabViewPeer fingerTab;
    protected IrisTabViewPeer irisTab;
    protected ReviewTabViewPeer reviewTabViewPeer;
    protected IEventContext eventContext;
    private int tabIndex;

    public ReferenceTabViewPeer(EnrolViewPeer view, IEventContext eventContext) {
        this.reviewTabViewPeer = view.getReviewTab();
        this.photoTab = view.getPhotoTab();
        this.fingerTab = view.getFingerTab();
        this.irisTab = view.getIrisTab();
        this.tabbedPane = view.getTabbedPane();
        this.view = view.getView();
        this.enrolRbctx = view.enrolRbCtxt;
        this.uiPref = view.uiPref;
        this.enrollmentService = view.enrollmentService;
        boolean isUpdateEnrollment = view.enrollmentService.isUpdateEnrollment();
        this.docPref = view.docPref;
        this.oucDataStore = view.oucDataStore;
        this.evtCtxt = view.evtCtxt;
        this.eventContext = eventContext;
        this.scannerConfigPanel = new ScannerConfigComposite(this.enrolRbctx, this.docPref, this.oucDataStore, view.getView(), view.prefStore, true, this.enrollmentService.isOnlineUpdate());
        this.pobPanel = new PobPanel(this.enrolRbctx, isUpdateEnrollment, this.enrollmentService.isUniversalClientTrnx());
        this.verificationPanel = new VerificationPanel(this.enrolRbctx, this.uiPref, isUpdateEnrollment, this.enrollmentService.isUniversalClientTrnx(), eventContext);
        this.relativeHeaderPanel = new RelativeHeaderPanel(this.enrolRbctx, this.uiPref, this.enrollmentService.isUniversalClientTrnx());
        this.relativePanel = new RelativePanel(this.enrolRbctx, this.uiPref, this.enrollmentService.isUniversalClientTrnx(), this.enrollmentService);
        this.navigationPanel = new NavigationPanel(this.enrolRbctx, this.uiPref);
    }

    public void prepare() {
        HeaderPanel headerPanel = null;
        headerPanel = this.enrollmentService.isUniversalClientTrnx() ? new HeaderPanel(this.enrolRbctx, this.uiPref, this.enrollmentService.isUniversalClientTrnx()) : new HeaderPanel(this.enrolRbctx, this.uiPref);
        this.mainTile = new FixedWidthTopDownTile();
        this.mainTile.setWidth(1000);
        this.mainTile.setScrollable(true);
        this.mainTile.setPadding(5, 0, 5, 0);
        this.mainTile.prepare();
        this.mainTile.addTopComponent(Box.createVerticalStrut(15));
        this.mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.SCANNER_CONFIG.toString()));
        this.mainTile.addTopComponent(this.scannerConfigPanel.toSwing());
        this.mainTile.addTopComponent(Box.createVerticalStrut(15));
        this.mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.POB.toString()));
        this.mainTile.addTopComponent(this.pobPanel.create());
        this.mainTile.addTopComponent(Box.createVerticalStrut(15));
        this.mainTile.addTopComponent(headerPanel.create(LabelKeysHeader.VERIFICATION.toString()));
        this.mainTile.addTopComponent(this.verificationPanel.create());
        this.mainTile.addTopComponent(Box.createVerticalStrut(15));
        if (!this.enrollmentService.isUniversalClientTrnx()) {
            this.mainTile.addTopComponent(this.relativeHeaderPanel.create());
            this.mainTile.addTopComponent(this.relativePanel.toSwing());
        }
        this.mainTile.setBottomComponent(this.navigationPanel.create(new Component[0]));
        new ReferencesController(this.view, this, this.enrollmentService, this.tabIndex);
        this.addTraversal();
    }

    public void renderReferencesTab() {
        this.tabbedPane.addTab(this.enrolRbctx.getMessage((Object)LabelKeysTab.REF, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createReferenceLabel());
    }

    private JLabel createReferenceLabel() {
        String ICON_PATH = "res/images/tab-error.png";
        if (this.enrollmentService.getReferences().isValid()) {
            ICON_PATH = "res/images/tab-ok.png";
        }
        ImageIcon icon = ViewUtils.getImageIcon(this.getClass(), ICON_PATH);
        JLabel label = new JLabel(this.enrolRbctx.getMessage((Object)LabelKeysTab.REF, new Object[0]));
        new L10nDecorator(this.enrolRbctx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.REF, new Object[0]);
        if (icon != null) {
            label.setIcon(icon);
        }
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public JComponent toSwing() {
        return this.mainTile.toSwing();
    }

    private void addTraversal() {
        ExplicitFocusTraversalPolicy eftp = new ExplicitFocusTraversalPolicy((Container)this.mainTile.toSwing());
        this.pobPanel.addToFocusTraversalPolicy(eftp);
        this.verificationPanel.addToFocusTraversalPolicy(eftp);
        eftp.addComponent((Component)this.relativeHeaderPanel.relNotGivenOpt);
        this.relativePanel.addToFocusTraversalPolicy(eftp);
        this.navigationPanel.addToFocusTraversalPolicy(eftp);
    }
}

