/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references;

import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedDocuments;
import in.gov.uidai.ec.service.enrollment.model.ReferenceAllowedRelationship;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.INavigationConstants;
import in.gov.uidai.ec.ui.enrol.demographics.IDemoTabConstants;
import in.gov.uidai.ec.ui.enrol.document.DocumentUtils;
import in.gov.uidai.ec.ui.enrol.references.ReferenceTabViewPeer;
import in.gov.uidai.ec.ui.enrol.references.RelativePanel;
import in.gov.uidai.ec.ui.enrol.references.VerificationPanel;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysDocuments;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.LabelAndMsgKeys;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReferencesController
extends EnrollmentControllerBase
implements IDemoTabConstants,
INavigationConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencesController.class);
    private static final String OK_ICON_PATH = "res/ecmp/images/compliance-ok.png";
    private static final String ERROR_ICON_PATH = "res/ecmp/images/compliance-error.png";
    private static final String DOC_ATTACH_TIP = "Document attached";
    private static final String DOC_NOT_ATTACH_TIP = "Document not attached";
    private final IVisualExecutionContext veCtxt;
    private final ReferenceTabViewPeer viewElements;
    private final ActionListener showPreviewListener;
    private final ActionListener showQcListener;
    private IOucDataStore oucDataStore;
    private boolean isReviewTabRendered;
    private boolean isBiometricsTabRendered;

    ReferencesController(ILiteView view, ReferenceTabViewPeer viewElements, EnrollmentService enrollmentService, int tabIndex) {
        super(view, enrollmentService, 1, tabIndex);
        this.viewElements = viewElements;
        this.oucDataStore = viewElements.oucDataStore;
        this.enrollmentService.getReferences().addValidityChangeListener(this::updateTabValidityState);
        this.enrollmentService.getDemographics().addValidityChangeListener(this::updateTabValidityState);
        this.veCtxt = viewElements.view.getVisualExecutionContext();
        this.showPreviewListener = (ActionListener)viewElements.evtCtxt.getEventListener("hID_ShowPreview", ActionListener.class);
        this.showQcListener = (ActionListener)viewElements.evtCtxt.getEventListener("showDvsQcResult", ActionListener.class);
        this.initView();
    }

    public void setOucDataStore(IOucDataStore oucDataStore) {
        this.oucDataStore = oucDataStore;
    }

    private void initView() {
        References references = this.enrollmentService.getReferences();
        this.enrollmentService.getDemoPersonalDetails().getAgeDob().addChangeListener(this::onAgeChange);
        this.enrollmentService.getDemographics().getResidentialStatus().addChangeListener(this::onResidentialStatusChange);
        references.addDocumentListRefreshListener(this::onDocumentListRefresh);
        references.getReferenceRelative().addRelationshipListRefreshListener(this::onRelationshipListRefresh);
        references.getReferenceRelative().addValidityChangeListener(this::onReferenceRelativeValidityChange);
        this.viewElements.verificationPanel.docOpt.addItemListener(this::onVerifyUsingSupportingDocOptSelected);
        this.viewElements.verificationPanel.hofOpt.addItemListener(this::onHofVerifyAddressOptSelected);
        references.getPob().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPoa().addValidityChangeListener(this::copyDocumentIfSelected);
        references.getPoi().addValidityChangeListener(this::copyDocumentIfSelected);
        if (this.enrollmentService.isUniversalClientTrnx()) {
            references.getHofDoc().addValidityChangeListener(this::copyDocumentIfSelected);
            references.getPor().addValidityChangeListener(this::copyDocumentIfSelected);
        }
        references.getHofDoc().addValidityChangeListener(e -> this.setStatusIcon(DocumentType.HOF));
        if (this.enrollmentService.isUpdateUC()) {
            this.viewElements.verificationPanel.poiPanel.digilocker.addActionListener(e -> ((ActionListener)this.viewElements.verificationPanel.eventContext.getEventListener("digilocker", ActionListener.class)).actionPerformed(e));
            this.viewElements.verificationPanel.poaPanel.digilocker.addActionListener(e -> ((ActionListener)this.viewElements.verificationPanel.eventContext.getEventListener("digilocker", ActionListener.class)).actionPerformed(e));
            this.viewElements.pobPanel.digilocker.addActionListener(e -> ((ActionListener)this.viewElements.eventContext.getEventListener("digilocker", ActionListener.class)).actionPerformed(e));
        }
        this.addItemListener(this.viewElements.pobPanel.pobField, (ItemEvent evt) -> this.onProofDocumentChange(evt, DocumentType.POB, this.viewElements.pobPanel.pobField));
        this.addActionListener(this.viewElements.pobPanel.scanDoc, (ActionEvent evt) -> this.scanDocument(evt, DocumentType.POB));
        this.addActionListener(this.viewElements.pobPanel.attachDoc, (ActionEvent evt) -> this.attachDocument(evt, DocumentType.POB));
        this.addItemListener(this.viewElements.verificationPanel.poiPanel.poiField, (ItemEvent evt) -> this.onProofDocumentChange(evt, DocumentType.POI, this.viewElements.verificationPanel.poiPanel.poiField));
        this.addActionListener(this.viewElements.verificationPanel.poiPanel.attachDoc, (ActionEvent evt) -> this.attachDocument(evt, DocumentType.POI));
        this.addActionListener(this.viewElements.verificationPanel.poiPanel.scanDoc, (ActionEvent evt) -> this.scanDocument(evt, DocumentType.POI));
        this.addItemListener(this.viewElements.verificationPanel.poaPanel.poaField, (ItemEvent evt) -> this.onProofDocumentChange(evt, DocumentType.POA, this.viewElements.verificationPanel.poaPanel.poaField));
        this.addActionListener(this.viewElements.verificationPanel.poaPanel.attachDoc, (ActionEvent evt) -> this.attachDocument(evt, DocumentType.POA));
        this.addActionListener(this.viewElements.verificationPanel.poaPanel.scanDoc, (ActionEvent evt) -> this.scanDocument(evt, DocumentType.POA));
        this.addItemListener(this.viewElements.verificationPanel.hofPanel.hofDocField, (ItemEvent evt) -> this.onPHOFChange(evt, DocumentType.HOF, this.viewElements.verificationPanel.hofPanel.hofDocField));
        this.addActionListener(this.viewElements.verificationPanel.hofPanel.attachDoc, (ActionEvent evt) -> this.attachDocument(evt, DocumentType.HOF));
        this.addActionListener(this.viewElements.verificationPanel.hofPanel.scanDoc, (ActionEvent evt) -> this.scanDocument(evt, DocumentType.HOF));
        this.addItemListener(this.viewElements.verificationPanel.porPanel.porField, (ItemEvent evt) -> this.onProofDocumentChange(evt, DocumentType.POR, this.viewElements.verificationPanel.porPanel.porField));
        this.addActionListener(this.viewElements.verificationPanel.porPanel.attachDoc, (ActionEvent evt) -> this.attachDocument(evt, DocumentType.POR));
        this.addActionListener(this.viewElements.verificationPanel.porPanel.scanDoc, (ActionEvent evt) -> this.scanDocument(evt, DocumentType.POR));
        this.viewElements.relativeHeaderPanel.relNotGivenOpt.addItemListener(this::onRelativeDetailsGivenChange);
        this.viewElements.relativePanel.relEnrolIdOpt.addItemListener(this::onRelativeEnrolmentIdSelected);
        this.viewElements.relativePanel.relUidOpt.addItemListener(this::onRelativeAadhaarNumberSelected);
        this.addItemListener(this.viewElements.relativePanel.relTypeField, this::onRelativeRelationTypeChange);
        this.addFocusListener(this.viewElements.relativePanel.relNameField, this::relativeNameFocusLost);
        this.addFocusListener((JTextField)this.viewElements.relativePanel.locRelNameField, this::relativeNameLocalFocusLost);
        this.addFocusListener(this.viewElements.relativePanel.relEnrolId1Field, this::enrolmentIdFocusLost);
        this.addFocusListener(this.viewElements.relativePanel.relEnrolId2Field, this::enrolmentIdDateTimeFocusLost);
        this.addFocusListener(this.viewElements.relativePanel.relUidField, this::relativeUidFocusLost);
        this.enrollmentService.addOnTabTransitionListeners(this::onTabTransition);
        this.enrollmentService.addOnViewLoadCompleteListeners(this::onViewLoadComplete);
        this.enrollmentService.addDisableTabListeners(e -> super.updateTabInteractionState(false));
        this.addEventListenersForUpdate();
        this.addActionListener(this.viewElements.navigationPanel.nextBut, this::onNextButtonClick);
        this.addActionListener(this.viewElements.navigationPanel.previousBut, this::onPrevButtonClick);
        this.loadMasterDataList();
        this.populateView();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.onViewLoadComplete(this);
        }
    }

    private void addEventListenersForUpdate() {
        if (!this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            return;
        }
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        Address address = this.enrollmentService.getDemographics().getContact().getAddress();
        if (this.enrollmentService.isLanguageOnlyUpdate()) {
            personalDetail.getName().addChangeListener(name -> this.onNameAddressValueChange(address, (Name)name));
            address.addChangeListener(addr -> this.onNameAddressValueChange((Address)addr, personalDetail.getName()));
        } else {
            personalDetail.getName().addUpdateChangeListener(this::onNameUpdate);
            address.addUpdateChangeListener(this::onAddressUpdate);
        }
        personalDetail.getAgeDob().addUpdateChangeListener(this::onAgeDobUpdate);
        this.enrollmentService.addResidentChildListeners(this::refreshReferenceRelative);
    }

    private void onNameAddressValueChange(Address address, Name name) {
        boolean nriEnrolment = this.enrollmentService.isNRIEnrolment();
        References references = this.enrollmentService.getReferences();
        boolean isNameChanged = name.isUpdated() && name.valueChanged();
        boolean isAddressChanged = address.isUpdated() && address.valueChanged();
        boolean isAddressOrNameUpdated = isNameChanged || isAddressChanged;
        boolean isDocumentUpdate = this.enrollmentService.isDocumentUpdate();
        boolean isOffLineDocumentUpdate = this.enrollmentService.isOffLineDocumentUpdate();
        references.getPoa().setMandatory(isAddressChanged);
        references.getPoi().setMandatory(isNameChanged || nriEnrolment);
        JRadioButton hofOpt = this.viewElements.verificationPanel.hofOpt;
        JRadioButton docOpt = this.viewElements.verificationPanel.docOpt;
        docOpt.setEnabled(isAddressOrNameUpdated || nriEnrolment || isDocumentUpdate || isOffLineDocumentUpdate);
        this.viewElements.verificationPanel.poaPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated);
        hofOpt.setEnabled(isAddressOrNameUpdated && !nriEnrolment || isOffLineDocumentUpdate);
        this.viewElements.verificationPanel.poiPanel.setEnabled(docOpt.isSelected() && (isAddressOrNameUpdated || nriEnrolment));
        hofOpt.setEnabled(isAddressOrNameUpdated && nriEnrolment || isOffLineDocumentUpdate);
        this.viewElements.verificationPanel.hofPanel.setEnabled(hofOpt.isSelected() && isAddressOrNameUpdated && nriEnrolment);
        if (this.enrollmentService.isAdultEnrollment() && address.isUpdated() || nriEnrolment || isDocumentUpdate || isOffLineDocumentUpdate) {
            hofOpt.setEnabled(true);
            this.viewElements.verificationPanel.poaPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated);
            this.viewElements.verificationPanel.poiPanel.setEnabled(docOpt.isSelected() && (isAddressOrNameUpdated || nriEnrolment));
            docOpt.setEnabled(true);
        } else if (this.enrollmentService.isMinorEnrollment() && isAddressOrNameUpdated && !nriEnrolment) {
            this.viewElements.verificationPanel.poaPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated);
            this.viewElements.verificationPanel.poiPanel.setEnabled(docOpt.isSelected() && (isAddressOrNameUpdated || nriEnrolment));
            hofOpt.setEnabled(true);
            docOpt.setEnabled(true);
        } else if (!(this.enrollmentService.isChildEnrollment() && this.enrollmentService.isMinorEnrollment() && this.enrollmentService.isAdultEnrollment() || !isAddressOrNameUpdated || nriEnrolment)) {
            this.viewElements.verificationPanel.poaPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated);
            this.viewElements.verificationPanel.poiPanel.setEnabled(docOpt.isSelected() && (isAddressOrNameUpdated || nriEnrolment));
            hofOpt.setEnabled(false);
            docOpt.setEnabled(true);
        } else {
            this.viewElements.verificationPanel.poaPanel.setEnabled(false);
            this.viewElements.verificationPanel.poiPanel.setEnabled(false);
            hofOpt.setEnabled(false);
            docOpt.setEnabled(false);
        }
    }

    private void onTabTransition(Object tabIdx) {
        int tabIndex = (Integer)tabIdx;
        if (tabIndex == 1) {
            this.updateReferenceUIState();
        }
    }

    private void populateView() {
        this.populateProofOfBirth();
        this.populateVerificationDetails();
        this.populateRelativeDetails();
    }

    private void onViewLoadComplete(Object o) {
        this.updateTabValidityState(this.enrollmentService.getReferences().isValid());
    }

    private void populateRelativeDetails() {
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        boolean isChild = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild();
        if (!this.enrollmentService.isUniversalClientTrnx() && isChild) {
            this.viewElements.relativeHeaderPanel.relNotGivenOpt.setSelected(false);
            this.viewElements.relativeHeaderPanel.relNotGivenOpt.setEnabled(false);
        }
        if (!this.enrollmentService.isUniversalClientTrnx() && referenceRelative.isMandatory()) {
            RelativePanel relativePanel = this.viewElements.relativePanel;
            relativePanel.relNameField.setText(referenceRelative.getName());
            relativePanel.locRelNameField.setText(referenceRelative.getName());
            referenceRelative.setNameLocal(relativePanel.locRelNameField.getText());
            relativePanel.relTypeField.setSelectedItem(referenceRelative.getDisplayRelationshipType());
            if (referenceRelative.isEnrolmentIdMandatory()) {
                relativePanel.relEnrolIdOpt.setSelected(true);
                relativePanel.relEnrolId1Field.setEnabled(true);
                relativePanel.relEnrolId1Field.setValue(referenceRelative.getDisplayEnrolmentId());
                relativePanel.relEnrolId2Field.setEnabled(true);
                relativePanel.relEnrolId2Field.setValue(referenceRelative.getDisplayEnrolmentDateTime());
            } else if (referenceRelative.isAadhaarNumberMandatory()) {
                relativePanel.relUidOpt.setSelected(true);
                relativePanel.relUidField.setEnabled(true);
                relativePanel.relUidField.setValue(referenceRelative.getDisplayAadhaarNumber());
            }
        }
    }

    private void populateVerificationDetails() {
        ReferenceDocument hofDoc = this.enrollmentService.getReferences().getHofDoc();
        ReferenceDocument porDoc = this.enrollmentService.getReferences().getPor();
        boolean isPoiMandatory = this.enrollmentService.getReferences().getPoi().isMandatory();
        boolean isPoaMandatory = this.enrollmentService.getReferences().getPoa().isMandatory();
        boolean isHofMandatory = hofDoc.isMandatory();
        boolean isPorMandatory = porDoc.isMandatory();
        VerificationPanel verificationPanel = this.viewElements.verificationPanel;
        if (isPoiMandatory || isPoaMandatory) {
            verificationPanel.docOpt.setSelected(true);
            verificationPanel.docOpt.setEnabled(true);
            verificationPanel.poiPanel.setEnabled(isPoiMandatory);
            verificationPanel.poiPanel.poiField.setSelectedItem(this.enrollmentService.getReferences().getPoi().getProof());
            verificationPanel.poaPanel.setEnabled(isPoaMandatory);
            verificationPanel.poaPanel.poaField.setSelectedItem(this.enrollmentService.getReferences().getPoa().getProof());
        } else if (isHofMandatory) {
            verificationPanel.hofOpt.setEnabled(true);
            verificationPanel.hofOpt.setSelected(true);
            verificationPanel.hofPanel.hofDocField.setEnabled(true);
            verificationPanel.hofPanel.hofDocField.setSelectedItem(hofDoc.getProof());
        }
    }

    private void populateProofOfBirth() {
        if (this.enrollmentService.isOnlineUpdate()) {
            this.viewElements.pobPanel.setEnabled(this.enrollmentService.getDemoPersonalDetails().getAgeDob().isVerified());
        } else {
            this.viewElements.pobPanel.pobField.setEnabled(this.enrollmentService.getDemoPersonalDetails().getAgeDob().isVerified());
        }
    }

    private void loadMasterDataList() {
        this.loadDocumentsList();
        this.loadRelationsList();
    }

    private void onRelationshipListRefresh() {
        this.loadRelationsList();
    }

    private void onProofDocumentChange(ItemEvent ie, DocumentType documentType, JComboBox<ProofDocument> field) {
        if (ie.getStateChange() != 1) {
            return;
        }
        ProofDocument proof = (ProofDocument)field.getSelectedItem();
        if (this.enrollmentService.isUpdateEnrollment()) {
            References referenceDetails = this.enrollmentService.getReferences();
            Name name = this.enrollmentService.getDemographics().getPersonalDetail().getName();
            Address address = this.enrollmentService.getDemographics().getContact().getAddress();
            if (name.isUpdated() || address.isUpdated()) {
                if (this.enrollmentService.isHofEnrollment()) {
                    referenceDetails.getPoi().setMandatory(false);
                    referenceDetails.getPoa().setMandatory(false);
                } else {
                    referenceDetails.getPoi().setMandatory(name.isUpdated() || !proof.getDocName().equalsIgnoreCase("Select") && documentType.equals((Object)DocumentType.POI));
                    referenceDetails.getPoa().setMandatory(address.isUpdated() || !proof.getDocName().equalsIgnoreCase("Select") && documentType.equals((Object)DocumentType.POA));
                }
            }
        }
        this.disableScanFor(documentType, !field.isEnabled());
        this.updateReferenceDocument(ie, this.enrollmentService.getReferences().getProof(documentType), field);
        if (this.copyDocumentIfAttached((ProofDocument)ie.getItem(), documentType)) {
            this.disableScanFor(documentType, true);
        }
        this.setStatusIcon(documentType);
    }

    private void onPHOFChange(ItemEvent ie, DocumentType documentType, JComboBox<ProofDocument> field) {
        if (ie.getStateChange() != 1) {
            return;
        }
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isHofEnrollment()) {
            docManager.setCurrentOperatingDocType(DocumentType.POI);
        }
        docManager.setCurrentOperatingDocType(documentType);
        docManager.resetDocument();
        this.updateReferenceDocument(ie, this.enrollmentService.getReferences().getProof(documentType), field);
    }

    private void onPORChange(ItemEvent ie, DocumentType documentType, JComboBox<ProofDocument> field) {
        if (ie.getStateChange() != 1) {
            return;
        }
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        docManager.setCurrentOperatingDocType(documentType);
        docManager.resetDocument();
        this.updateReferenceDocument(ie, this.enrollmentService.getReferences().getProof(documentType), field);
    }

    private void copyDocumentIfSelected(boolean isValid) {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        DocumentType currentDocumentType = docManager.getCurrentOperatingDocType();
        if (currentDocumentType == null) {
            return;
        }
        References references = this.enrollmentService.getReferences();
        ReferenceDocument referenceDoc = references.getProof(currentDocumentType);
        ProofDocument proofAttached = referenceDoc != null ? referenceDoc.getProof() : null;
        this.setStatusIcon(currentDocumentType);
        if (!isValid || StringUtils.isNotBlank((String)docManager.getError(currentDocumentType)) || proofAttached == null || proofAttached.getDocName().equalsIgnoreCase("Select")) {
            return;
        }
        for (DocumentType destDocType : Arrays.asList(DocumentType.POA, DocumentType.POI, DocumentType.POB, DocumentType.HOF, DocumentType.POR)) {
            ProofDocument proof = references.getReferenceDoc(destDocType).getProof();
            if (proof == null || docManager.getDocumentBytes(currentDocumentType) == docManager.getDocumentBytes(destDocType) || destDocType == currentDocumentType || !proof.getDocName().equalsIgnoreCase(proofAttached.getDocName()) || !this.copyDocumentIfAttached(proof, destDocType)) continue;
            this.setStatusIcon(currentDocumentType);
            this.disableScanFor(destDocType, true);
        }
    }

    private void disableScanFor(DocumentType docType, boolean disabled) {
        switch (docType) {
            case POI: {
                this.viewElements.verificationPanel.poiPanel.disableScan(disabled);
                break;
            }
            case POA: {
                this.viewElements.verificationPanel.poaPanel.disableScan(disabled);
                break;
            }
            case POB: {
                this.viewElements.pobPanel.disableScan(disabled);
                break;
            }
            case POR: {
                this.viewElements.verificationPanel.porPanel.disableScan(disabled);
            }
        }
    }

    private boolean copyDocumentIfAttached(ProofDocument proofSelected, DocumentType docType) {
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        docManager.setCurrentOperatingDocType(docType);
        docManager.resetDocument();
        References references = this.enrollmentService.getReferences();
        for (DocumentType documentType : Arrays.asList(DocumentType.POA, DocumentType.POI, DocumentType.POB, DocumentType.POR)) {
            ProofDocument proof = references.getReferenceDoc(documentType).getProof();
            if (proof == null) {
                return false;
            }
            if (proofSelected == null || proofSelected.getDocName().equalsIgnoreCase("Select") || !proofSelected.getDocName().equalsIgnoreCase(proof.getDocName()) || !docManager.isDocumentSaved(documentType) || this.enrollmentService.isUniversalClientTrnx()) continue;
            docManager.copyFrom(documentType);
            this.setStatusIcon(docType);
            return true;
        }
        return false;
    }

    private void setStatusIcon(DocumentType docType) {
        String iconPath = this.enrollmentService.getDocManager().isDocumentSaved(docType) ? OK_ICON_PATH : ERROR_ICON_PATH;
        String tooltip = this.enrollmentService.getDocManager().isDocumentSaved(docType) ? DOC_ATTACH_TIP : DOC_NOT_ATTACH_TIP;
        this.setStatusIcon(docType, iconPath, tooltip);
    }

    private void setStatusIcon(DocumentType docType, String iconPath, String tooltip) {
        JLabel docFieldLbl = null;
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getReferenceDoc(docType);
        referenceDoc.setDocumentAttached();
        switch (docType) {
            case POI: {
                docFieldLbl = this.viewElements.verificationPanel.poiPanel.statusLbl;
                this.updateDocumentFieldState(this.viewElements.verificationPanel.poiPanel.poiField, referenceDoc);
                break;
            }
            case POA: {
                docFieldLbl = this.viewElements.verificationPanel.poaPanel.statusLbl;
                this.updateDocumentFieldState(this.viewElements.verificationPanel.poaPanel.poaField, referenceDoc);
                break;
            }
            case POB: {
                docFieldLbl = this.viewElements.pobPanel.statusLbl;
                this.updateDocumentFieldState(this.viewElements.pobPanel.pobField, referenceDoc);
                break;
            }
            case HOF: {
                docFieldLbl = this.viewElements.verificationPanel.hofPanel.statusLbl;
                this.updateDocumentFieldState(this.viewElements.verificationPanel.hofPanel.hofDocField, referenceDoc);
                break;
            }
            case POR: {
                docFieldLbl = this.viewElements.verificationPanel.porPanel.statusLbl;
                this.updateDocumentFieldState(this.viewElements.verificationPanel.porPanel.porField, referenceDoc);
            }
        }
        if (docFieldLbl != null) {
            docFieldLbl.setIcon(ImageIconCache.getInst().getIcon(iconPath));
            docFieldLbl.setToolTipText(tooltip);
        }
    }

    private void attachDocument(ActionEvent evt, DocumentType docType) {
        String docName = this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocName();
        JButton parent = (JButton)evt.getSource();
        if ("Select".equalsIgnoreCase(docName)) {
            if (this.enrollmentService.isUniversalClientTrnx()) {
                this.showSimpleError(parent, "Document name selection is mandatory to attach the document", new Object[0]);
            } else {
                this.showError(parent, "Document name selection is mandatory to attach the document");
            }
            return;
        }
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        docMan.setCurrentOperatingDocType(docType);
        References referenceDetails = this.enrollmentService.getReferences();
        Name name = this.enrollmentService.getDemographics().getPersonalDetail().getName();
        Address address = this.enrollmentService.getDemographics().getContact().getAddress();
        DocumentsManager docManager = this.enrollmentService.getDocManager();
        if (this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isHofEnrollment()) {
            if (name.isUpdated() && address.isUpdated()) {
                referenceDetails.getPoa().setMandatory(true);
                referenceDetails.getPoi().setMandatory(true);
            } else if (name.isUpdated()) {
                if (docType.equals((Object)DocumentType.POA)) {
                    referenceDetails.getPoa().setMandatory(true);
                }
            } else if (address.isUpdated() && docType.equals((Object)DocumentType.POI)) {
                referenceDetails.getPoi().setMandatory(true);
            }
        }
        try {
            File file = DocumentUtils.getInstance().selectPdfFileFromBrowser(parent);
            if (file != null) {
                docMan.setDocumentBytes(file);
                String error = docMan.getAttachedDoc().getError();
                if (StringUtils.isNotBlank((String)error)) {
                    throw new Exception(error);
                }
                this.showDocAttachPopupInfoMessage(docType);
            }
        }
        catch (Exception e) {
            this.showError(parent, e.getMessage());
            docMan.resetDocument();
            LOGGER.error("Failed to attach document. Exception:", (Throwable)e);
        }
    }

    private void showDocAttachPopupInfoMessage(DocumentType docType) {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Please ensure/confirm that correct document has been <br>");
        message.append("scanned as " + docType + ". Incorrect document upload shall lead to <br>");
        message.append(" imposing of penalty and rejection of request.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar", 1);
    }

    private void scanDocument(ActionEvent evt, DocumentType docType) {
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        docMan.setCurrentOperatingDocType(docType);
        References referenceDetails = this.enrollmentService.getReferences();
        Name name = this.enrollmentService.getDemographics().getPersonalDetail().getName();
        Address address = this.enrollmentService.getDemographics().getContact().getAddress();
        if (this.enrollmentService.isUpdateEnrollment() && !this.enrollmentService.isHofEnrollment()) {
            if (name.isUpdated() && address.isUpdated()) {
                referenceDetails.getPoa().setMandatory(true);
                referenceDetails.getPoi().setMandatory(true);
            } else if (name.isUpdated()) {
                if (docType.equals((Object)DocumentType.POA)) {
                    referenceDetails.getPoa().setMandatory(true);
                }
            } else if (address.isUpdated() && docType.equals((Object)DocumentType.POI)) {
                referenceDetails.getPoi().setMandatory(true);
            }
        }
        try {
            String docName = this.enrollmentService.getReferences().getReferenceDoc(docType).getProof().getDocName();
            ScannerInfo scannerInfo = this.oucDataStore.getScannerInfo();
            String scanner = scannerInfo.getLastScanner();
            if (StringUtils.isBlank((String)scanner) || "select".equalsIgnoreCase(scanner) || "select".equalsIgnoreCase(docName)) {
                this.showError((JButton)evt.getSource(), "Scanner and Document name selection is mandatory to scan the document");
                return;
            }
            long startTime = System.currentTimeMillis();
            this.enrollmentService.getDocManager().setCurrentOperatingDocType(docType);
            BufferedImage bufferedImage = DocumentUtils.getInstance().acquireImage(null, null, this.enrollmentService);
            if (bufferedImage == null) {
                throw new Exception("Failed to capture image");
            }
            this.enrollmentService.getDocManager().addNextDocument(bufferedImage, scannerInfo.getLastMode());
            long responseTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Time taken to scan in ECMP Reference Screen: " + responseTime);
            LOGGER.info("Starting Preview of Scan Document :");
            this.showPreviewListener.actionPerformed(evt);
        }
        catch (Exception e) {
            this.enrollmentService.getDocManager().resetDocument();
            this.showError((JButton)evt.getSource(), (Object)MsgKeysDocuments.SCAN_ERROR);
            LOGGER.error("Error while Scanning document.", (Throwable)e);
        }
    }

    private void updateReferenceDocument(ItemEvent ie, ReferenceDocument doc, JComponent field) {
        ProofDocument item = (ProofDocument)ie.getItem();
        doc.setProofDocument(item);
        this.updateDocumentFieldState(field, doc);
    }

    private void updateDocumentFieldState(JComponent theComp, ReferenceDocument doc) {
        this.clearFieldError(theComp);
        this.showFieldError(theComp, doc.getProofDocumentError());
    }

    private void onVerifyUsingSupportingDocOptSelected(ItemEvent event) {
        boolean poiMandatory = false;
        boolean poaMandatory = false;
        if (event.getStateChange() == 2) {
            DocumentsManager docManager = this.enrollmentService.getDocManager();
            docManager.setCurrentOperatingDocType(DocumentType.POI);
            docManager.resetDocument();
            docManager.setCurrentOperatingDocType(DocumentType.POA);
            docManager.resetDocument();
        } else if (event.getStateChange() == 1 && !this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            poiMandatory = true;
            poaMandatory = true;
        } else if (event.getStateChange() == 1 && this.enrollmentService.isUpdateEnrollment()) {
            poiMandatory = this.enrollmentService.getDemographics().getPersonalDetail().getName().isMandatory() || this.enrollmentService.isNRIEnrolment();
            poaMandatory = this.enrollmentService.getDemographics().getContact().getAddress().isMandatory();
        }
        References referenceDetails = this.enrollmentService.getReferences();
        referenceDetails.getPoi().setMandatory(poiMandatory);
        referenceDetails.getPoa().setMandatory(poaMandatory);
        this.viewElements.verificationPanel.poiPanel.setEnabled(true);
        this.viewElements.verificationPanel.poaPanel.setEnabled(true);
    }

    private void populateMismatchLabel(List<String> labelList, String value) {
        if (value.length() == 0) {
            return;
        }
        labelList.add(value);
    }

    private void onHofVerifyAddressOptSelected(ItemEvent event) {
        boolean mandatory;
        boolean bl = mandatory = event.getStateChange() == 1;
        if (mandatory) {
            this.showHofDocAttachPopupInfoMessage();
            this.enrollmentService.setHofEnrollment(true);
        } else {
            this.enrollmentService.setHofEnrollment(false);
        }
        References references = this.enrollmentService.getReferences();
        this.viewElements.verificationPanel.hofPanel.setEnabled(mandatory);
        References referenceDetails = this.enrollmentService.getReferences();
        referenceDetails.getHofDoc().setMandatory(mandatory);
        this.viewElements.verificationPanel.poiPanel.setEnabled(false);
        this.viewElements.verificationPanel.poaPanel.setEnabled(false);
        references.evaluateDocumentMandatory();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.refreshReferenceRelative();
        } else {
            this.refreshReferenceRelative(mandatory);
        }
    }

    private void showHofDocAttachPopupInfoMessage() {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("For HOF-based transactions,<br> ");
        message.append("Please enter address same as mentioned in HOF's Aadhaar.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Aadhaar", 1);
    }

    private void onAgeChange(AgeDob ageDob) {
        boolean ageChange = ageDob.isVerified();
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.viewElements.pobPanel.setEnabled(ageDob.isUpdated() || ageDob.isDobSelected());
            this.enrollmentService.getReferences().getPob().setMandatory(ageDob.isUpdated() || ageDob.isDobSelected());
            this.enrollmentService.getReferences().getPob().setMandatory(ageDob.isVerified());
            this.refreshReferenceRelative();
        } else {
            this.viewElements.pobPanel.setEnabled(ageDob.isVerified());
            this.enrollmentService.getReferences().getPob().setMandatory(ageDob.isVerified());
            this.refreshReferenceRelative(ageChange);
        }
        this.enrollmentService.getDocManager().setCurrentOperatingDocType(DocumentType.POB);
    }

    private void onDocumentListRefresh() {
        this.loadDocumentsList();
    }

    private void onRelativeDetailsGivenChange(ItemEvent event) {
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        boolean notGiven = event.getStateChange() == 1;
        referenceRelative.setNotGiven(notGiven);
        this.refreshReferenceRelative();
    }

    private void onRelativeEnrolmentIdSelected(ItemEvent event) {
        boolean selected = true;
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        if (event.getStateChange() == 2) {
            referenceRelative.setEnrolmentId("");
            referenceRelative.setEnrolmentDateTime("");
            selected = false;
        }
        referenceRelative.setEnrolmentIdSelected(selected);
        this.updateReferenceRelativeUIState();
    }

    private void onRelativeAadhaarNumberSelected(ItemEvent event) {
        boolean selected = true;
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        if (event.getStateChange() == 2) {
            referenceRelative.setAadhaarNumber("");
            selected = false;
        }
        referenceRelative.setAadhaarNumberSelected(selected);
        this.updateReferenceRelativeUIState();
    }

    private void onRelativeRelationTypeChange(ItemEvent event) {
        JComboBox<RelationshipType> comboBox = this.viewElements.relativePanel.relTypeField;
        if (comboBox.getItemCount() == 1 || event.getStateChange() != 1) {
            return;
        }
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        RelationshipType relationship = (RelationshipType)comboBox.getSelectedItem();
        referenceRelative.setRelationshipType(relationship);
        this.updateReferenceRelativeUIState();
    }

    private void updateRelationshipTypeState() {
        this.clearFieldError(this.viewElements.relativePanel.relTypeField);
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        this.showFieldError(this.viewElements.relativePanel.relTypeField, referenceRelative.getRelationshipTypeError());
    }

    private void relativeNameFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        this.enrollmentService.getReferences().getReferenceRelative().setName(this.viewElements.relativePanel.relNameField.getText());
        this.enrollmentService.getReferences().getReferenceRelative().setNameLocal(this.viewElements.relativePanel.locRelNameField.getText());
        this.updateReferenceRelativeUIState();
    }

    private void updateRelativeNameFieldState() {
        this.clearFieldError(this.viewElements.relativePanel.relNameField);
        this.clearFieldError((JComponent)this.viewElements.relativePanel.locRelNameField);
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        if (!referenceRelative.isValid()) {
            this.showFieldError(this.viewElements.relativePanel.relNameField, referenceRelative.getNameError());
            this.showFieldError((JComponent)this.viewElements.relativePanel.locRelNameField, referenceRelative.getNameLocalError());
        }
    }

    private void relativeNameLocalFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        RelativePanel relativePanel = this.viewElements.relativePanel;
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        referenceRelative.setNameLocal(relativePanel.locRelNameField.getText());
        this.updateReferenceRelativeUIState();
    }

    private void enrolmentIdFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        RelativePanel relativePanel = this.viewElements.relativePanel;
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        String deformattedFieldValue = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.relEnrolId1Field, (String)"00000000000000");
        referenceRelative.setEnrolmentId(deformattedFieldValue);
        this.updateReferenceRelativeUIState();
    }

    private void updateRelativeEnrolmentIdFieldState() {
        this.clearFieldError(this.viewElements.relativePanel.relEnrolId1Field);
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewElements.relativePanel.relEnrolId1Field, referenceRelative.getEnrolmentIdError()));
    }

    private void enrolmentIdDateTimeFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        RelativePanel relativePanel = this.viewElements.relativePanel;
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        String deformattedFieldValue = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)relativePanel.relEnrolId2Field, (String)"00000000000000");
        referenceRelative.setEnrolmentDateTime(deformattedFieldValue);
        this.updateReferenceRelativeUIState();
    }

    private void updateRelativeEnrolmentDateTimeFieldState() {
        this.clearFieldError(this.viewElements.relativePanel.relEnrolId2Field);
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewElements.relativePanel.relEnrolId2Field, referenceRelative.getEnrolmentDateTimeError()));
    }

    private void relativeUidFocusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        String deformattedFieldValue = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.viewElements.relativePanel.relUidField, (String)"000000000000");
        referenceRelative.setAadhaarNumber(deformattedFieldValue);
        this.updateReferenceRelativeUIState();
    }

    private void updateRelativeUidFieldState() {
        this.clearFieldError(this.viewElements.relativePanel.relUidField);
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewElements.relativePanel.relUidField, referenceRelative.getAadhaarNumberError()));
    }

    private void onReferenceRelativeValidityChange(boolean valid) {
        this.updateReferenceUIState();
    }

    @Override
    protected void onPrevButtonClick(ActionEvent event) {
        this.updateReferenceUIState();
        if (!super.showTransliterationDiffWarning(this.viewElements.enrolRbctx.getMessage((Object)LabelAndMsgKeys.MSG_TITLE, new Object[0]), this.viewElements.verificationPanel.hofPanel.hofDocField)) {
            return;
        }
        super.onPrevButtonClick(event);
    }

    @Override
    protected void onNextButtonClick(ActionEvent event) {
        this.updateReferenceUIState();
        if (this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            String rName = this.enrollmentService.getDemographics().getPersonalDetail().getName().english();
            this.showDocUpdatePopMsg(rName);
        }
        if (!super.showTransliterationDiffWarningUC(this.viewElements.enrolRbctx.getMessage((Object)LabelAndMsgKeys.MSG_TITLE, new Object[0]), this.viewElements.verificationPanel.docOpt)) {
            return;
        }
        super.onNextButtonClick(event);
    }

    private void showDocUpdatePopMsg(String rName) {
        StringBuilder message = new StringBuilder("<html><font size=3>");
        message.append("Dear " + rName + ", Please confirm your demographic details in the documents <br>");
        message.append("exactly matches with your demographic details in Aadhaar.");
        message.append("</font></html>").toString();
        JOptionPane.showMessageDialog(null, message, "Document Update Message", -1);
    }

    private void dvsResponse(DocumentsManager docManager, ActionEvent event) {
        if (!docManager.isDvsSuccess()) {
            this.cancelProgressBar(this.veCtxt);
            this.showWarningUC(String.format("Document Validation Service failed to connect", new Object[0]), this.viewElements.verificationPanel.docOpt);
            return;
        }
        LOGGER.info("Doc Validation Successful !!");
        this.enrollmentService.resetRoiEnabled();
        this.renderNextTab();
        super.onNextButtonClick(event);
        if (!docManager.isDocValidationOverride()) {
            this.showQcListener.actionPerformed(event);
        } else {
            LOGGER.info("Demographics details did not match with the details for some documents..., overriding mismatch details");
            this.enrollmentService.resetRoiEnabled();
            this.renderNextTab();
            super.onNextButtonClick(event);
        }
    }

    private void renderNextTab() {
        if (!this.isReviewTabRendered) {
            this.viewElements.reviewTabViewPeer.renderReviewTab();
            this.isReviewTabRendered = true;
        }
    }

    private void showProgressBar(IVisualExecutionContext veCtxt, String s) {
        if (veCtxt != null) {
            veCtxt.reset();
            veCtxt.setMessage(s);
        }
    }

    private void cancelProgressBar(IVisualExecutionContext veCtxt) {
        if (veCtxt != null) {
            veCtxt.cancel();
        }
    }

    private void onResidentialStatusChange(ResidentialStatus residentialStatus) {
        boolean nriEnrolment = residentialStatus.isNRI();
        VerificationPanel verificationPanel = this.viewElements.verificationPanel;
        if (this.enrollmentService.isUpdateEnrollment() || this.enrollmentService.isDocumentUpdate() || this.enrollmentService.isOffLineDocumentUpdate()) {
            verificationPanel.docOpt.setSelected(true);
            this.updateDocumentDropdownState();
            return;
        }
        if (nriEnrolment) {
            verificationPanel.docOpt.setEnabled(true);
            verificationPanel.docOpt.setSelected(true);
            verificationPanel.hofOpt.setSelected(false);
            verificationPanel.hofPanel.setEnabled(false);
        }
        verificationPanel.hofOpt.setEnabled(nriEnrolment);
    }

    private void onNameUpdate(Name name) {
        this.updateDocumentDropdownState();
    }

    private void onAgeDobUpdate(AgeDob ageDob) {
        if (this.enrollmentService.isUniversalClientTrnx()) {
            this.viewElements.pobPanel.setEnabled(ageDob.isUpdated());
        } else {
            this.viewElements.pobPanel.pobField.setEnabled(ageDob.isUpdated());
            if (this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment()) {
                this.viewElements.verificationPanel.hofPanel.setEnabled(ageDob.isUpdated());
                this.viewElements.verificationPanel.hofOpt.setEnabled(ageDob.isUpdated());
            }
        }
    }

    private void onAddressUpdate(Address address) {
        this.updateDocumentDropdownState();
    }

    private void updateDocumentDropdownState() {
        References references = this.enrollmentService.getReferences();
        Name name = this.enrollmentService.getDemographics().getPersonalDetail().getName();
        Address address = this.enrollmentService.getDemographics().getContact().getAddress();
        boolean isAddressOrNameUpdated = address.isUpdated() || name.isUpdated();
        boolean isNriUpdate = this.enrollmentService.isNRIEnrolment();
        VerificationPanel verificationPanel = this.viewElements.verificationPanel;
        JRadioButton hofOpt = verificationPanel.hofOpt;
        JRadioButton docOpt = verificationPanel.docOpt;
        docOpt.setEnabled(references.getPoi().isMandatory() || references.getPoa().isMandatory());
        verificationPanel.poiPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated || isNriUpdate);
        verificationPanel.poaPanel.setEnabled(docOpt.isSelected() && isAddressOrNameUpdated || isNriUpdate);
        if (hofOpt.isSelected() && !references.getHofDoc().isMandatory()) {
            docOpt.setSelected(true);
        }
        if (this.enrollmentService.isAdultEnrollment() && address.isUpdated()) {
            hofOpt.setEnabled(true);
            verificationPanel.hofPanel.hofDocField.setEnabled(true);
        } else if ((this.enrollmentService.isChildEnrollment() || this.enrollmentService.isMinorEnrollment()) && isAddressOrNameUpdated) {
            hofOpt.setEnabled(isAddressOrNameUpdated || references.getHofDoc().isMandatory());
            verificationPanel.hofPanel.hofDocField.setEnabled(hofOpt.isSelected() && references.getHofDoc().isMandatory());
        } else {
            hofOpt.setEnabled(isAddressOrNameUpdated || references.getHofDoc().isMandatory());
            verificationPanel.hofPanel.hofDocField.setEnabled(hofOpt.isSelected() && references.getHofDoc().isMandatory());
        }
    }

    private void refreshReferenceRelative(boolean mandatory) {
        RelativePanel relativePanel = this.viewElements.relativePanel;
        relativePanel.relTypeField.setEnabled(mandatory);
        relativePanel.relNameField.setEnabled(mandatory);
        relativePanel.locRelNameField.setEnabled(mandatory);
        relativePanel.relEnrolIdOpt.setEnabled(false);
        relativePanel.relEnrolIdOpt.setVisible(false);
        relativePanel.relEnrolId1Field.setEnabled(false);
        relativePanel.relEnrolId1Field.setVisible(false);
        relativePanel.relEnrolId2Field.setEnabled(false);
        relativePanel.relEnrolId2Field.setEnabled(false);
        relativePanel.relUidOpt.setEnabled(mandatory);
        relativePanel.relUidField.setEnabled(mandatory);
        if (!mandatory) {
            relativePanel.relTypeField.setSelectedItem(null);
            relativePanel.relNameField.setText("");
            relativePanel.locRelNameField.setText("");
            relativePanel.relEnrolId1Field.setText("");
            relativePanel.relEnrolId2Field.setText("");
            relativePanel.relUidField.setText("");
        }
    }

    private void refreshReferenceRelative() {
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        boolean child = this.enrollmentService.getDemoPersonalDetails().getAgeDob().isChild();
        boolean hofBased = this.enrollmentService.getReferences().getHofDoc().isMandatory();
        boolean provideRelDetails = !referenceRelative.isNotGiven();
        RelativePanel relativePanel = this.viewElements.relativePanel;
        JCheckBox relNotGivenOpt = this.viewElements.relativeHeaderPanel.relNotGivenOpt;
        if (!this.enrollmentService.isUniversalClientTrnx() && (child || hofBased) && relNotGivenOpt.isSelected()) {
            relNotGivenOpt.setSelected(false);
        }
        boolean aadhaarNumberMandatory = referenceRelative.isAadhaarNumberMandatory();
        boolean enrolmentIdMandatory = referenceRelative.isEnrolmentIdMandatory();
        relNotGivenOpt.setEnabled(!child && !hofBased);
        relativePanel.relTypeField.setEnabled(provideRelDetails);
        relativePanel.relTypeField.setSelectedItem(referenceRelative.getRelationshipType());
        relativePanel.relNameField.setEnabled(provideRelDetails);
        relativePanel.relNameField.setText(referenceRelative.getName());
        relativePanel.locRelNameField.setEnabled(provideRelDetails);
        relativePanel.locRelNameField.setText(referenceRelative.getNameLocal());
        relativePanel.relEnrolIdOpt.setEnabled(provideRelDetails);
        relativePanel.relEnrolIdOpt.setSelected(provideRelDetails && (enrolmentIdMandatory || !aadhaarNumberMandatory));
        relativePanel.relEnrolId1Field.setEnabled(provideRelDetails && relativePanel.relEnrolIdOpt.isSelected());
        relativePanel.relEnrolId1Field.setText(referenceRelative.getEnrolmentId());
        relativePanel.relEnrolId2Field.setEnabled(provideRelDetails && relativePanel.relEnrolIdOpt.isSelected());
        relativePanel.relEnrolId2Field.setText(referenceRelative.getEnrolmentDateTime());
        relativePanel.relUidOpt.setEnabled(provideRelDetails);
        relativePanel.relUidOpt.setSelected(provideRelDetails && aadhaarNumberMandatory);
        relativePanel.relUidField.setEnabled(provideRelDetails && relativePanel.relUidOpt.isSelected());
        relativePanel.relUidField.setText(referenceRelative.getAadhaarNumber());
        this.updateReferenceRelativeUIState();
    }

    private void loadDocumentsList() {
        References references = this.enrollmentService.getReferences();
        ReferenceAllowedDocuments allowedDocuments = references.getAllowedDocuments();
        this.addItems(this.viewElements.pobPanel.pobField, allowedDocuments.getPobDocs(), references.getPob().getProof());
        this.addItems(this.viewElements.verificationPanel.poiPanel.poiField, allowedDocuments.getPoiDocs(), references.getPoi().getProof());
        this.addItems(this.viewElements.verificationPanel.poaPanel.poaField, allowedDocuments.getPoaDocs(), references.getPoa().getProof());
        this.addItems(this.viewElements.verificationPanel.hofPanel.hofDocField, allowedDocuments.getHofDocs(), references.getHofDoc().getProof());
        if (this.enrollmentService.isUniversalClientTrnx() && this.enrollmentService.isHofEnrollment()) {
            this.addItems(this.viewElements.verificationPanel.hofPanel.hofDocField, allowedDocuments.getPoiDocs(), references.getPoi().getProof());
            this.addItems(this.viewElements.verificationPanel.porPanel.porField, allowedDocuments.getPorDocs(), references.getPor().getProof());
        }
    }

    private void loadRelationsList() {
        References references = this.enrollmentService.getReferences();
        ReferenceAllowedRelationship allowedRelationship = references.getAllowedRelationship();
        List allowedRelationshipList = allowedRelationship.getAllowedRelationshipList();
        this.addItems(this.viewElements.relativePanel.relTypeField, allowedRelationshipList);
    }

    private void updateReferenceUIState() {
        References references = this.enrollmentService.getReferences();
        this.updateDocumentFieldState(this.viewElements.pobPanel.pobField, references.getPob());
        this.updateDocumentFieldState(this.viewElements.verificationPanel.poiPanel.poiField, references.getPoi());
        this.updateDocumentFieldState(this.viewElements.verificationPanel.poaPanel.poaField, references.getPoa());
        this.updateDocumentFieldState(this.viewElements.verificationPanel.hofPanel.hofDocField, references.getHofDoc());
        this.updateDocumentFieldState(this.viewElements.verificationPanel.porPanel.porField, references.getPor());
        this.updateReferenceRelativeUIState();
    }

    private void updateReferenceRelativeUIState() {
        ReferenceRelative referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        RelativePanel relativePanel = this.viewElements.relativePanel;
        boolean mandatory = referenceRelative.isMandatory();
        relativePanel.manRelType.setVisible(mandatory);
        relativePanel.manLocRelType.setVisible(mandatory);
        relativePanel.manEid.setVisible(referenceRelative.isEnrolmentIdMandatory());
        relativePanel.manUid.setVisible(referenceRelative.isAadhaarNumberMandatory());
        this.updateRelationshipTypeState();
        this.updateRelativeNameFieldState();
        this.updateRelativeEnrolmentIdFieldState();
        this.updateRelativeEnrolmentDateTimeFieldState();
        this.updateRelativeUidFieldState();
    }

    private void addItems(JComboBox<ProofDocument> comboBox, List<ProofDocument> options, ProofDocument defaultSelect) {
        comboBox.removeAllItems();
        options.forEach(comboBox::addItem);
        if (defaultSelect != null) {
            comboBox.setSelectedItem(defaultSelect);
        }
    }

    private void addItems(JComboBox<RelationshipType> comboBox, List<RelationshipType> options) {
        comboBox.removeAllItems();
        options.forEach(comboBox::addItem);
    }
}

