/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references.uploadDoc;

import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.scan.ScanMode;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.protobuf.DocumentMessage;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.document.DocumentsManager;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.references.uploadDoc.DigilockerViewPeer;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigilockerController
extends EnrollmentControllerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigilockerController.class);
    private final DigilockerViewPeer view;
    private final ActionListener showPreviewListener;
    private EnrollmentService enrollmentService;
    IVisualExecutionContext veCtxt;

    public DigilockerController(DigilockerViewPeer viewElements) {
        super(viewElements.getView(), viewElements.enrollmentService, -1, -1);
        this.view = viewElements;
        this.enrollmentService = viewElements.enrollmentService;
        this.showPreviewListener = (ActionListener)this.view.evtCtxt.getEventListener("hID_ShowPreview", ActionListener.class);
        this.veCtxt = new ModalVisualExecutionContext(null, false, new L10nDecorator(this.view.rbCtxt, false));
        this.initView();
    }

    private void initView() {
        this.view.digilockerPanel.button.addActionListener(this::documentFetch);
    }

    private void documentFetch(ActionEvent evt) {
        ((ActionListener)this.view.evtCtxt.getEventListener("closeWin", ActionListener.class)).actionPerformed(evt);
        if (this.enrollmentService.getDocumentFetchType().equalsIgnoreCase("verifiable")) {
            ((ActionListener)this.view.evtCtxt.getEventListener("hID_ShowPreview", ActionListener.class)).actionPerformed(evt);
            return;
        }
        if (!this.enrollmentService.getDocumentFetchType().equalsIgnoreCase("digilocker")) {
            this.view.evtCtxt.fireGenericEvent(this.enrollmentService.getDocumentFetchType(), new Object[]{null, evt});
            return;
        }
        Utils.showProgressBar(this.veCtxt, "Fetching document from digilocker ...");
        ThreadPool.commonPool().submit(() -> {
            DocumentMessage.DocumentFetchAndUploadRequest documentFetchAndUploadRequest = this.prepareDigilockerFetchAndUploadRequest();
            GrpcService.getInst().fetchAndUploadRegistry(documentFetchAndUploadRequest, documentFetchAndUploadResponse -> {
                try {
                    DocumentMessage.DocumentFetchResponse documentFetchResponse = documentFetchAndUploadResponse.getDocumentFetchResponse();
                    String documentUploadStatus = documentFetchAndUploadResponse.getDocumentUploadResponse().getStatus();
                    LOGGER.info("Document upload status is : {}", (Object)documentUploadStatus);
                    DocumentsManager docMan = this.enrollmentService.getDocManager();
                    docMan.resetDocument();
                    if (documentFetchResponse.getStatus().equals("200 OK")) {
                        this.showDocumentPreviewPanel(documentFetchResponse, this.veCtxt, evt);
                    }
                    if (documentUploadStatus.equals("SUCCESS")) {
                        docMan.setDocumentUploadSuccess(docMan.getCurrentDocumentTypeForUploadOrVerify());
                    } else {
                        docMan.setDocumentUploadSuccessFalseForDigilocker(docMan.getCurrentDocumentTypeForUploadOrVerify());
                    }
                    TelemetryService.getTelemetryServiceInstance().postDebugData("Successfully fetched digilocker document :: " + this.enrollmentService.getValuesDocumentModel().getDigilockerDocument().getDocumentName(), new String[0]);
                }
                catch (Exception e) {
                    Utils.cancelProgressBar(this.veCtxt);
                    LOGGER.error("Error While Fetching Document from Digilocker", (Throwable)e);
                    L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Unable to display the document. Try with manually scanning the document.", (Component)this.view.digilockerPanel.centerPanel, new Object[0]);
                    TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_159.getErrorCode(), new String[0]);
                }
                catch (OutOfMemoryError e) {
                    Utils.cancelProgressBar(this.veCtxt);
                    LOGGER.error("System error - out of memory", (Throwable)e);
                    L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Unable to display the document (System error - out of memory). Try with manually scanning the document.", (Component)this.view.digilockerPanel.centerPanel, new Object[0]);
                    TelemetryService.getTelemetryServiceInstance().postLogData(new Exception("out of memory"), ErrorCodes.UC_GEN_159.getErrorCode(), new String[0]);
                }
                finally {
                    Utils.cancelProgressBar(this.veCtxt);
                }
            }, throwable -> {
                Utils.cancelProgressBar(this.veCtxt);
                LOGGER.error("Error While Fetching Document from Digilocker", throwable);
                L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(throwable.getErrorDetail()) + ". Try with manually scanning the document.", (Component)this.view.digilockerPanel.centerPanel, throwable.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
                TelemetryService.getTelemetryServiceInstance().postLogData(new Exception(CommonUtilsUC.getErrorMessage(throwable.getErrorDetail())), throwable.getErrorCode(), new String[0]);
            });
        });
    }

    private void showDocumentPreviewPanel(DocumentMessage.DocumentFetchResponse documentFetchResponse, IVisualExecutionContext veCtxt, ActionEvent evt) throws IOException {
        DocumentsManager docMan = this.enrollmentService.getDocManager();
        documentFetchResponse.getDocsList().forEach(document -> {
            if (document.getFormat().equalsIgnoreCase("pdf")) {
                try {
                    File file = new File("tmp.pdf");
                    FileOutputStream fileInputStream = new FileOutputStream(file);
                    fileInputStream.write(Base64.getDecoder().decode(document.getData()));
                    fileInputStream.close();
                    docMan.setDocumentBytes(file);
                    file.deleteOnExit();
                }
                catch (Exception e) {
                    Utils.cancelProgressBar(veCtxt);
                    LOGGER.error("Error While Fetching Document from Digilocker", (Throwable)e);
                    L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)"Unable to display the document", (Component)this.view.digilockerPanel.centerPanel, new Object[0]);
                    TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_159.getErrorCode(), new String[0]);
                }
            } else {
                this.enrollmentService.getXmlData().put(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify(), document.getData());
            }
        });
        List bufferedImage = this.enrollmentService.getDocManager().getAttachedDoc().getListBufferedImage();
        bufferedImage.forEach(image -> this.enrollmentService.getDocManager().addNextDocument(image, ScanMode.COLOR.name()));
        if (!this.populateRoi(this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify())) {
            return;
        }
        this.showPreviewListener.actionPerformed(evt);
    }

    private DocumentMessage.DocumentFetchAndUploadRequest prepareDigilockerFetchAndUploadRequest() {
        DocumentMessage.DocumentFetchAndUploadRequest.Builder fetchAndUploadRequest = DocumentMessage.DocumentFetchAndUploadRequest.newBuilder();
        try {
            PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
            String nationalityType = this.enrollmentService.getDemoResidentialStatus().getForeignTypeEnum();
            DocumentType documentType = this.enrollmentService.getDocManager().getCurrentDocumentTypeForUploadOrVerify();
            String documentNumber = "";
            if (documentType.equals((Object)DocumentType.POI)) {
                documentNumber = this.enrollmentService.getDemoPersonalDetails().getForeignDetail().getDocNo();
            } else if (documentType.equals((Object)DocumentType.POF)) {
                documentNumber = this.enrollmentService.getDemoPersonalDetails().getForeignDetail().getVisaNo();
            }
            ArrayList<String> formats = new ArrayList<String>();
            formats.add("pdf");
            formats.add("xml");
            String mobileNo = Strings.isNullOrEmpty((String)this.enrollmentService.getDemoContactDetails().getMobile().getNumberForDisplay()) ? "9876543210" : this.enrollmentService.getDemoContactDetails().getMobile().getNumberForDisplay();
            String emailId = Strings.isNullOrEmpty((String)this.enrollmentService.getDemoContactDetails().getEmail().getEmailForDisplay()) ? "notPresent@email.com" : this.enrollmentService.getDemoContactDetails().getEmail().getEmailForDisplay();
            DocumentMessage.DocumentFetchRequest fetchRequest = DocumentMessage.DocumentFetchRequest.newBuilder().setSrn(this.enrollmentService.getSid()).setUid(Strings.isNullOrEmpty((String)this.enrollmentService.getResidentUid()) ? "123123123123" : this.enrollmentService.getResidentUid()).setName(personalDetail.getName().getNewNameForDisplay().isEmpty() ? personalDetail.getName().english() : personalDetail.getName().getNewNameForDisplay()).setGender(personalDetail.getApplicantGender().getGender().toString()).setDob(personalDetail.getAgeDob().getAgeDobFormattedUC()).setAge(personalDetail.getAgeDob().getAge().intValue()).setDocumentCode(this.enrollmentService.getValuesDocumentModel().getDigilockerDocument().getDocumentCode()).setInformationSharingConsent(true).setMobile(mobileNo).setEmail(emailId).addAllFormats(formats).putAllFormFields(this.enrollmentService.getValuesDocumentModel().getFormFieldsValues()).build();
            DocumentMessage.DocumentUploadData uploadData = DocumentMessage.DocumentUploadData.newBuilder().setSid(this.enrollmentService.getSid()).setRefId(this.enrollmentService.getRefId()).setDocumentFormatType(DocumentMessage.DocumentFormatType.PDF).setDocType(this.getDISDocumentType(documentType)).setDocNationalityType(this.getDISNationalityType(nationalityType)).setDocumentNumber(documentNumber).build();
            fetchAndUploadRequest.setDocumentFetchRequest(fetchRequest).setDocumentUploadData(uploadData);
        }
        catch (Exception e) {
            Utils.cancelProgressBar(this.veCtxt);
            LOGGER.error("Error in creating request for digilocker fetch", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_159.getErrorCode(), new String[0]);
            L10nOptionPaneBuilder.getInstance().showSimpleErrorUC((Object)ErrorCodes.UC_GEN_159.getReason(), (Component)this.view.getContentPane(), new Object[]{ErrorCodes.UC_GEN_159.getErrorCode(), "Please try again..."});
        }
        return fetchAndUploadRequest.build();
    }

    private DocumentMessage.DocNationalityType getDISNationalityType(String nationalityType) {
        try {
            return DocumentMessage.DocNationalityType.valueOf((String)nationalityType);
        }
        catch (IllegalArgumentException e) {
            return DocumentMessage.DocNationalityType.OTHER;
        }
    }

    private DocumentMessage.DocType getDISDocumentType(DocumentType documentType) {
        try {
            return DocumentMessage.DocType.valueOf((String)documentType.name());
        }
        catch (IllegalArgumentException e) {
            return DocumentMessage.DocType.UNRECOGNIZED;
        }
    }

    private DocumentMessage.DocumentFetchRequest prepareDigilockerRequest2() {
        PersonalDetail personalDetail = this.enrollmentService.getDemographics().getPersonalDetail();
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("pdf");
        formats.add("xml");
        DocumentMessage.DocumentFetchRequest fetchRequest = DocumentMessage.DocumentFetchRequest.newBuilder().setSrn(this.enrollmentService.getSid()).setUid("123456789321").setName(personalDetail.getName().getNewNameForDisplay().isEmpty() ? personalDetail.getName().english() : personalDetail.getName().getNewNameForDisplay()).setGender(personalDetail.getApplicantGender().getGender().toString()).setDob(personalDetail.getAgeDob().getAgeDobFormattedUC()).setAge(personalDetail.getAgeDob().getAge().intValue()).setDocumentCode(this.enrollmentService.getValuesDocumentModel().getDigilockerDocument().getDocumentCode()).setInformationSharingConsent(true).setMobile("9876543210").setEmail("email@email.com").addAllFormats(formats).putAllFormFields(this.enrollmentService.getValuesDocumentModel().getFormFieldsValues()).build();
        return fetchRequest;
    }

    private boolean populateRoi(DocumentType docType) {
        TransparentBox axnPanel = new TransparentBox((LayoutManager)new FlowLayout(0, 0, 2));
        ReferenceDocument referenceDoc = this.enrollmentService.getReferences().getProof(docType);
        if (referenceDoc != null) {
            Document proofDetails = this.enrollmentService.getOnlineDocumentService().getDocument(docType, referenceDoc.getProof().getDocName());
            try {
                this.enrollmentService.fetchRegionsOfInterest(proofDetails.getDocType(), proofDetails.getDocumentId());
                return true;
            }
            catch (OnlineGatewayException e) {
                L10nOptionPaneBuilder.getInstance().showErrorUC("Failed to fetch Rois", (Component)axnPanel, e.getErrorCode(), this.enrollmentService.getOauthGwApiService().getTransactionId(), new Object[0]);
            }
        }
        return false;
    }
}

