/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.references.uploadDoc;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.protobuf.DocumentMessage;
import in.gov.uidai.ec.service.document.digilocker.DigilockerDocument;
import in.gov.uidai.ec.service.document.digilocker.ValuesDocumentModel;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.ui.enrol.references.uploadDoc.DigilockerController;
import in.gov.uidai.ec.ui.enrol.references.uploadDoc.DigilockerPanel;
import in.gov.uidai.litef.beans.stdview.StandardViewPeer;
import in.gov.uidai.swing.notify.NotificationLocation;
import in.gov.uidai.swing.notify.NotificationOverlay;
import in.gov.uidai.swing.notify.NotificationPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DigilockerViewPeer
extends StandardViewPeer {
    protected IResourceBundleContext rbCtxt;
    protected EnrollmentService enrollmentService;
    protected DigilockerPanel digilockerPanel;

    protected void prepareImpl() {
        ValuesDocumentModel valuesDocumentModel = this.enrollmentService.getValuesDocumentModel();
        this.setTitle(valuesDocumentModel.isDigilockerDocument() ? "Get document from digilocker" : "Verify the document");
        this.digilockerPanel = new DigilockerPanel(valuesDocumentModel.isDigilockerDocument() ? "GET DOCUMENT" : "VERIFY DOCUMENT");
        this.digilockerPanel.title.setText(valuesDocumentModel.getTitle());
        this.digilockerPanel.vBox.removeAll();
        if (valuesDocumentModel.isDigilockerDocument()) {
            DigilockerDocument digilockerDocument = valuesDocumentModel.getDigilockerDocument();
            if (digilockerDocument.getIssuerType().equals("CENTRAL")) {
                this.setupFormFields(digilockerDocument.getFormfields());
            } else if (digilockerDocument.getIssuerType().equals("STATE")) {
                this.setupSourceFormfields(digilockerDocument.getStateFormField());
            }
        } else {
            this.setupFormFields(valuesDocumentModel.getVerifiableDocument().getFormfields());
        }
        this.digilockerPanel.vBox.revalidate();
        this.digilockerPanel.vBox.repaint();
        new DigilockerController(this);
        this.setContentPane(this.digilockerPanel.mainPanel);
    }

    private void setupFormFields(List<DocumentMessage.FormField> formFields) {
        formFields.forEach(formField -> {
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new AbsoluteLayout());
            JLabel heading = new JLabel(formField.getDisplayName());
            panel.add((Component)heading, new AbsoluteConstraints(0, 0, 430, 40));
            panel.add((Component)this.newTextField(formField.getKey()), new AbsoluteConstraints(0, 30, 430, 40));
            this.digilockerPanel.vBox.add(panel);
            this.digilockerPanel.vBox.add(new JLabel(""));
        });
    }

    private void setupSourceFormfields(List<DocumentMessage.SourceFormFields> stateFormFields) {
        JComboBox<String> stateList = new JComboBox<String>();
        stateList.addItem("Select");
        stateFormFields.stream().filter(stateFormField -> !stateFormField.getFormFieldsList().isEmpty()).forEach(stateFormField -> stateList.addItem(stateFormField.getSource()));
        stateList.setPreferredSize(new Dimension(430, 40));
        stateList.setMaximumSize(new Dimension(430, 40));
        stateList.setMinimumSize(new Dimension(430, 40));
        this.digilockerPanel.vBox.add(stateList);
        stateList.addItemListener(evt -> this.stateSelected(evt, stateList, stateFormFields));
    }

    private JTextField newTextField(String key) {
        JTextField input = new JTextField();
        input.setPreferredSize(new Dimension(430, 40));
        this.applyILV(input, key);
        input.setName(key);
        input.addActionListener(e -> this.digilockerPanel.mainPanel.requestFocusInWindow());
        return input;
    }

    public void applyILV(final JTextField field, final String key) {
        final ValuesDocumentModel valuesDocumentModel = this.enrollmentService.getValuesDocumentModel();
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String message = valuesDocumentModel.validate(field.getText(), key);
                if (message != null) {
                    DigilockerViewPeer.this.fieldError(field, message);
                    DigilockerViewPeer.this.digilockerPanel.button.setEnabled(false);
                } else {
                    DigilockerViewPeer.this.clearFieldError(field);
                }
                if (valuesDocumentModel.isAllFieldsValid()) {
                    DigilockerViewPeer.this.digilockerPanel.button.setEnabled(true);
                }
            }
        });
    }

    private void fieldError(JTextField textField, String message) {
        NotificationOverlay.setError((JComponent)textField);
        NotificationPopup toolTip = NotificationPopup.getToolTip((JComponent)textField);
        toolTip.setToolTipText(message, false);
        toolTip.setLocation(NotificationLocation.BOTTOM);
        textField.repaint();
    }

    private void clearFieldError(JTextField textField) {
        NotificationOverlay.clear((JComponent)textField);
        NotificationPopup.getToolTip((JComponent)textField).setToolTipText(null, false);
        textField.repaint();
    }

    private void stateSelected(ItemEvent ie, JComboBox states, List<DocumentMessage.SourceFormFields> stateFormFields) {
        this.digilockerPanel.vBox.removeAll();
        states.setPreferredSize(new Dimension(430, 40));
        states.setMaximumSize(new Dimension(430, 40));
        states.setMinimumSize(new Dimension(430, 40));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new AbsoluteLayout());
        panel1.add((Component)states, new AbsoluteConstraints(0, 0, 430, 40));
        this.digilockerPanel.vBox.add(panel1);
        ValuesDocumentModel valuesDocumentModel = this.enrollmentService.getValuesDocumentModel();
        if (!states.getSelectedItem().equals("Select")) {
            String currentState = (String)states.getSelectedItem();
            valuesDocumentModel.setSelectedState(currentState, stateFormFields);
            stateFormFields.stream().filter(stateFormField -> stateFormField.getSource().equalsIgnoreCase(currentState)).flatMap(stateFormField -> stateFormField.getFormFieldsList().stream()).forEach(formField -> {
                JPanel panel = new JPanel();
                panel.setLayout((LayoutManager)new AbsoluteLayout());
                JLabel status = new JLabel("Invalid");
                status.setForeground(Color.RED);
                JLabel heading = new JLabel(formField.getDisplayName());
                panel.add((Component)heading, new AbsoluteConstraints(0, 0, 430, 40));
                panel.add((Component)this.newTextField(formField.getKey()), new AbsoluteConstraints(0, 30, 440, 40));
                panel.add((Component)status, new AbsoluteConstraints(390, 6, -1, -1));
                status.setFont(new Font("Segoe UI", 2, 12));
                this.digilockerPanel.vBox.add(panel);
                this.digilockerPanel.vBox.add(new JLabel(""));
            });
        }
        this.digilockerPanel.vBox.revalidate();
        this.digilockerPanel.vBox.repaint();
        SwingUtilities.getWindowAncestor(this.digilockerPanel.mainPanel).pack();
    }

    protected void enableImpl(boolean flag) {
    }

    protected void disposeImpl() {
    }

    public void setResourceBundleContext(IResourceBundleContext ctxt) {
        this.rbCtxt = ctxt;
    }

    public void setEnrollmentService(EnrollmentService enrollmentService) {
        this.enrollmentService = enrollmentService;
    }
}

