/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.resident;

import com.google.common.base.Strings;
import in.gov.uidai.ec.icas.util.Verhoeff;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.MsgKeysILV;
import in.gov.uidai.ec.service.enrollment.util.EnrolHelper;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.resident.ResidentUidViewPeer;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class ResidentUidPopupController
extends ControllerBase {
    private ResidentUidViewPeer viewPeer;
    private String aadhaarNumberError;
    private String hofAadhaarNumberError;
    private EnrollmentService enrollmentService;

    public ResidentUidPopupController(ResidentUidViewPeer viewPeer) {
        super(viewPeer.getView());
        this.viewPeer = viewPeer;
        this.enrollmentService = viewPeer.enrollmentService;
        this.initView();
    }

    private void initView() {
        super.addFocusListener(this.viewPeer.aadhaarNoField, this::getResidentUid);
        super.addFocusListener(this.viewPeer.hofAadhaarNoField, this::getResidentUid);
        if (!this.enrollmentService.isEnrolmentStateNull() && this.enrollmentService.isUniversalClientTrnx()) {
            this.viewPeer.okButton.addActionListener(e -> {
                if (Strings.isNullOrEmpty((String)this.aadhaarNumberError) && Strings.isNullOrEmpty((String)this.hofAadhaarNumberError)) {
                    ((ActionListener)this.viewPeer.getEvtCtxt().getEventListener("initiate update", ActionListener.class)).actionPerformed(e);
                }
            });
        } else {
            this.viewPeer.okButton.addActionListener((ActionListener)this.viewPeer.getEvtCtxt().getEventListener("residentUidPopupButton", ActionListener.class));
        }
    }

    private void getResidentUid(FocusEvent focusEvent) {
        String uid = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.viewPeer.aadhaarNoField, (String)"000000000000");
        if (!this.validateAadhaarNumber(uid)) {
            this.aadhaarNumberError = "Enter valid Aadhaar Number";
            this.updateAadhaarFieldState();
            this.viewPeer.isValidUid.setText("Invalid");
        } else {
            this.aadhaarNumberError = null;
            this.viewPeer.isValidUid.setText("Valid");
        }
        if (this.enrollmentService.isUniversalClientTrnx()) {
            String hofUid = EnrolHelper.getDeformattedFieldValue((JFormattedTextField)this.viewPeer.hofAadhaarNoField, (String)"000000000000");
            if (!Strings.isNullOrEmpty((String)hofUid) && !this.validateAadhaarNumber(hofUid)) {
                this.hofAadhaarNumberError = "Enter valid Aadhaar Number";
                this.updateHofAadhaarFieldState();
            } else {
                this.hofAadhaarNumberError = null;
            }
        }
    }

    private boolean validateAadhaarNumber(String aadhaarNumber) {
        MsgKeysILV aadhaarErrorMsgKey = null;
        if (StringUtils.isBlank((String)aadhaarNumber)) {
            aadhaarErrorMsgKey = MsgKeysILV.MANDATORY;
        } else if (aadhaarNumber.startsWith("0") || aadhaarNumber.startsWith("1")) {
            aadhaarErrorMsgKey = MsgKeysILV.ZERO;
        } else if (!Verhoeff.validate((String)aadhaarNumber)) {
            aadhaarErrorMsgKey = MsgKeysILV.UID;
        }
        return aadhaarErrorMsgKey == null;
    }

    private void updateAadhaarFieldState() {
        this.clearFieldError(this.viewPeer.aadhaarNoField);
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewPeer.aadhaarNoField, this.aadhaarNumberError));
    }

    private void updateHofAadhaarFieldState() {
        this.clearFieldError(this.viewPeer.hofAadhaarNoField);
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewPeer.hofAadhaarNoField, this.hofAadhaarNumberError));
    }
}

