/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.review;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.FixedWidthTwoColTile;
import in.gov.uidai.ec.swing.shared.SectionHeader;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.TransparentBox;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.painter.IPaintDelegate;
import in.gov.uidai.swing.painter.LinearGradientBackground;
import in.gov.uidai.swing.table.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

class ReviewBiometricsPanel
implements IViewElementComposite {
    private static final String KEY_BIO_TOGGLE_UP_ICON = "KEY_BIO_TOGGLE_UP_ICON";
    private static final String KEY_BIO_TOGGLE_DOWN_ICON = "KEY_BIO_TOGGLE_DOWN_ICON";
    private final IResourceBundleContext rbCtxt;
    private final IUIPreference uiPref;
    protected CaptureThumbnail bioxPhoto;
    protected JTextArea bioxDetails;
    protected CaptureThumbnail leftSlap;
    protected CaptureThumbnail rightSlap;
    protected CaptureThumbnail bothThumbs;
    protected CaptureThumbnail leftIris;
    protected CaptureThumbnail rightIris;
    protected CaptureThumbnail resConfirm;
    protected JLabel resConfirmType;
    private TransparentBox bioExceptionPanel;
    private TransparentBox residentConfirmPanel;
    private TransparentBox bioSummaryPanel;
    private SectionHeader bioSummaryHeader;

    ReviewBiometricsPanel(IResourceBundleContext rbCtxt, IUIPreference uiPref) {
        this.rbCtxt = rbCtxt;
        this.uiPref = uiPref;
    }

    JComponent createBioxPanel(boolean isUpdateEnrolment) {
        this.bioxPhoto = ViewUtils.createThumbnail();
        this.bioExceptionPanel = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.bioExceptionPanel.setPreferredSize(new Dimension(250, 300));
        this.bioxDetails = new JTextArea("Biometric Exception: None");
        this.bioxDetails.setWrapStyleWord(true);
        this.bioxDetails.setLineWrap(true);
        this.bioxDetails.setEditable(false);
        this.bioxDetails.setFocusable(false);
        this.bioxDetails.setPreferredSize(new Dimension(250, 55));
        this.bioExceptionPanel.add((Component)new JLabel("Exception Photograph"), (Object)"North");
        this.applyLinerGradientBackground(this.bioExceptionPanel, this.bioxPhoto, this.bioxDetails);
        this.bioExceptionPanel.setVisible(!isUpdateEnrolment);
        return this.bioExceptionPanel;
    }

    JComponent createBioSummaryPanel() {
        this.leftSlap = ViewUtils.createThumbnail();
        this.rightSlap = ViewUtils.createThumbnail();
        this.bothThumbs = ViewUtils.createThumbnail();
        this.leftIris = ViewUtils.createThumbnail();
        this.rightIris = ViewUtils.createThumbnail();
        double[][] guides = new double[][]{{-1.0, 130.0, 3.0, 130.0, 3.0, 130.0, 12.0, 130.0, 3.0, 130.0, -1.0}, {22.0, 130.0, -1.0}};
        this.bioSummaryPanel = new TransparentBox((LayoutManager)new TableLayout((double[][])guides));
        RoundedBorder innerBorder = new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(7, 7);
        Font titleFont = new JLabel().getFont().deriveFont(1, 12.0f);
        TitledBorder bioBorder = new TitledBorder((Border)innerBorder, " Resident's Biometrics ", 0, 2, titleFont);
        this.bioSummaryPanel.setBorder((Border)bioBorder);
        this.bioSummaryPanel.add((Component)new JLabel("Fingerprints"), (Object)"1, 0, 5, 0, center, full");
        this.bioSummaryPanel.add((Component)new JLabel("Iris"), (Object)"7, 0, 9, 0, center, full");
        this.bioSummaryPanel.add((Component)this.leftSlap, (Object)"1, 1, full, full");
        this.bioSummaryPanel.add((Component)this.rightSlap, (Object)"3, 1, full, full");
        this.bioSummaryPanel.add((Component)this.bothThumbs, (Object)"5, 1, full, full");
        this.bioSummaryPanel.add((Component)this.leftIris, (Object)"9, 1, full, full");
        this.bioSummaryPanel.add((Component)this.rightIris, (Object)"7, 1, full, full");
        this.bioSummaryPanel.setVisible(false);
        JButton bioViewButton = new JButton(ImageIconCache.getInst().getIcon(KEY_BIO_TOGGLE_UP_ICON));
        bioViewButton.setCursor(new Cursor(12));
        bioViewButton.setBorder(null);
        bioViewButton.setBorderPainted(false);
        bioViewButton.setContentAreaFilled(false);
        FixedWidthTwoColTile bioTile = new FixedWidthTwoColTile();
        bioTile.setWidth(700);
        bioTile.prepare();
        bioViewButton.addActionListener(e -> {
            if (this.bioSummaryPanel.isVisible()) {
                bioViewButton.setIcon(ImageIconCache.getInst().getIcon(KEY_BIO_TOGGLE_UP_ICON));
                this.bioSummaryPanel.setVisible(false);
            } else {
                bioViewButton.setIcon(ImageIconCache.getInst().getIcon(KEY_BIO_TOGGLE_DOWN_ICON));
                this.bioSummaryPanel.setVisible(true);
            }
        });
        L10nDecorator ldeco = new L10nDecorator(this.rbCtxt, this.uiPref.getApplicationLocalize(false));
        this.bioSummaryHeader = new SectionHeader(ldeco, this.rbCtxt);
        this.bioSummaryHeader.setText(LabelKeysHeader.BIOMETRICS.toString());
        this.bioSummaryHeader.add(bioViewButton);
        bioTile.addCenterComponent(this.bioSummaryHeader);
        bioTile.addCenterComponent((Component)this.bioSummaryPanel);
        return bioTile.toSwing();
    }

    JComponent createResConfirmPanel() {
        this.resConfirm = ViewUtils.createThumbnail();
        this.resConfirmType = new JLabel("Not Specified");
        this.resConfirmType.setVerticalAlignment(1);
        this.residentConfirmPanel = new TransparentBox((LayoutManager)new BorderLayout(5, 5));
        this.residentConfirmPanel.setPreferredSize(new Dimension(250, 250));
        this.residentConfirmPanel.add((Component)new JLabel("Resident Confirmation"), (Object)"North");
        this.applyLinerGradientBackground(this.residentConfirmPanel, this.resConfirm, this.resConfirmType);
        return this.residentConfirmPanel;
    }

    void setBioSummaryPanelVisible(boolean visible) {
        this.bioSummaryPanel.setVisible(visible);
        this.bioSummaryHeader.setVisible(visible);
    }

    void setBiometricExceptionPanelVisible(boolean visible) {
        this.bioExceptionPanel.setVisible(visible);
    }

    void setResidentConfirmationPanelVisible(boolean visible) {
        this.residentConfirmPanel.setVisible(visible);
    }

    private void applyLinerGradientBackground(TransparentBox bioxPanel, CaptureThumbnail bioxPhoto, Component component) {
        bioxPanel.add((Component)bioxPhoto, (Object)"Center");
        bioxPanel.add(component, (Object)"South");
        bioxPanel.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        LinearGradientBackground background = new LinearGradientBackground().borderSize(1.0f).direction(1).gradientColors("#ffffff, #ffffff").gradientStops("0, 1").roundingSize(7, 7);
        bioxPanel.setBackground((IPaintDelegate)background);
    }

    static {
        ImageIconCache.getInst().addIcon(KEY_BIO_TOGGLE_UP_ICON, "res/images/review-bio-details-hide.png");
        ImageIconCache.getInst().addIcon(KEY_BIO_TOGGLE_DOWN_ICON, "res/images/review-bio-details-show.png");
    }
}

