/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.review;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.CaptureModality;
import in.gov.uidai.ec.service.enrollment.UpdateType;
import in.gov.uidai.ec.service.enrollment.model.AadhaarNo;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.AgeDob;
import in.gov.uidai.ec.service.enrollment.model.ApplicantGender;
import in.gov.uidai.ec.service.enrollment.model.Biometrics;
import in.gov.uidai.ec.service.enrollment.model.BiometricsException;
import in.gov.uidai.ec.service.enrollment.model.BiometricsExceptionDetail;
import in.gov.uidai.ec.service.enrollment.model.CaptureAttempt;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Gender;
import in.gov.uidai.ec.service.enrollment.model.Iris;
import in.gov.uidai.ec.service.enrollment.model.Name;
import in.gov.uidai.ec.service.enrollment.model.ReferenceDocument;
import in.gov.uidai.ec.service.enrollment.model.ReferenceRelative;
import in.gov.uidai.ec.service.enrollment.model.References;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.enrollment.model.ResidentConfirmation;
import in.gov.uidai.ec.service.enrollment.model.ResidentialStatus;
import in.gov.uidai.ec.ui.enrol.EnrollmentControllerBase;
import in.gov.uidai.ec.ui.enrol.review.ReviewBiometricsPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewTabViewPeer;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.swing.ImageIconCache;
import in.gov.uidai.swing.bio.thumb.CaptureThumbnail;
import in.gov.uidai.swing.bio.thumb.ThumbOverlay;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

class ReviewController
extends EnrollmentControllerBase {
    private static final String ICON_REVIEW_MANDATORY = "mandatory_image";
    private static final String ICON_REVIEW_NOT_APPLICABLE = "not_applicable";
    private final ReviewTabViewPeer viewElements;
    private final IResourceBundleContext rbCtx;
    private boolean isoperatorConfirmed;

    ReviewController(ReviewTabViewPeer viewElements, int tabIndex) {
        super(viewElements.view, viewElements.enrollmentService, 5, tabIndex);
        this.viewElements = viewElements;
        this.rbCtx = viewElements.rbCtx;
        this.initView();
        this.loadPage();
    }

    private void initView() {
        this.enrollmentService.getDemographics().getResidentialStatus().addChangeListener(this::onResidentalStatusChange);
        this.enrollmentService.getDemographics().getPersonalDetail().getName().addChangeListener(this::onNameChange);
        this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender().addChangeListener(this::onGenderChange);
        this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().addChangeListener(this::onAgeDobChange);
        this.enrollmentService.getDemographics().getContact().addChangeListener(this::onContactChange);
        this.enrollmentService.getReferences().getReferenceRelative().addChangeListener(this::onRelativeChange);
        this.enrollmentService.getDemographics().addValidityChangeListener(this::onValidityChange);
        this.enrollmentService.getReferences().getPob().addChangeListener(this::onDocumentChange);
        this.enrollmentService.getReferences().getPoi().addChangeListener(this::onDocumentChange);
        this.enrollmentService.getReferences().getPoa().addChangeListener(this::onDocumentChange);
        if (this.enrollmentService.isHofEnrollment()) {
            this.enrollmentService.getReferences().getPor().addChangeListener(this::onDocumentChange);
        }
        this.enrollmentService.getReferences().getHofDoc().addChangeListener(this::onDocumentChange);
        this.enrollmentService.getReferences().addValidityChangeListener(this::onValidityChange);
        this.enrollmentService.getPhotograph().getPhoto().addChangeListener(b -> this.onBiometricChange((Biometrics)b, false));
        this.enrollmentService.getPhotograph().getExceptionPhoto().addChangeListener(b -> this.onBiometricChange((Biometrics)b, false));
        this.enrollmentService.getFingerPrint().getLeftSlap().addChangeListener(b -> this.onBiometricChange((Biometrics)b, false));
        this.enrollmentService.getFingerPrint().getRightSlap().addChangeListener(b -> this.onBiometricChange((Biometrics)b, false));
        this.enrollmentService.getFingerPrint().getBothThumbs().addChangeListener(b -> this.onBiometricChange((Biometrics)b, false));
        this.enrollmentService.getIris().addChangeListener(this::onIrisBiometricCaptureChange);
        this.enrollmentService.getPhotograph().addValidityChangeListener(this::onValidityChange);
        this.enrollmentService.getFingerPrint().addValidityChangeListener(this::onValidityChange);
        this.enrollmentService.getIris().addValidityChangeListener(this::onValidityChange);
        this.enrollmentService.getBiometricsException().addChangeListener(this::onBiometricExceptionChange);
        this.enrollmentService.operatorConfirmationListener(this::onOperatorConfirmation);
        if (this.enrollmentService.isOnlineUpdate()) {
            SwingUtilities.invokeLater(() -> {
                this.onDocumentChange(this.enrollmentService.getReferences().getPoi());
                this.onDocumentChange(this.enrollmentService.getReferences().getPoa());
                this.onDocumentChange(this.enrollmentService.getReferences().getPob());
                if (this.enrollmentService.isHofEnrollment()) {
                    this.onDocumentChange(this.enrollmentService.getReferences().getPor());
                }
                this.onValidityChange(true);
            });
        }
        this.addEventListenersForUpdateEnrollment(this.enrollmentService.isUpdateEnrollment());
        this.addActionListener(this.viewElements.navigationPanel.previousBut, this::onPrevButtonClick);
        this.addActionListener(this.viewElements.navigationPanel.confirmBut, this::onConfirmButtonClick);
    }

    private void onConfirmButtonClick(ActionEvent event) {
        if (this.isoperatorConfirmed) {
            ((ActionListener)this.viewElements.evtCtxt.getEventListener("HID_ACK_SLIP_PANEL_DISPLAY", ActionListener.class)).actionPerformed(event);
        } else {
            ((ActionListener)this.viewElements.evtCtxt.getEventListener("hID_Enrol_OSI_ShowWin", ActionListener.class)).actionPerformed(event);
        }
    }

    private void onOperatorConfirmation() {
        this.isoperatorConfirmed = true;
    }

    private void onIrisBiometricCaptureChange(Iris iris) {
        if (iris.isCaptureBothIrisSeparately()) {
            this.onBiometricChange(iris.getLeftEye(), false);
            this.onBiometricChange(iris.getRightEye(), false);
        } else {
            this.onBiometricChange(iris.getBothIris().getLeftEye(), false);
            this.onBiometricChange(iris.getBothIris().getRightEye(), false);
        }
    }

    private void onBiometricExceptionChange(BiometricsException biometricException) {
        BiometricsExceptionDetail biometricsExceptionDetail = biometricException.getExceptionDetail();
        boolean biometricExceptionApplied = biometricsExceptionDetail.isBiometricExceptionApplied();
        StringBuilder biometricExceptionAppliedList = new StringBuilder("Biometric Exception: ");
        this.setPreview(this.viewElements.biometricsPanel.leftIris, true);
        this.setPreview(this.viewElements.biometricsPanel.rightIris, true);
        this.setPreview(this.viewElements.biometricsPanel.leftSlap, true);
        this.setPreview(this.viewElements.biometricsPanel.rightSlap, true);
        this.setPreview(this.viewElements.biometricsPanel.bothThumbs, true);
        if (biometricExceptionApplied) {
            boolean bothEyeExceptionApplied = biometricsExceptionDetail.isBothEyesExceptionApplied();
            boolean leftEyeExceptionApplied = biometricsExceptionDetail.isLeftEyeExceptionApplied();
            boolean rightEyeExceptionApplied = biometricsExceptionDetail.isRightEyeExceptionApplied();
            boolean leftSlapExceptionApplied = biometricsExceptionDetail.isLeftSlapExceptionApplied();
            boolean rightSlapExceptionApplied = biometricsExceptionDetail.isRightSlapExceptionApplied();
            boolean bothThumbsExceptionApplied = biometricsExceptionDetail.isBothThumbsExceptionApplied();
            if (bothEyeExceptionApplied) {
                biometricExceptionAppliedList.append(BiometricPosition.LEFT_IRIS.toString()).append(",");
                biometricExceptionAppliedList.append(BiometricPosition.RIGHT_IRIS.toString()).append(",");
                this.setPreview(this.viewElements.biometricsPanel.leftIris, false);
                this.setPreview(this.viewElements.biometricsPanel.rightIris, false);
            } else if (leftEyeExceptionApplied) {
                biometricExceptionAppliedList.append(BiometricPosition.LEFT_IRIS.toString()).append(",");
                this.setPreview(this.viewElements.biometricsPanel.leftIris, false);
            } else if (rightEyeExceptionApplied) {
                biometricExceptionAppliedList.append(BiometricPosition.RIGHT_IRIS.toString()).append(",");
                this.setPreview(this.viewElements.biometricsPanel.rightIris, false);
            }
            if (leftSlapExceptionApplied) {
                this.setPreview(this.viewElements.biometricsPanel.leftSlap, false);
            }
            biometricsExceptionDetail.getMissingFingersFromLeftHand().forEach(t -> biometricExceptionAppliedList.append(t.toString()).append(","));
            if (rightSlapExceptionApplied) {
                this.setPreview(this.viewElements.biometricsPanel.rightSlap, false);
            }
            biometricsExceptionDetail.getMissingFingersFromRightHand().forEach(t -> biometricExceptionAppliedList.append(t.toString()).append(","));
            if (bothThumbsExceptionApplied) {
                this.setPreview(this.viewElements.biometricsPanel.bothThumbs, false);
            }
        } else {
            this.setPreview(this.viewElements.biometricsPanel.bioxPhoto, false);
            biometricExceptionAppliedList.append("None ");
        }
        String exceptionList = biometricExceptionAppliedList.toString();
        this.viewElements.biometricsPanel.bioxDetails.setText(this.removeLastCharacter(exceptionList));
    }

    private void onBiometricUpdateTypeChange(Boolean biometricUpdate) {
        this.viewElements.biometricsPanel.setBiometricExceptionPanelVisible(biometricUpdate);
        this.viewElements.biometricsPanel.setBioSummaryPanelVisible(biometricUpdate);
        if (!this.enrollmentService.isOnlineUpdate()) {
            this.viewElements.biometricsPanel.setResidentConfirmationPanelVisible(biometricUpdate == false);
        }
    }

    private void loadPage() {
        this.onNameChange(this.enrollmentService.getDemoPersonalDetails().getName());
        this.onGenderChange(this.enrollmentService.getDemoPersonalDetails().getApplicantGender());
        this.onAgeDobChange(this.enrollmentService.getDemoPersonalDetails().getAgeDob());
        this.onContactChange(this.enrollmentService.getDemoContactDetails());
        this.onRelativeChange(this.enrollmentService.getRelativeDetails());
        this.onAadhaarNumberChange(this.enrollmentService.getDemoPersonalDetails().getAadhaarNumber());
        if (!this.viewElements.isRDBasedUpdate) {
            if (this.enrollmentService.isOnlineUpdate() && this.enrollmentService.isBiometricUpdate()) {
                this.loadDefaultImagePreviews();
            } else if (!this.enrollmentService.isOnlineUpdate()) {
                this.loadDefaultImagePreviews();
            }
        }
    }

    private void loadDefaultImagePreviews() {
        ThumbOverlay thumbnailMandatoryOverlay = new ThumbOverlay("ErrorOvl").image(ICON_REVIEW_MANDATORY);
        ThumbOverlay thumbnailNAOverlay = new ThumbOverlay("MinorOvl").image(ICON_REVIEW_NOT_APPLICABLE);
        this.viewElements.photoPanel.facePhoto.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.leftSlap.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.rightSlap.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.bothThumbs.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.leftIris.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.rightIris.addOverlay(thumbnailMandatoryOverlay);
        this.viewElements.biometricsPanel.bioxPhoto.addOverlay(thumbnailNAOverlay);
        if (this.enrollmentService.isUpdateEnrollment()) {
            this.viewElements.biometricsPanel.resConfirm.addOverlay(thumbnailMandatoryOverlay);
            this.viewElements.biometricsPanel.setBioSummaryPanelVisible(false);
        }
    }

    private void setPreview(CaptureThumbnail captureThumbnail, boolean mandatory) {
        ThumbOverlay thumbnailMandatoryOverlay = new ThumbOverlay("ErrorOvl").image(ICON_REVIEW_MANDATORY);
        ThumbOverlay thumbnailNAOverlay = new ThumbOverlay("MinorOvl").image(ICON_REVIEW_NOT_APPLICABLE);
        captureThumbnail.addOverlay(null);
        if (mandatory) {
            captureThumbnail.addOverlay(thumbnailMandatoryOverlay);
        } else {
            captureThumbnail.addOverlay(thumbnailNAOverlay);
        }
    }

    private void addEventListenersForUpdateEnrollment(boolean updateEnrollment) {
        if (!updateEnrollment) {
            return;
        }
        this.enrollmentService.getDemographics().getPersonalDetail().getAadhaarNumber().addChangeListener(this::onAadhaarNumberChange);
        this.enrollmentService.addBiometricUpdateChangeListener(this::onBiometricUpdateTypeChange);
        this.enrollmentService.getPhotograph().getResidentConfirmation().addChangeListener(this::onResidentConfirmationChange);
        this.enrollmentService.addResidentChildListeners(this::childResidentUpdate);
    }

    private void childResidentUpdate(Boolean isChild) {
    }

    private void onResidentConfirmationChange(ResidentConfirmation residentConfirmation) {
        BiometricPosition biometricPosition = residentConfirmation.getBiometricPosition();
        switch (biometricPosition) {
            case LEFT_IRIS: {
                this.onBiometricChange(residentConfirmation.getLeftIris(), true);
                break;
            }
            case RIGHT_IRIS: {
                this.onBiometricChange(residentConfirmation.getRightIris(), true);
                break;
            }
            case LEFT_SLAP: {
                this.onBiometricChange(residentConfirmation.getLeftSlap(), true);
                break;
            }
            case RIGHT_SLAP: {
                this.onBiometricChange(residentConfirmation.getRightSlap(), true);
                break;
            }
            case BOTH_THUMBS: {
                this.onBiometricChange(residentConfirmation.getBothThumbs(), true);
            }
        }
    }

    private void onAadhaarNumberChange(AadhaarNo aadhaarNo) {
        if (!this.enrollmentService.isUpdateEnrollment()) {
            return;
        }
        String text = aadhaarNo == null || !aadhaarNo.isValid() ? "<html><font color=red>Missing/Invalid Aadhaar Number" : aadhaarNo.getFormattedAadhaarNumber();
        this.viewElements.demographicsPanel.uidField.setText(text);
    }

    private void onValidityChange(boolean valid) {
        boolean onlineUpdate = this.enrollmentService.isUniversalClientTrnx();
        boolean enabled = false;
        if (onlineUpdate) {
            boolean bl = enabled = valid && (!this.enrollmentService.getUpdateType().equals((Object)UpdateType.UC_UPDATE) || this.enrollmentService.getFieldsUpdateCount().isValid() || this.enrollmentService.isBiometricUpdate()) && this.enrollmentService.getDemographics().isValid();
            if (this.enrollmentService.isBiometricUpdate()) {
                enabled = this.enrollmentService.getPhotograph().isValid() && this.enrollmentService.getFingerPrint().isValid() && this.enrollmentService.getIris().isValid();
            }
        } else if (valid && this.enrollmentService.getDemographics().isValid() && this.enrollmentService.getReferences().isValid() && this.enrollmentService.getPhotograph().isValid() && this.enrollmentService.getFingerPrint().isValid() && this.enrollmentService.getIris().isValid()) {
            enabled = true;
        }
        this.viewElements.navigationPanel.confirmBut.setEnabled(enabled);
        this.viewElements.navigationPanel.previewBut.setEnabled(!onlineUpdate && enabled);
    }

    private void onNameChange(Name name) {
        String fullNameText = "";
        String fullNameLocalText = "";
        String newNameText = "";
        String newNameLocalText = "";
        boolean isNameUpdated = false;
        if (name != null) {
            fullNameText = name.english();
            fullNameLocalText = name.local();
            newNameText = name.newEnglish();
            newNameLocalText = name.newNameLocal();
            isNameUpdated = name.isMandatory();
        }
        this.viewElements.demographicsPanel.fullName.setText(StringUtils.isEmpty((String)fullNameText) ? "Missing" : fullNameText);
        this.viewElements.demographicsPanel.fullName.setForeground(StringUtils.isEmpty((String)fullNameText) ? Color.RED : Color.BLACK);
        this.viewElements.demographicsPanel.tFullName.setText(StringUtils.isEmpty((String)fullNameText) ? this.rbCtx.getLocaleMessage((Object)"tlit-map:not_specified", new Object[0]) : fullNameLocalText);
        this.viewElements.demographicsPanel.tFullName.setForeground(StringUtils.isEmpty((String)fullNameText) ? Color.RED : Color.BLACK);
        if (this.enrollmentService.isUpdateEnrollment()) {
            this.viewElements.demographicsPanel.newName.setText("<html> New Name: " + (!isNameUpdated ? "Not Changed" : (StringUtils.isEmpty((String)newNameText) ? "<font color='red'>Missing</font>" : newNameText)));
            this.viewElements.demographicsPanel.tNewName.setText("<html>" + this.rbCtx.getLocaleMessage((Object)"label-tlit:demotab.name.new", new Object[0]) + ": " + (!isNameUpdated ? "<font>" + this.rbCtx.getLocaleMessage((Object)"tlit-map:not_changed", new Object[0]) + "</font>" : (StringUtils.isEmpty((String)newNameLocalText) ? "<font color='red'>" + this.rbCtx.getLocaleMessage((Object)"tlit-map:not_specified", new Object[0]) + "</font>" : newNameLocalText)));
            this.viewElements.demographicsPanel.nameUpdateDecl.setVisible(isNameUpdated);
        }
    }

    private void onGenderChange(ApplicantGender applicantGender) {
        String ageGenderText = this.formatAgeGenderText(applicantGender, null);
        this.viewElements.demographicsPanel.ageGender.setText(ageGenderText);
        this.viewElements.demographicsPanel.tAgeGender.setText(ageGenderText);
    }

    private void onAgeDobChange(AgeDob ageDob) {
        String ageGenderText = this.formatAgeGenderText(null, ageDob);
        this.viewElements.demographicsPanel.ageGender.setText(ageGenderText);
        this.viewElements.demographicsPanel.tAgeGender.setText(ageGenderText);
        String ageDobText = "Not Specified";
        if (this.enrollmentService.isUpdateEnrollment() && (ageDob == null || !ageDob.isUpdated())) {
            this.viewElements.demographicsPanel.lblDOB.setText("YOB: ");
            this.viewElements.demographicsPanel.dateOfBirth.setText(this.rbCtx.getMessage((Object)"tlit-map:not_changed", new Object[0]));
            this.viewElements.demographicsPanel.tDateOfBirth.setText(this.rbCtx.getLocaleMessage((Object)"tlit-map:not_changed", new Object[0]));
        } else if (ageDob != null && ageDob.isDobSelected()) {
            if (this.enrollmentService.getDemoPersonalDetails().getAgeDob().isVerified()) {
                this.viewElements.demographicsPanel.lblDOB.setText("DOB: ");
            } else {
                this.viewElements.demographicsPanel.lblDOB.setText("YOB: ");
            }
            this.viewElements.demographicsPanel.dateOfBirth.setDate(ageDob.getDay().toString(), ageDob.getMonth().toString(), ageDob.getYear().toString());
            this.viewElements.demographicsPanel.tDateOfBirth.setDate(ageDob.getDay().toString(), ageDob.getMonth().toString(), ageDob.getYear().toString());
        } else {
            this.viewElements.demographicsPanel.lblDOB.setText("YOB: ");
            this.viewElements.demographicsPanel.dateOfBirth.setText(ageDobText);
            this.viewElements.demographicsPanel.tDateOfBirth.setText(this.rbCtx.getLocaleMessage((Object)"tlit-map:not_specified", new Object[0]));
        }
        if (this.enrollmentService.isUpdateEnrollment()) {
            this.childResidentUpdate(ageDob != null && ageDob.isChild());
        }
    }

    private String formatAgeGenderText(ApplicantGender applicantGender, AgeDob ageDob) {
        if (applicantGender == null) {
            applicantGender = this.enrollmentService.getDemographics().getPersonalDetail().getApplicantGender();
        }
        if (ageDob == null) {
            ageDob = this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob();
        }
        Gender gender = applicantGender.getGender();
        String genderText = gender.toString();
        genderText = gender == Gender.NOT_GIVEN && applicantGender.isMandatory() ? "<html><font color=red>Gender?</font>" : (gender == Gender.NOT_GIVEN ? "" : "<html>" + StringUtils.capitalize((String)Gender.fromString((String)genderText).toString().toLowerCase()));
        String ageText = "";
        if (ageDob.isValid()) {
            ageText = ageDob.getAge().toString();
        }
        if (ageDob.isMandatory() && (StringUtils.isEmpty((String)ageText) || !ageDob.isValid())) {
            ageText = "<html><font color=red>Age?</font>";
        } else if (!ageDob.isMandatory()) {
            ageText = "";
        }
        if (StringUtils.isEmpty((String)genderText)) {
            return ageText;
        }
        if (StringUtils.isEmpty((String)ageText)) {
            return genderText;
        }
        return genderText + "/" + ageText + "</html>";
    }

    private void onContactChange(Contact contact) {
        String emailAddr;
        String pinCodeValue;
        String state;
        String district;
        boolean rtl;
        if (contact == null) {
            contact = this.enrollmentService.getDemographics().getContact();
        }
        Address address = contact.getAddress();
        StringBuilder addressHTMLString = new StringBuilder("<html>");
        StringBuilder addressHTMLStringLocal = new StringBuilder("<html>");
        if (this.rbCtx.getLocale().toString().equals("ur_IN")) {
            rtl = true;
            addressHTMLString.append("<table align='right' dir='rtl'>");
            addressHTMLStringLocal.append("<table align='right' dir='rtl'>");
        } else {
            rtl = false;
            addressHTMLString.append("<table align='left' dir='lrt'>");
            addressHTMLStringLocal.append("<table align='left' dir='lrt'>");
        }
        if (StringUtils.isNotBlank((String)address.getCareOfName())) {
            addressHTMLString.append(this.createHTMLRow(address.getCareOf(), address.getCareOfName()));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.careof", new Object[0]), address.getCareOfNameLocal(), rtl));
        }
        String house = address.getBuilding();
        String houseLocal = address.getBuildingLocal();
        if (StringUtils.isNotBlank((String)house)) {
            addressHTMLString.append(this.createHTMLRow("House/Building/Apt", house));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.house", new Object[0]), houseLocal, rtl));
        }
        String street = address.getStreet();
        String streetLocal = address.getStreetLocal();
        if (StringUtils.isNotBlank((String)street)) {
            addressHTMLString.append(this.createHTMLRow("Street/Road/Lane", street));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.street", new Object[0]), streetLocal, rtl));
        }
        String landMark = address.getLandmark();
        String landMarkLocal = address.getLandmarkLocal();
        if (StringUtils.isNotBlank((String)landMark)) {
            addressHTMLString.append(this.createHTMLRow("Landmark", landMark));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.landmark", new Object[0]), landMarkLocal, rtl));
            addressHTMLString.append("<br/>");
            addressHTMLStringLocal.append("<br/>");
        }
        String locality = address.getLocality();
        String localityLocal = address.getLocalityLocal();
        if (StringUtils.isNotBlank((String)locality)) {
            addressHTMLString.append(this.createHTMLRow("Area/Sector/Locality", locality));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.locality", new Object[0]), localityLocal, rtl));
        }
        String vtc = address.getVTC();
        String vtcLocal = address.getVTCLocal();
        if (StringUtils.isNotBlank((String)vtc)) {
            addressHTMLString.append(this.createHTMLRow("Village/Town/City", vtc));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.vtc", new Object[0]), vtcLocal, rtl));
        }
        String poName = address.getPoName();
        String poNameLocal = address.getPoNameLocal();
        if (StringUtils.isNotBlank((String)poName)) {
            addressHTMLString.append(this.createHTMLRow("P.O.", poName));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:reviewtab.po", new Object[0]), poNameLocal, rtl));
        }
        String subDistrict = address.getSubDistrict();
        String subDistrictLocal = address.getSubDistrictLocal();
        if (StringUtils.isNotBlank((String)subDistrict)) {
            addressHTMLString.append(this.createHTMLRow("Subdistrict", subDistrict));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.subdistrict", new Object[0]), subDistrictLocal, rtl));
        }
        if (StringUtils.isNotBlank((String)(district = address.getDistrict()))) {
            addressHTMLString.append(this.createHTMLRow("District", district));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.district", new Object[0]), address.getDistrictLocal(), rtl));
        }
        if (StringUtils.isNotBlank((String)(state = address.getState()))) {
            addressHTMLString.append(this.createHTMLRow("State", state));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.state", new Object[0]), address.getStateLocal(), rtl));
        }
        if (StringUtils.isNotBlank((String)(pinCodeValue = address.getPinCodeValue()))) {
            addressHTMLString.append(this.createHTMLRow("PinCode", pinCodeValue));
            addressHTMLStringLocal.append(this.createHTMLRowLocal(this.rbCtx.getLocaleMessage((Object)"label-tlit:addr.pincode", new Object[0]), address.getPinCodeLocal(), rtl));
        }
        addressHTMLString.append("</table>");
        addressHTMLString.append("<br>");
        addressHTMLStringLocal.append("<br>");
        String mobileNum = contact.getMobile().number();
        if (StringUtils.isNotBlank((String)mobileNum)) {
            addressHTMLString.append("Mobile No: ").append(contact.getMobile().isdCode()).append(" ").append(mobileNum);
        }
        if (StringUtils.isNotBlank((String)(emailAddr = contact.getEmail().email()))) {
            addressHTMLString.append("<br>");
            addressHTMLString.append("Email: ").append(emailAddr);
        }
        addressHTMLString.append("</html>");
        addressHTMLStringLocal.append("</html>");
        this.viewElements.demographicsPanel.address.setText(addressHTMLString.toString());
        this.viewElements.demographicsPanel.tAddress.setText(addressHTMLStringLocal.toString());
    }

    private String createHTMLRow(String key, String value) {
        if (StringUtils.isBlank((String)value)) {
            return "<tr><td align='right'><b>" + key + ":</b></td><td>:</td><td nowrap='nowrap'></td></tr>";
        }
        return "<tr><td align='right'><b>" + key + ":</b></td><td>:</td><td nowrap='nowrap'>" + value + "</td></tr>";
    }

    private String createHTMLRowLocal(String key, String value, boolean rtl) {
        if (StringUtils.isBlank((String)value)) {
            return "<tr><td align='left'><b>" + key + ":</b></td><td>:</td><td nowrap='nowrap'></td></tr>";
        }
        if (rtl) {
            return "<tr><td align='right'><b>" + key + ":</b></td><td>:</td><td nowrap='nowrap'>" + value + "</td></tr>";
        }
        return "<tr><td align='left'><b>" + key + ":</b></td><td>:</td><td nowrap='nowrap'>" + value + "</td></tr>";
    }

    private void onRelativeChange(ReferenceRelative referenceRelative) {
        if (referenceRelative == null) {
            referenceRelative = this.enrollmentService.getReferences().getReferenceRelative();
        }
        if (referenceRelative.isNotGiven()) {
            this.viewElements.demographicsPanel.relDetails.setText("");
            this.viewElements.demographicsPanel.tRelDetails.setText("");
            this.viewElements.verificationPanel.hofName.setText("");
            this.viewElements.verificationPanel.tHofName.setText("");
            return;
        }
        this.viewElements.verificationPanel.hofName.setText(referenceRelative.getName());
        this.viewElements.verificationPanel.tHofName.setText(referenceRelative.getNameLocal());
        String relationTypeDisplayText = this.relationTypeDisplayText(referenceRelative);
        this.viewElements.demographicsPanel.relDetails.setText(referenceRelative.getName() + relationTypeDisplayText);
        this.viewElements.demographicsPanel.tRelDetails.setText(referenceRelative.getNameLocal() + relationTypeDisplayText);
        String relativeIdDisplayText = "";
        if (referenceRelative.isEnrolmentIdMandatory()) {
            relativeIdDisplayText = String.format("Enrolment_Id: %s", this.enrollmentIdDisplayText(referenceRelative));
        } else if (referenceRelative.isAadhaarNumberMandatory()) {
            relativeIdDisplayText = String.format("Aadhaar_No: %s", this.formatValueForDisplay(referenceRelative.getFormattedAadhaarNumber()));
        }
        this.viewElements.demographicsPanel.relId.setText(relativeIdDisplayText);
        this.viewElements.demographicsPanel.tRelId.setText(relativeIdDisplayText);
    }

    private void onDocumentChange(ReferenceDocument referenceDocument) {
        if (referenceDocument == null) {
            return;
        }
        References references = this.enrollmentService.getReferences();
        this.clearVerificationArea();
        if (!referenceDocument.isMandatory()) {
            return;
        }
        switch (referenceDocument.getDocumentType()) {
            case HOF: {
                this.viewElements.verificationPanel.verifyHofArea.setVisible(true);
                this.viewElements.verificationPanel.hofProof.setText(references.getHofDoc().getProof().getDocName());
                break;
            }
            case POR: 
            case POB: 
            case POA: 
            case POI: {
                this.viewElements.verificationPanel.verifyDocArea.setVisible(true);
                this.viewElements.verificationPanel.identityProof.setText(this.documentNameForDisplay(references.getPoi().getProof()));
                this.viewElements.verificationPanel.addressProof.setText(this.documentNameForDisplay(references.getPoa().getProof()));
                this.viewElements.verificationPanel.dobProof.setText(this.documentNameForDisplay(references.getPob().getProof()));
            }
        }
    }

    private String documentNameForDisplay(ProofDocument proofDocument) {
        if (proofDocument == null) {
            return "N/A";
        }
        String docName = proofDocument.getDocName();
        if (StringUtils.isBlank((String)docName) || StringUtils.equalsIgnoreCase((String)docName, (String)"Select")) {
            return "N/A";
        }
        return docName;
    }

    private String formatValueForDisplay(String value) {
        if (StringUtils.isBlank((String)value) || StringUtils.equalsIgnoreCase((String)value, (String)"Select")) {
            return "N/A";
        }
        return value;
    }

    private String relationTypeDisplayText(ReferenceRelative referenceRelative) {
        if (referenceRelative.getRelationshipType() == RelationshipType.NOT_GIVEN) {
            return "";
        }
        String relationType = referenceRelative.getRelationshipType().toString();
        return String.format(" (%s)", this.formatValueForDisplay(relationType));
    }

    private String enrollmentIdDisplayText(ReferenceRelative referenceRelative) {
        if (referenceRelative.getEnrolmentIdError() == null && referenceRelative.getEnrolmentDateTimeError() == null) {
            return String.format("%s %s", this.formatValueForDisplay(referenceRelative.getFormattedEnrolmentId()), this.formatValueForDisplay(referenceRelative.getFormattedEnrolmentDateTime()));
        }
        return "N/A";
    }

    private void clearVerificationArea() {
        this.viewElements.verificationPanel.verifyDocArea.setVisible(false);
        this.viewElements.verificationPanel.verifyIntroArea.setVisible(false);
        this.viewElements.verificationPanel.verifyHofArea.setVisible(false);
    }

    private void onBiometricChange(Biometrics biometrics, boolean isResidenceConfirmationOrigin) {
        CaptureModality captureModality = biometrics.getCaptureModality();
        CaptureThumbnail captureThumbnail = null;
        ReviewBiometricsPanel bioPanel = this.viewElements.biometricsPanel;
        switch (captureModality) {
            case FACE: {
                this.setImagePreview(biometrics, this.viewElements.photoPanel.facePhoto, true);
                return;
            }
            case BIOX: {
                boolean biometricExceptionApplied = this.enrollmentService.getBiometricsException().getExceptionDetail().isBiometricExceptionApplied();
                this.setImagePreview(biometrics, bioPanel.bioxPhoto, biometricExceptionApplied);
                return;
            }
            case LEFT_SLAP: {
                captureThumbnail = isResidenceConfirmationOrigin ? bioPanel.resConfirm : bioPanel.leftSlap;
                break;
            }
            case RIGHT_SLAP: {
                captureThumbnail = isResidenceConfirmationOrigin ? bioPanel.resConfirm : bioPanel.rightSlap;
                break;
            }
            case THUMB_SLAP: {
                captureThumbnail = isResidenceConfirmationOrigin ? bioPanel.resConfirm : bioPanel.bothThumbs;
                break;
            }
            case LEFT_IRIS: {
                captureThumbnail = isResidenceConfirmationOrigin ? bioPanel.resConfirm : bioPanel.leftIris;
                break;
            }
            case RIGHT_IRIS: {
                captureThumbnail = isResidenceConfirmationOrigin ? bioPanel.resConfirm : bioPanel.rightIris;
            }
        }
        this.setImagePreview(biometrics, captureThumbnail, true);
        if (isResidenceConfirmationOrigin) {
            bioPanel.resConfirmType.setText(StringUtils.capitalize((String)captureModality.toGroupName()));
        }
    }

    private void setImagePreview(Biometrics biometrics, CaptureThumbnail element, boolean mandatory) {
        CapturedImage capturedImage = null;
        ThumbOverlay thumbnailOverlay = null;
        String overlayImageName = ICON_REVIEW_MANDATORY;
        element.setThumbnailImage(null);
        element.addOverlay(null);
        if (this.enrollmentService.getDemographics().getPersonalDetail().getAgeDob().isChild()) {
            overlayImageName = ICON_REVIEW_NOT_APPLICABLE;
        }
        if (biometrics != null) {
            CaptureAttempt attempt = biometrics.getBestAttempt();
            if (attempt != null) {
                capturedImage = attempt.getImage();
            } else if (biometrics.getCaptureAttemptWithMaxScore() != null) {
                capturedImage = biometrics.getCaptureAttemptWithMaxScore().getImage();
            } else if (mandatory) {
                thumbnailOverlay = new ThumbOverlay("ErrorOvl").image(overlayImageName);
            }
        }
        element.setThumbnailImage(capturedImage);
        element.addOverlay(thumbnailOverlay);
    }

    private void onResidentalStatusChange(ResidentialStatus residentialStatus) {
        LabelKeysDemoTab consentKey = this.enrollmentService.getDemoResidentialStatus().isNRI() ? (this.enrollmentService.isUpdateEnrollment() ? LabelKeysDemoTab.NRI_DISCLAIMER : LabelKeysDemoTab.NRI_DISCLAIMER_UPDATE) : (this.enrollmentService.isUpdateEnrollment() ? LabelKeysDemoTab.DISCLAIMER : LabelKeysDemoTab.DISCLAIMER_UPDATE);
        this.viewElements.consentPanel.declaration.setText(this.rbCtx.getMessage((Object)consentKey, new Object[0]));
    }

    public String removeLastCharacter(String str) {
        return Optional.ofNullable(str).filter(sStr -> sStr.length() != 0).map(sStr -> sStr.substring(0, sStr.length() - 1)).orElse(str);
    }

    static {
        ImageIconCache.getInst().addIcon(ICON_REVIEW_MANDATORY, "res/images/review-nocap.png");
        ImageIconCache.getInst().addIcon(ICON_REVIEW_NOT_APPLICABLE, "res/images/review-minorbio.png");
    }
}

