/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.review;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.FixedWidthTwoColTile;
import in.gov.uidai.ec.ui.enrol.EnrolViewPeer;
import in.gov.uidai.ec.ui.enrol.review.ReviewBiometricsPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewConsentPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewController;
import in.gov.uidai.ec.ui.enrol.review.ReviewDemographicsPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewNavigationPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewPhotoPanel;
import in.gov.uidai.ec.ui.enrol.review.ReviewVerificationPanel;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysTab;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.ILiteView;
import in.gov.uidai.swing.l10n.L10nDecorator;
import java.awt.Color;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;

public class ReviewTabViewPeer
implements IViewElementComposite {
    protected final EnrollmentService enrollmentService;
    protected final ILiteView view;
    protected final IResourceBundleContext clientRbCtx;
    protected final IEventContext evtCtxt;
    protected final boolean isRDBasedUpdate;
    private final IUIPreference uiPref;
    private final boolean isPhotographCaptureEnabled;
    private final boolean isUpdateEnrollment;
    protected ReviewNavigationPanel navigationPanel;
    protected ReviewPhotoPanel photoPanel;
    protected ReviewVerificationPanel verificationPanel;
    protected ReviewBiometricsPanel biometricsPanel;
    protected ReviewDemographicsPanel demographicsPanel;
    protected ReviewConsentPanel consentPanel;
    private JComponent tabPanel;
    private JTabbedPane tabbedPane;
    private int tabIndex;
    protected final IResourceBundleContext rbCtx;

    public ReviewTabViewPeer(EnrolViewPeer enrolViewPeer) {
        this.view = enrolViewPeer.getView();
        this.enrollmentService = enrolViewPeer.enrollmentService;
        this.clientRbCtx = enrolViewPeer.enrolRbCtxt;
        this.evtCtxt = enrolViewPeer.evtCtxt;
        this.uiPref = enrolViewPeer.uiPref;
        this.isPhotographCaptureEnabled = this.enrollmentService.isPhotographCaptureEnabled();
        this.isRDBasedUpdate = this.enrollmentService.isRDBasedUpdate();
        this.isUpdateEnrollment = this.enrollmentService.isUpdateEnrollment();
        this.tabbedPane = enrolViewPeer.getTabbedPane();
        this.rbCtx = enrolViewPeer.enrolRbCtxt;
    }

    public void prepare() {
        this.photoPanel = new ReviewPhotoPanel();
        this.navigationPanel = new ReviewNavigationPanel(this.clientRbCtx, this.evtCtxt, this.uiPref);
        this.verificationPanel = new ReviewVerificationPanel(this.uiPref);
        this.consentPanel = new ReviewConsentPanel(this.clientRbCtx);
        this.biometricsPanel = new ReviewBiometricsPanel(this.clientRbCtx, this.uiPref);
        this.demographicsPanel = new ReviewDemographicsPanel(this.clientRbCtx);
        FixedWidthTwoColTile mainTile = new FixedWidthTwoColTile();
        mainTile.setWidth(950);
        mainTile.setScrollable(true);
        mainTile.setPadding(10, 10, 10, 10);
        mainTile.prepare();
        mainTile.addCenterComponent(this.isUpdateEnrollment ? this.demographicsPanel.createEnrolDeclPanel() : this.demographicsPanel.createOptHeaderPanel());
        mainTile.addCenterComponent(Box.createVerticalStrut(5));
        mainTile.addCenterComponent(this.demographicsPanel.create(this.isUpdateEnrollment));
        if (this.isPhotographCaptureEnabled) {
            mainTile.addRightComponent(this.photoPanel.create());
        }
        if (this.isUpdateEnrollment && !this.isRDBasedUpdate) {
            mainTile.addRightComponent(Box.createVerticalStrut(15));
            mainTile.addRightComponent(this.biometricsPanel.createResConfirmPanel());
        }
        mainTile.addRightComponent(Box.createVerticalStrut(15));
        if (!this.isRDBasedUpdate) {
            mainTile.addRightComponent(this.biometricsPanel.createBioxPanel(this.isUpdateEnrollment));
        }
        mainTile.addCenterComponent(this.verificationPanel.create());
        mainTile.addCenterComponent(Box.createVerticalStrut(10));
        if (!this.isRDBasedUpdate) {
            mainTile.addCenterComponent(this.biometricsPanel.createBioSummaryPanel());
        }
        mainTile.addCenterComponent(Box.createVerticalStrut(10));
        mainTile.addCenterComponent(this.consentPanel.create(this.isUpdateEnrollment));
        mainTile.setBottomComponent(this.navigationPanel.create());
        this.tabPanel = mainTile.toSwing();
        new ReviewController(this, this.tabIndex);
    }

    public void renderReviewTab() {
        this.tabbedPane.addTab(this.rbCtx.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]), this.toSwing());
        this.tabbedPane.setTabComponentAt(this.tabIndex, this.createReviewTabLabel());
    }

    private JLabel createReviewTabLabel() {
        JLabel label = new JLabel(this.rbCtx.getMessage((Object)LabelKeysTab.REVIEW, new Object[0]));
        new L10nDecorator(this.rbCtx, this.uiPref.getApplicationLocalize(false)).localize(label, (Object)LabelKeysTab.REVIEW, new Object[0]);
        label.setForeground(Color.WHITE);
        this.tabbedPane.setEnabledAt(this.tabIndex, true);
        return label;
    }

    public JComponent toSwing() {
        return this.tabPanel;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }
}

