/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.appointment;

import com.google.common.base.Strings;
import in.gov.uidai.ec.grpc.GrpcService;
import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.icas.text.UidLocaleUtils;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.exception.ErrorCodes;
import in.gov.uidai.ec.oauthapi.json.UosResponse;
import in.gov.uidai.ec.protobuf.AppointmentServiceProto;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.universalClient.uiHandler.FieldInfoUtils;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.AppointmentServiceEnrol;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.AppointmentServiceUpdate;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.IAppointmentService;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.utils.ThreadPool;
import in.gov.uidai.ec.ui.utils.Utils;
import in.gov.uidai.litef.beans.ModalVisualExecutionContext;
import in.gov.uidai.litef.devapi.EventHandler;
import in.gov.uidai.litef.devapi.GenericEventHandler;
import in.gov.uidai.litef.devapi.IEventContext;
import in.gov.uidai.litef.devapi.IEventContextAware;
import in.gov.uidai.litef.devapi.ILiteEvent;
import in.gov.uidai.litef.devapi.IOnScreenDisplay;
import in.gov.uidai.litef.devapi.IVisualExecutionContext;
import in.gov.uidai.litef.devapi.ScaffoldPlacement;
import in.gov.uidai.swing.l10n.L10nDecorator;
import in.gov.uidai.swing.l10n.L10nOptionPaneBuilder;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentApiControl
implements IEventContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentApiControl.class);
    private final IOnScreenDisplay osd;
    private final GrpcService grpcService;
    private final EnrollmentService enrollmentService;
    private final IPinCodeService postOfficeDataService;
    private final IDocumentService documentService;
    private ActionEvent dummyEvent;
    private IEventContext evtCtxt;
    private final IResourceBundleContext enrolRbCtxt;
    private IUIPreference pref;
    private ITransliterationProvider tlitProv;
    private String localeSpec;

    public AppointmentApiControl(IOnScreenDisplay osd, EnrollmentService enrollmentService, IPinCodeService postOfficeDataService, IDocumentService documentService, IResourceBundleContext enrolRbCtxt) {
        this.osd = osd;
        this.enrollmentService = enrollmentService;
        this.postOfficeDataService = postOfficeDataService;
        this.documentService = documentService;
        this.enrolRbCtxt = enrolRbCtxt;
        this.grpcService = GrpcService.getInst();
    }

    @EventHandler(name="hID_Appointment_FeildButSel", method="actionPerformed")
    public void onAppointmentFetchSelect(ILiteEvent evt) {
        LOGGER.info("Starting Appointment based Enrollment");
        this.dummyEvent = new ActionEvent(evt.getEvent().getSource(), 1, "actionPerformed");
        if (!Strings.isNullOrEmpty((String)this.enrollmentService.getSid())) {
            ((ActionListener)this.evtCtxt.getEventListener("cancelDemo", ActionListener.class)).actionPerformed(this.dummyEvent);
        } else {
            String scaffoldId = this.osd.compose("residentUidPopupWin", "residentAppointmentPreview");
            this.osd.display(scaffoldId, ScaffoldPlacement.CENTERED);
        }
    }

    @EventHandler(name="appointment_api_call", method="actionPerformed")
    public void handleAppointmentCall(ILiteEvent event) {
        IVisualExecutionContext veCtxt = this.createVisualExecutionContext();
        this.closeWinImpl(event);
        Utils.showProgressBar(veCtxt, "Fetching appointment detail. Please wait..");
        ThreadPool.commonPool().submit(() -> {
            this.grpcService.setTransactionId(this.enrollmentService.getTransactionId());
            String appointmentId = (String)event.getExtraParameters().get("appointmentId");
            AppointmentServiceProto.AppointmentRequest appointmentRequest = AppointmentServiceProto.AppointmentRequest.newBuilder().setAppointmentId(appointmentId).build();
            this.grpcService.getAppointmentData(appointmentRequest, response -> {
                try {
                    this.handleAppointmentResponse((AppointmentServiceProto.AppointmentResponse)response, veCtxt);
                }
                catch (OnlineGatewayException e) {
                    Utils.cancelProgressBar(veCtxt);
                    LOGGER.error("Error in handling appointment response, transaction id :: {}", (Object)this.enrollmentService.getTransactionId(), (Object)e);
                    this.handleError(e);
                }
            }, error -> this.handleUOSErrorResponse((UosResponse)error, veCtxt));
        });
    }

    private void handleAppointmentResponse(AppointmentServiceProto.AppointmentResponse response, IVisualExecutionContext veCtxt) {
        LOGGER.info("Successfully fetched appointment data");
        Utils.cancelProgressBar(veCtxt);
        this.validateResponse(response);
        boolean isEnrollment = response.getAppointmentServiceType().contains("ENROLMENT");
        if (isEnrollment) {
            this.enrollmentService.initiateUcEnrollment(this.enrollmentService.isPACValidationRequired());
        } else {
            this.enrollmentService.initiateUcUpdate(response.getResidentBasicDetail().getUid(), this.enrollmentService.isPACValidationRequired());
        }
        IAppointmentService appointmentService = this.getAppointmentService(isEnrollment);
        this.enrollmentService.getAppointment().setAppointmentId(response.getAppointmentId());
        boolean isHof = response.getAppointmentServiceType().contains("HOF");
        appointmentService.setUpdateType(response.getUpdateIdentifier());
        appointmentService.populatePersonalDetail(response.getResidentBasicDetail());
        appointmentService.populateContactDetail(response.getContactDetail());
        this.enrollmentService.setDemoUpdate(!isEnrollment && this.enrollmentService.getFieldsUpdateCount().isDemoUpdate());
        this.enrollmentService.setBiometricUpdate(!this.enrollmentService.isChildEnrollment() && this.enrollmentService.isNewEnrollmentUC());
        this.enrollmentService.setHofEnrollment(isHof && response.hasHofDetail());
        this.enrollmentService.setForeignResident(response.hasResidentForeignDetail());
        this.enrollmentService.setPobRequired("VERIFIED".equalsIgnoreCase(response.getResidentBasicDetail().getDobStatus()));
        this.enrollmentService.setDocumentBasedEnrollment(this.enrollmentService.isNewEnrollmentUC() && !this.enrollmentService.isHofEnrollment());
        appointmentService.populateHofDetail(response.getHofDetail());
        appointmentService.populateForeignDetail(response.getResidentForeignDetail());
        appointmentService.populateDocuments(response.getDocumentDetail(), response.getResidentBasicDetail().getNationalityType());
        FieldInfoUtils.setIsEnrollment((boolean)isEnrollment);
        ((ActionListener)this.evtCtxt.getEventListener("generate sid", ActionListener.class)).actionPerformed(this.dummyEvent);
    }

    private IAppointmentService getAppointmentService(boolean isEnrollment) {
        return isEnrollment ? new AppointmentServiceEnrol(this.enrollmentService, this.postOfficeDataService, this.documentService, this.pref) : new AppointmentServiceUpdate(this.enrollmentService, this.postOfficeDataService, this.documentService, this.pref);
    }

    private void validateResponse(AppointmentServiceProto.AppointmentResponse response) {
        String status = response.getAppointmentStatus();
        if ("DRAFT".equalsIgnoreCase(status)) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_002, (String)this.enrollmentService.getTransactionId());
        }
        if ("CANCELLED".equalsIgnoreCase(status)) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_006, (String)this.enrollmentService.getTransactionId());
        }
        if ("COMPLETED".equalsIgnoreCase(status)) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_007, (String)this.enrollmentService.getTransactionId());
        }
        if ("NO_SHOW".equalsIgnoreCase(status)) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_008, (String)this.enrollmentService.getTransactionId());
        }
        if (!"BOOKED".equalsIgnoreCase(status)) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_002, (String)this.enrollmentService.getTransactionId());
        }
        if (!"ONLINE".equalsIgnoreCase(response.getAppointmentType())) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_003, (String)this.enrollmentService.getTransactionId());
        }
        if ("HOF_BASED_UPDATE".equalsIgnoreCase(response.getAppointmentServiceType())) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_004, (String)this.enrollmentService.getTransactionId());
        }
        if (response.hasResidentForeignDetail()) {
            throw OnlineGatewayException.getException((ErrorCodes)ErrorCodes.UC_APP_005, (String)this.enrollmentService.getTransactionId());
        }
    }

    @GenericEventHandler(value="appointment_set_local_language")
    public void setLocalLanguageUpdate() {
        if (!this.enrollmentService.isUpdateUC()) {
            return;
        }
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        Address address = this.enrollmentService.getDemoContactDetails().getAddress();
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        Locale locale = UidLocaleUtils.getLocaleFromLangCode((int)Integer.parseInt(this.enrollmentService.getEnrollmentLangCode()));
        this.localeSpec = locale.getLanguage() + "_" + locale.getCountry();
        this.localeSpec = this.localeSpec.toLowerCase();
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
        if (fieldsUpdateCount.getName().hasToBeUpdated()) {
            personalDetail.setNewNameLocal(this.getTransliteratedText(personalDetail.getName().newEnglish()));
        }
        if (fieldsUpdateCount.getGender().hasToBeUpdated()) {
            personalDetail.setGenderLocal(this.getTransliteratedText(personalDetail.getApplicantGender().getGender().toString()));
            personalDetail.setConfirmGenderLocal(this.getTransliteratedText(personalDetail.getApplicantGender().getGender().toString()));
        }
        if (fieldsUpdateCount.getAddress().hasToBeUpdated()) {
            address.setStreetLocal(this.getTransliteratedText(address.getStreet()));
            address.setBuildingLocal(this.getTransliteratedText(address.getBuilding()));
            address.setLandmarkLocal(this.getTransliteratedText(address.getLandmark()));
            address.setCareOfNameLocal(this.getTransliteratedText(address.getCareOfName()));
            address.setDistrictLocal(this.getTransliteratedText(address.getDistrict()));
            address.setStateLocal(this.getTransliteratedText(address.getState()));
            address.setPinCodeLocal(this.getTransliteratedText(address.getPinCode()));
            address.setVTCLocal(this.getTransliteratedText(address.getVTC()));
            address.setPostOfficeLocal(address.getPoName());
        }
    }

    @EventHandler(name="closeWin", method="actionPerformed")
    public void closeWinImpl(ILiteEvent evt) {
        try {
            if (this.osd != null) {
                this.osd.dispose(evt.getScaffoldId());
                this.osd.disposeView(evt.getViewId());
            } else {
                LOGGER.info("OSD is not initialized.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing window: " + e.getMessage());
            TelemetryService.getTelemetryServiceInstance().postLogData(e, ErrorCodes.UC_GEN_144.getErrorCode(), new String[0]);
        }
    }

    private IVisualExecutionContext createVisualExecutionContext() {
        return new ModalVisualExecutionContext(null, false, new L10nDecorator(this.enrolRbCtxt, false));
    }

    private void handleUOSErrorResponse(UosResponse errorResponse, IVisualExecutionContext veCtxt) throws OnlineGatewayException {
        Utils.cancelProgressBar(veCtxt);
        LOGGER.error(CommonUtilsUC.getErrorMessage(errorResponse), (Object)errorResponse);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)OnlineGatewayException.getClientException((String)errorResponse.getErrorCode(), (String)CommonUtilsUC.getErrorMessage(errorResponse), (String)this.enrollmentService.getTransactionId(), null)), errorResponse.getErrorCode(), new String[0]);
        L10nOptionPaneBuilder.getInstance().showErrorUC(CommonUtilsUC.getErrorMessage(errorResponse), null, errorResponse.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
    }

    private void handleError(OnlineGatewayException exception) {
        L10nOptionPaneBuilder.getInstance().showErrorUC(exception.getDisplayMessage(), null, exception.getErrorCode(), this.enrollmentService.getTransactionId(), new Object[0]);
        TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)exception), exception.getErrorCode(), new String[0]);
    }

    public void populateEventContext(IEventContext ctxt) {
        this.evtCtxt = ctxt;
    }

    public void setUIPreference(IUIPreference pref) {
        this.pref = pref;
    }

    private String getTransliteratedText(String text) {
        if (this.localeSpec.equalsIgnoreCase("en_in")) {
            return text;
        }
        return this.tlitProv.transliterate(text, this.localeSpec, new TransliterationHints[0]).trim();
    }
}

