/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.appointment;

import com.google.common.base.Strings;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.mda.proofdocapi.CountryList;
import in.gov.uidai.ec.protobuf.AppointmentServiceProto;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.Country;
import in.gov.uidai.ec.service.enrollment.model.ForeignDetail;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.enrollment.model.RelationshipType;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.IAppointmentService;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentServiceEnrol
implements IAppointmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentServiceEnrol.class);
    private final EnrollmentService enrollmentService;
    private final IPinCodeService postOfficeDataService;
    private final IDocumentService documentService;
    private final ITransliterationProvider tlitProv;
    private final String localeSpec;

    public AppointmentServiceEnrol(EnrollmentService enrollmentService, IPinCodeService postOfficeDataService, IDocumentService documentService, IUIPreference pref) {
        this.enrollmentService = enrollmentService;
        this.postOfficeDataService = postOfficeDataService;
        this.documentService = documentService;
        this.localeSpec = pref.getTransliterationLocale("hi_in");
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
    }

    @Override
    public void populatePersonalDetail(AppointmentServiceProto.ResidentBasicDetail residentBasicDetail) {
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        personalDetail.setMandatory(true);
        personalDetail.setFullName(residentBasicDetail.getName());
        personalDetail.setFullNameLocal(this.getTransliteratedText(residentBasicDetail.getName()));
        personalDetail.setApplicantGender(residentBasicDetail.getGender());
        personalDetail.setApplicantConfirmGender(residentBasicDetail.getGender());
        personalDetail.setGenderLocal(this.getTransliteratedText(residentBasicDetail.getGender()));
        personalDetail.setConfirmGenderLocal(this.getTransliteratedText(residentBasicDetail.getGender()));
        String[] dob = residentBasicDetail.getDob().split("-");
        personalDetail.setAadhaarNumber(residentBasicDetail.getUid());
        this.enrollmentService.setChildEnrollment(AgeGroup.BELOW5.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        this.enrollmentService.setMinorEnrollment(AgeGroup.BETWEEN5TO18.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        this.enrollmentService.setAdultEnrollment(AgeGroup.ABOVE18.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        if (dob.length > 2) {
            personalDetail.getAgeDob().setDobSelected(true);
            personalDetail.getConfirmDob().setDobSelected(true);
            personalDetail.getAgeDob().setDob(dob[2], dob[1], dob[0]);
            personalDetail.getConfirmDob().setDob(dob[2], dob[1], dob[0]);
            personalDetail.getAgeDob().setAgeDobLocal(dob[2] + "/" + dob[1] + "/" + dob[0]);
            personalDetail.getConfirmDob().setAgeDobLocal(dob[2] + "/" + dob[1] + "/" + dob[0]);
        }
    }

    @Override
    public void populateContactDetail(AppointmentServiceProto.ContactDetail contactDetail) {
        Contact contact = this.enrollmentService.getDemoContactDetails();
        contact.setMandatory(true);
        contact.getMobile().setNumber(contactDetail.getMobile());
        contact.getEmail().setEmail(contactDetail.getEmail());
        Address address = contact.getAddress();
        AppointmentServiceProto.Address appointmentAddress = contactDetail.getAddress();
        PostalAddress postalAddress = PostalAddress.EMPTY_POSTAL_ADDRESS;
        Optional<PostalAddress> addressOpt = this.postOfficeDataService.findByPinCode(Integer.parseInt(appointmentAddress.getPincode()), false).stream().filter(f -> f.getVtc().getAddressValue().equals(appointmentAddress.getVtc())).findFirst();
        if (addressOpt.isPresent()) {
            postalAddress = addressOpt.get();
        }
        address.setStreet(appointmentAddress.getStreet());
        address.setBuilding(appointmentAddress.getBuilding());
        address.setLandmark(appointmentAddress.getLandmark());
        address.setCareOfName(appointmentAddress.getCareof());
        address.setPinCode(postalAddress.getPinCode());
        address.setState(postalAddress.getState());
        address.setVTC(postalAddress.getVtc());
        address.setDistrict(postalAddress.getDistrict());
        address.setSubDistrict(postalAddress.getSubDistrict());
        PostOffice postOffice = new PostOffice();
        postOffice.setVTCCode(address.getVTCCode());
        postOffice.setPincode(address.getPinCode());
        postOffice.setVTCName(address.getVTC());
        List options = this.postOfficeDataService.findPostOffices(Integer.parseInt(address.getPinCode()), postalAddress.getVtc());
        if (options != null && !options.isEmpty()) {
            if (options.size() > 1) {
                PostOffice select = new PostOffice();
                select.setName("Select");
                options.add(0, select);
            } else {
                postOffice.setName(((PostOffice)options.get(0)).getName());
                postOffice.setLocaleName(this.getTransliteratedText(((PostOffice)options.get(0)).getName()));
                address.getPinCodeDetail().setDefaultPoName(((PostOffice)options.get(0)).getName());
                postOffice.setLocaleName(this.getTransliteratedText(((PostOffice)options.get(0)).getName()));
            }
            address.getPinCodeDetail().setPostOfficeList(options);
        }
        address.setStreetLocal(this.getTransliteratedText(address.getStreet()));
        address.setBuildingLocal(this.getTransliteratedText(address.getBuilding()));
        address.setLandmark(this.getTransliteratedText(address.getLandmark()));
        address.setCareOfNameLocal(this.getTransliteratedText(address.getCareOf()));
        address.setDistrictLocal(this.getTransliteratedText(address.getDistrict()));
        address.setStateLocal(this.getTransliteratedText(address.getState()));
        address.setPinCodeLocal(this.getTransliteratedText(address.getPinCode()));
        address.setVTCLocal(this.getTransliteratedText(address.getVTC()));
        address.setPostOffice(postOffice);
    }

    @Override
    public void populateHofDetail(AppointmentServiceProto.HofDetail hofDetail) {
        if (!this.enrollmentService.isHofEnrollment()) {
            return;
        }
        this.enrollmentService.setHofUid(hofDetail.getHofUid());
        this.enrollmentService.setHofName(hofDetail.getHofName());
        this.enrollmentService.getDemographics().getOtherDetail().setHOF(true);
        this.enrollmentService.getDemographics().getOtherDetail().setName(hofDetail.getHofName());
        switch (hofDetail.getHofRelation()) {
            case "Father": {
                this.enrollmentService.getDemographics().getOtherDetail().setRelationType(RelationshipType.FATHER);
                break;
            }
            case "Mother": {
                this.enrollmentService.getDemographics().getOtherDetail().setRelationType(RelationshipType.MOTHER);
                break;
            }
            default: {
                this.enrollmentService.getDemographics().getOtherDetail().setRelationType(RelationshipType.LEGAL_GUARDIAN);
            }
        }
    }

    @Override
    public void setUpdateType(String types) {
    }

    @Override
    public void populateForeignDetail(AppointmentServiceProto.ResidentForeignDetail appointmentForeignDetail) {
        if (!this.enrollmentService.isForeignResident()) {
            return;
        }
        String[] poiIssueDate = appointmentForeignDetail.getPoiIssueDate().split("-");
        String[] poiExpiryDate = appointmentForeignDetail.getPoiExpiryDate().split("-");
        String[] pofIssueDate = appointmentForeignDetail.getPofIssueDate().split("-");
        String[] pofExpiryDate = appointmentForeignDetail.getPofExpiryDate().split("-");
        ForeignDetail foreignDetail = this.enrollmentService.getDemoPersonalDetails().getForeignDetail();
        if (poiIssueDate.length > 2) {
            foreignDetail.setIssueDate(poiIssueDate[2] + "-" + poiIssueDate[0] + "-" + poiIssueDate[1]);
        }
        if (poiExpiryDate.length > 2) {
            foreignDetail.setExpiryDate(poiExpiryDate[2] + "-" + poiExpiryDate[0] + "-" + poiExpiryDate[1]);
        }
        foreignDetail.setDocNo(appointmentForeignDetail.getPoiDocumentNumber());
        if (pofIssueDate.length > 2) {
            foreignDetail.setVisaIssueDate(pofIssueDate[2] + "-" + pofIssueDate[0] + "-" + pofIssueDate[1]);
        }
        if (pofExpiryDate.length > 2) {
            foreignDetail.setVisaExpiryDate(pofExpiryDate[2] + "-" + pofExpiryDate[0] + "-" + pofExpiryDate[1]);
        }
        foreignDetail.setVisaNo(appointmentForeignDetail.getPofDocumentNumber());
        Optional<CountryList> countryLists = Arrays.stream(this.documentService.getCountryList()).filter(countryList -> countryList.getCountryName().equalsIgnoreCase(appointmentForeignDetail.getCountry())).findFirst();
        if (countryLists.isPresent()) {
            Country country = new Country(countryLists.get().getCountryName(), countryLists.get().getCountryCode());
            this.enrollmentService.getDemoResidentialStatus().setCountry(country);
        }
    }

    @Override
    public void populateDocuments(AppointmentServiceProto.DocumentDetail documentDetail, String nationality) {
        try {
            this.enrollmentService.populateProofDocuments(nationality, this.enrollmentService.isUpdateUC() ? "UPDATE" : "NEW", this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup().toString());
            if (!Strings.isNullOrEmpty((String)documentDetail.getPob())) {
                this.enrollmentService.getReferences().getPob().setProofDocument(this.getProofDocument(DocumentType.POB, documentDetail.getPob()));
            }
            if (!this.enrollmentService.isHofEnrollment() && !Strings.isNullOrEmpty((String)documentDetail.getPoi())) {
                this.enrollmentService.getReferences().getPoi().setProofDocument(this.getProofDocument(DocumentType.POI, documentDetail.getPoi()));
            }
            if (!this.enrollmentService.isHofEnrollment() && !Strings.isNullOrEmpty((String)documentDetail.getPoa())) {
                this.enrollmentService.getReferences().getPoa().setProofDocument(this.getProofDocument(DocumentType.POA, documentDetail.getPoa()));
            }
            if (this.enrollmentService.isForeignResident() && !Strings.isNullOrEmpty((String)documentDetail.getPof())) {
                this.enrollmentService.getReferences().getPof().setProofDocument(this.getProofDocument(DocumentType.POF, documentDetail.getPof()));
            }
            if (this.enrollmentService.isHofEnrollment() && !Strings.isNullOrEmpty((String)documentDetail.getPor())) {
                this.enrollmentService.getReferences().getPor().setProofDocument(this.getProofDocument(DocumentType.POR, documentDetail.getPor()));
            }
        }
        catch (OnlineGatewayException e) {
            LOGGER.error("Error : ", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    private ProofDocument getProofDocument(DocumentType documentType, String documentName) {
        Document document = this.documentService.getDocument(documentType, documentName);
        if (document == null) {
            return null;
        }
        return new ProofDocument(document.getDocumentId(), document.getDocumentName());
    }

    private String getTransliteratedText(String text) {
        if (this.localeSpec.equalsIgnoreCase("en_in")) {
            return text;
        }
        return this.tlitProv.transliterate(text, this.localeSpec, new TransliterationHints[0]).trim();
    }
}

