/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.appointment;

import com.google.common.base.Strings;
import in.gov.uidai.ec.oauthapi.OnlineGatewayException;
import in.gov.uidai.ec.oauthapi.json.countapi.CountLimit;
import in.gov.uidai.ec.protobuf.AppointmentServiceProto;
import in.gov.uidai.ec.service.document.AgeGroup;
import in.gov.uidai.ec.service.document.Document;
import in.gov.uidai.ec.service.document.DocumentType;
import in.gov.uidai.ec.service.document.IDocumentService;
import in.gov.uidai.ec.service.document.ProofDocument;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.service.enrollment.model.Address;
import in.gov.uidai.ec.service.enrollment.model.Contact;
import in.gov.uidai.ec.service.enrollment.model.FieldsUpdateCount;
import in.gov.uidai.ec.service.enrollment.model.PersonalDetail;
import in.gov.uidai.ec.service.pincode.IPinCodeService;
import in.gov.uidai.ec.service.pincode.PostOffice;
import in.gov.uidai.ec.service.pincode.PostalAddress;
import in.gov.uidai.ec.telemetry.TelemetryService;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.IAppointmentService;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.translit.core.TransliterationManager;
import in.gov.uidai.translit.spi.ITransliterationProvider;
import in.gov.uidai.translit.spi.TransliterationHints;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentServiceUpdate
implements IAppointmentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentServiceUpdate.class);
    private final EnrollmentService enrollmentService;
    private final IPinCodeService postOfficeDataService;
    private final IDocumentService documentService;
    private final ITransliterationProvider tlitProv;
    private final String localeSpec;

    public AppointmentServiceUpdate(EnrollmentService enrollmentService, IPinCodeService postOfficeDataService, IDocumentService documentService, IUIPreference pref) {
        this.enrollmentService = enrollmentService;
        this.postOfficeDataService = postOfficeDataService;
        this.documentService = documentService;
        this.localeSpec = pref.getTransliterationLocale("hi_in");
        this.tlitProv = TransliterationManager.getInst().getTransliterationProvider(this.localeSpec);
    }

    @Override
    public void populatePersonalDetail(AppointmentServiceProto.ResidentBasicDetail residentBasicDetail) {
        PersonalDetail personalDetail = this.enrollmentService.getDemoPersonalDetails();
        personalDetail.setAadhaarNumber(residentBasicDetail.getUid());
        this.enrollmentService.setChildEnrollment(AgeGroup.BELOW5.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        this.enrollmentService.setMinorEnrollment(AgeGroup.BETWEEN5TO18.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        this.enrollmentService.setAdultEnrollment(AgeGroup.ABOVE18.toString().equalsIgnoreCase(residentBasicDetail.getAgeGroup()));
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        if (fieldsUpdateCount.getName().hasToBeUpdated()) {
            personalDetail.setMandatory(true);
            personalDetail.setNewName(residentBasicDetail.getName());
        }
        if (fieldsUpdateCount.getGender().hasToBeUpdated()) {
            personalDetail.setMandatory(true);
            personalDetail.setApplicantGender(residentBasicDetail.getGender());
            personalDetail.setApplicantConfirmGender(residentBasicDetail.getGender());
        }
        if (fieldsUpdateCount.getDob().hasToBeUpdated()) {
            personalDetail.setMandatory(true);
            String[] dob = residentBasicDetail.getDob().split("-");
            if (dob.length > 2) {
                personalDetail.getAgeDob().setDobSelected(true);
                personalDetail.getConfirmDob().setDobSelected(true);
                personalDetail.getAgeDob().setDob(dob[2], dob[1], dob[0]);
                personalDetail.getConfirmDob().setDob(dob[2], dob[1], dob[0]);
                personalDetail.getAgeDob().setAgeDobLocal(dob[2] + "/" + dob[1] + "/" + dob[0]);
                personalDetail.getConfirmDob().setAgeDobLocal(dob[2] + "/" + dob[1] + "/" + dob[0]);
            }
        }
    }

    @Override
    public void populateContactDetail(AppointmentServiceProto.ContactDetail contactDetail) {
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        Contact contact = this.enrollmentService.getDemoContactDetails();
        if (fieldsUpdateCount.getAddress().hasToBeUpdated()) {
            contact.setMandatory(true);
            Address address = contact.getAddress();
            AppointmentServiceProto.Address appointmentAddress = contactDetail.getAddress();
            PostalAddress postalAddress = PostalAddress.EMPTY_POSTAL_ADDRESS;
            Optional<PostalAddress> addressOpt = this.postOfficeDataService.findByPinCode(Integer.parseInt(appointmentAddress.getPincode()), false).stream().filter(f -> f.getVtc().getAddressValue().equals(appointmentAddress.getVtc())).findFirst();
            if (addressOpt.isPresent()) {
                postalAddress = addressOpt.get();
            }
            address.setStreet(appointmentAddress.getStreet());
            address.setBuilding(appointmentAddress.getBuilding());
            address.setLandmark(appointmentAddress.getLandmark());
            address.setCareOfName(appointmentAddress.getCareof());
            address.setPinCode(postalAddress.getPinCode());
            address.setState(postalAddress.getState());
            address.setVTC(postalAddress.getVtc());
            address.setDistrict(postalAddress.getDistrict());
            address.setSubDistrict(postalAddress.getSubDistrict());
            PostOffice postOffice = new PostOffice();
            postOffice.setVTCCode(address.getVTCCode());
            postOffice.setPincode(address.getPinCode());
            postOffice.setVTCName(address.getVTC());
            List options = null;
            if (!Strings.isNullOrEmpty((String)address.getPinCode())) {
                options = this.postOfficeDataService.findPostOffices(Integer.parseInt(address.getPinCode()), postalAddress.getVtc());
            }
            if (options != null && !options.isEmpty()) {
                if (options.size() > 1) {
                    PostOffice select = new PostOffice();
                    select.setName("Select");
                    options.add(0, select);
                } else {
                    postOffice.setName(((PostOffice)options.get(0)).getName());
                    postOffice.setLocaleName(this.getTransliteratedText(((PostOffice)options.get(0)).getName()));
                    address.getPinCodeDetail().setDefaultPoName(((PostOffice)options.get(0)).getName());
                }
                address.getPinCodeDetail().setPostOfficeList(options);
            }
            address.setPostOffice(postOffice);
        }
        if (fieldsUpdateCount.getMobile().hasToBeUpdated()) {
            contact.setMandatory(true);
            contact.getMobile().setNumber(contactDetail.getMobile());
        }
        if (fieldsUpdateCount.getEmail().hasToBeUpdated()) {
            contact.setMandatory(true);
            contact.getEmail().setEmail(contactDetail.getEmail());
        }
    }

    @Override
    public void populateDocuments(AppointmentServiceProto.DocumentDetail documentDetail, String nationality) {
        try {
            this.enrollmentService.populateProofDocuments(nationality, this.enrollmentService.isUpdateUC() ? "UPDATE" : "NEW", this.enrollmentService.getDemoPersonalDetails().getAgeDob().getAgeGroup().toString());
            FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
            if (fieldsUpdateCount.getDob().hasToBeUpdated() && !Strings.isNullOrEmpty((String)documentDetail.getPob())) {
                this.enrollmentService.getReferences().getPob().setProofDocument(this.getProofDocument(DocumentType.POB, documentDetail.getPob()));
            }
            if (fieldsUpdateCount.getName().hasToBeUpdated() && !Strings.isNullOrEmpty((String)documentDetail.getPoi())) {
                this.enrollmentService.getReferences().getPoi().setProofDocument(this.getProofDocument(DocumentType.POI, documentDetail.getPoi()));
            }
            if (fieldsUpdateCount.getAddress().hasToBeUpdated() && !Strings.isNullOrEmpty((String)documentDetail.getPoa())) {
                this.enrollmentService.getReferences().getPoa().setProofDocument(this.getProofDocument(DocumentType.POA, documentDetail.getPoa()));
            }
            if (this.enrollmentService.isForeignResident() && !Strings.isNullOrEmpty((String)documentDetail.getPof())) {
                this.enrollmentService.getReferences().getPof().setProofDocument(this.getProofDocument(DocumentType.POF, documentDetail.getPof()));
            }
            if (this.enrollmentService.isHofEnrollment() && !Strings.isNullOrEmpty((String)documentDetail.getPor())) {
                this.enrollmentService.getReferences().getPor().setProofDocument(this.getProofDocument(DocumentType.POR, documentDetail.getPor()));
            }
        }
        catch (OnlineGatewayException e) {
            LOGGER.error("Error", (Throwable)e);
            TelemetryService.getTelemetryServiceInstance().postLogData((Exception)((Object)e), e.getErrorCode(), new String[0]);
        }
    }

    private ProofDocument getProofDocument(DocumentType documentType, String documentName) {
        Document document = this.documentService.getDocument(documentType, documentName);
        if (document == null) {
            return null;
        }
        return new ProofDocument(document.getDocumentId(), document.getDocumentName());
    }

    @Override
    public void populateForeignDetail(AppointmentServiceProto.ResidentForeignDetail appointmentForeignDetail) {
    }

    @Override
    public void populateHofDetail(AppointmentServiceProto.HofDetail hofDetail) {
    }

    @Override
    public void setUpdateType(String types) {
        if (Strings.isNullOrEmpty((String)types)) {
            return;
        }
        String[] typeList = types.split(",");
        FieldsUpdateCount fieldsUpdateCount = this.enrollmentService.getFieldsUpdateCount();
        this.defaultUpdate(fieldsUpdateCount);
        String[] stringArray = typeList;
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String type;
            switch (type = stringArray[i]) {
                case "NAME": {
                    fieldsUpdateCount.getName().updateField(true);
                    continue block20;
                }
                case "DOB": {
                    fieldsUpdateCount.getDob().updateField(true);
                    continue block20;
                }
                case "GENDER": {
                    fieldsUpdateCount.getGender().updateField(true);
                    continue block20;
                }
                case "ADDRESS": {
                    fieldsUpdateCount.getAddress().updateField(true);
                    continue block20;
                }
                case "MOBILE": {
                    fieldsUpdateCount.getMobile().updateField(true);
                    continue block20;
                }
                case "EMAIL": {
                    fieldsUpdateCount.getEmail().updateField(true);
                    continue block20;
                }
                case "BIOMETRIC": {
                    fieldsUpdateCount.getBio().updateField(true);
                    continue block20;
                }
                case "REACTIVATE": {
                    fieldsUpdateCount.getActivationAadhaar().updateField(true);
                }
            }
        }
    }

    private void defaultUpdate(FieldsUpdateCount fieldsUpdateCount) {
        CountLimit countLimit = new CountLimit();
        countLimit.setUpdateAllowed(true);
        countLimit.setUpdatesAvailed(1);
        countLimit.setUpdateAttemptLimit(1);
        fieldsUpdateCount.setName(countLimit);
        fieldsUpdateCount.setDob(countLimit);
        fieldsUpdateCount.setGender(countLimit);
        fieldsUpdateCount.setAddress(countLimit);
        fieldsUpdateCount.setMobile(countLimit);
        fieldsUpdateCount.setEmail(countLimit);
        fieldsUpdateCount.setBio();
        fieldsUpdateCount.setActivationAadhaar();
        fieldsUpdateCount.setPoa();
        fieldsUpdateCount.setPoi();
        fieldsUpdateCount.setPob();
        fieldsUpdateCount.setPor();
        fieldsUpdateCount.setPof();
    }

    private String getTransliteratedText(String text) {
        if (this.localeSpec.equalsIgnoreCase("en_in")) {
            return text;
        }
        return this.tlitProv.transliterate(text, this.localeSpec, new TransliterationHints[0]).trim();
    }
}

