/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.appointment;

import com.google.common.base.Strings;
import in.gov.uidai.ec.ui.ControllerBase;
import in.gov.uidai.ec.ui.enrol.universalClient.appointment.AppointmentViewPeer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class AppointmentUIController
extends ControllerBase {
    private final AppointmentViewPeer viewPeer;
    private String appointIdError;

    public AppointmentUIController(AppointmentViewPeer viewPeer) {
        super(viewPeer.getView());
        this.viewPeer = viewPeer;
        this.initView();
    }

    private void initView() {
        super.addFocusListener(this.viewPeer.appointmentIdField, this::getAppointmentId);
        super.addActionListener(this.viewPeer.okButton, this::makeAppointmentApiCall);
    }

    private void getAppointmentId(FocusEvent focusEvent) {
        String appointmentId = this.viewPeer.appointmentIdField.getText().trim();
        this.appointIdError = Strings.isNullOrEmpty((String)appointmentId) ? "Appointment Id cannot be empty." : null;
        this.updateAppointmentFieldState();
    }

    private void makeAppointmentApiCall(ActionEvent event) {
        if (Strings.isNullOrEmpty((String)this.appointIdError)) {
            HashMap<String, String> evtParams = new HashMap<String, String>();
            evtParams.put("appointmentId", this.viewPeer.appointmentIdField.getText());
            ((ActionListener)this.viewPeer.evtCtxt.getEventListener("appointment_api_call", ActionListener.class, evtParams)).actionPerformed(event);
        }
    }

    private void updateAppointmentFieldState() {
        this.clearFieldError(this.viewPeer.appointmentIdField);
        SwingUtilities.invokeLater(() -> this.showFieldError(this.viewPeer.appointmentIdField, this.appointIdError));
    }
}

