/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.service.enrollment.EnrollmentService;
import in.gov.uidai.ec.swing.MandatoryLabelBuilder;
import in.gov.uidai.ec.swing.ToggleButtonAssociation;
import in.gov.uidai.ec.swing.shared.LocaleLabel;
import in.gov.uidai.ec.swing.tlit.DirectTranslitField;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.DateDocument;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.RadioButtonCustom;
import in.gov.uidai.ec.ui.shared.IUIPreference;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.MsgKeysILV;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.notify.OverlayResetDocumentListener;
import in.gov.uidai.swing.tilv.FBNumericDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class AgePanel
implements IViewElementComposite {
    private final IResourceBundleContext enrolRbctx;
    @ExportViewElement(as="Date", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField date;
    protected RadioButtonCustom ageButton;
    @ExportViewElement(as="DOB radio button", using=StandardSwingElementFactory.class)
    protected RadioButtonCustom dobButton;
    @ExportViewElement(as="Age", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField ageTextField;
    @ExportViewElement(as="Confirm Date", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField confirmDate;
    protected RadioButtonCustom confirmAgeButton;
    protected RadioButtonCustom confirmDobButton;
    @ExportViewElement(as="Confirm Age", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField confirmAgeTextField;
    protected DirectTranslitField locAgeDobField;
    protected IUIPreference uiPref;
    private JLabel heading;
    private JLabel heading1;
    private JLabel heading3;
    private JLabel heading4;
    private LocaleLabel heading2;
    private final boolean isVerified;
    private final boolean isNewEnrollment;

    public AgePanel(IResourceBundleContext enrolRbctx, IUIPreference uiPref, boolean isVerified, EnrollmentService enrollmentService) {
        this.enrolRbctx = enrolRbctx;
        this.uiPref = uiPref;
        this.isVerified = isVerified;
        this.isNewEnrollment = enrollmentService.isNewEnrollmentUC();
    }

    private JPanel prepare(PlaceholderTextField date) {
        JPanel jPanel1 = new JPanel();
        date.setPlaceholder("DD-MM-YYYY");
        date.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        date.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        date.setEnabled(false);
        date.setColumns(10);
        AbstractDocument document = (AbstractDocument)date.getDocument();
        document.setDocumentFilter(new DateDocument(date));
        jPanel1.setBackground(new Color(255, 255, 255));
        jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        int width = this.isVerified ? 235 : 210;
        jPanel1.add((Component)date, new AbsoluteConstraints(0, 0, width, 40));
        return jPanel1;
    }

    public void setAgeEnable(boolean enable) {
        this.ageButton.setEnabled(enable);
        this.ageTextField.setEnabled(enable);
        this.confirmAgeButton.setEnabled(enable);
        this.confirmAgeTextField.setEnabled(enable);
        this.dobButton.setEnabled(!enable);
        this.date.setEnabled(!enable);
        this.confirmDobButton.setEnabled(!enable);
        this.confirmDate.setEnabled(!enable);
    }

    public JComponent createNew() {
        JPanel mainPanel = (JPanel)this.initialise();
        this.initialiseUI();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        if (this.isVerified) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 0, 2, 0);
            gbc.fill = 2;
            this.date.setPreferredSize(new Dimension(235, 40));
            this.confirmDate.setPreferredSize(new Dimension(235, 40));
            mainPanel.add((Component)this.heading4, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepare(this.date), gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.heading3, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepare(this.confirmDate), gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 30, 0, 0);
            mainPanel.add((Component)this.heading2, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.locAgeDobField, gbc);
        } else {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 0, 0, 0);
            gbc.fill = 2;
            mainPanel.add((Component)this.heading, gbc);
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.ageButton, this.ageTextField), gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.dobButton, this.prepare(this.date)), gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 30, 0, 0);
            mainPanel.add((Component)this.heading2, gbc);
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 30, 0, 0);
            mainPanel.add((Component)this.locAgeDobField, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(5, 0, 0, 0);
            mainPanel.add((Component)this.heading1, gbc);
            gbc.gridy = 3;
            gbc.insets = new Insets(0, 0, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.confirmAgeButton, this.confirmAgeTextField), gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.confirmDobButton, this.prepare(this.confirmDate)), gbc);
        }
        return mainPanel;
    }

    public JComponent createForeign() {
        JPanel mainPanel = (JPanel)this.initialise();
        this.initialiseUI();
        mainPanel.setBackground(Color.WHITE);
        mainPanel.setLayout(new GridBagLayout());
        if (this.isVerified) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 0, 2, 0);
            gbc.fill = 2;
            this.date.setPreferredSize(new Dimension(235, 40));
            this.confirmDate.setPreferredSize(new Dimension(235, 40));
            mainPanel.add((Component)this.heading4, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepare(this.date), gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.heading3, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepare(this.confirmDate), gbc);
        } else {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.fill = 2;
            mainPanel.add((Component)this.heading, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepareAge(this.ageButton, this.ageTextField), gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.dobButton, this.prepare(this.date)), gbc);
            ++gbc.gridx;
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 50, 0, 0);
            mainPanel.add((Component)this.heading1, gbc);
            gbc.gridy = 1;
            mainPanel.add((Component)this.prepareAge(this.confirmAgeButton, this.confirmAgeTextField), gbc);
            ++gbc.gridx;
            gbc.insets = new Insets(0, 10, 0, 0);
            mainPanel.add((Component)this.prepareAge(this.confirmDobButton, this.prepare(this.confirmDate)), gbc);
        }
        return mainPanel;
    }

    private JComponent prepareAge(RadioButtonCustom button, JComponent field) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 2, 5));
        panel.add(button);
        panel.add(field);
        return panel;
    }

    private void initialiseUI() {
        this.heading = new JLabel();
        this.heading1 = new JLabel();
        this.heading3 = new JLabel();
        this.heading4 = new JLabel();
        this.ageButton.setSelected(!this.isVerified);
        this.confirmAgeButton.setSelected(!this.isVerified);
        this.dobButton.setSelected(this.isVerified);
        this.confirmDobButton.setSelected(this.isVerified);
        this.ageButton.setBackground(Color.decode("#297FB8"));
        this.dobButton.setPreferredSize(new Dimension(20, 20));
        this.ageButton.setPreferredSize(new Dimension(20, 20));
        this.confirmDobButton.setPreferredSize(new Dimension(20, 20));
        this.confirmAgeButton.setPreferredSize(new Dimension(20, 20));
        this.heading.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading.setForeground(Color.decode("#34495E"));
        this.heading3.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading3.setForeground(Color.decode("#34495E"));
        this.heading4.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading4.setForeground(Color.decode("#34495E"));
        FBNumericDocument ageFieldDoc = new FBNumericDocument((JTextComponent)this.ageTextField, this.enrolRbctx.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        ageFieldDoc.setMaxLength(3);
        this.ageTextField.setDocument((Document)ageFieldDoc);
        ageFieldDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.ageTextField));
        this.ageTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.ageTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.AGE.toString(), new Object[0]));
        this.ageTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.ageTextField.setPreferredSize(new Dimension(205, 40));
        this.heading1.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.heading1.setForeground(Color.decode("#34495E"));
        FBNumericDocument confirmAgeFieldDoc = new FBNumericDocument((JTextComponent)this.confirmAgeTextField, this.enrolRbctx.getMessage((Object)MsgKeysILV.NUMERIC, new Object[0]));
        confirmAgeFieldDoc.setMaxLength(3);
        this.confirmAgeTextField.setDocument((Document)confirmAgeFieldDoc);
        confirmAgeFieldDoc.addDocumentListener((DocumentListener)new OverlayResetDocumentListener((JTextComponent)this.confirmAgeTextField));
        this.confirmAgeTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.confirmAgeTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONFIRM_AGE.toString(), new Object[0]));
        this.confirmAgeTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.confirmAgeTextField.setPreferredSize(new Dimension(205, 40));
        this.setMandatory(this.isNewEnrollment);
        this.locAgeDobField.setFont(new Font(this.heading2.getFont().getName(), 0, 14));
        this.locAgeDobField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.locAgeDobField.setPreferredSize(new Dimension(480, 40));
    }

    public JComponent initialise() {
        JPanel agePanel = new JPanel();
        agePanel.setBackground(Color.WHITE);
        agePanel.setLayout((LayoutManager)new AbsoluteLayout());
        this.ageTextField = new PlaceholderTextField();
        this.date = new PlaceholderTextField();
        this.ageButton = new RadioButtonCustom();
        this.dobButton = new RadioButtonCustom();
        this.confirmAgeTextField = new PlaceholderTextField();
        this.confirmDate = new PlaceholderTextField();
        this.confirmAgeButton = new RadioButtonCustom();
        this.confirmDobButton = new RadioButtonCustom();
        this.locAgeDobField = new DirectTranslitField();
        this.locAgeDobField.setResourceBundleContext(this.enrolRbctx);
        this.locAgeDobField.setLocale(this.enrolRbctx.getLocale().toString());
        ButtonGroup ageGrp = new ButtonGroup();
        ageGrp.add(this.ageButton);
        ageGrp.add(this.dobButton);
        ButtonGroup ConfirmAgeGrp = new ButtonGroup();
        ConfirmAgeGrp.add(this.confirmAgeButton);
        ConfirmAgeGrp.add(this.confirmDobButton);
        new ToggleButtonAssociation(this.ageButton).enable(this.ageTextField).enable(this.confirmAgeTextField).disable(this.date).disable(this.confirmDate).reset(this.date).reset(this.confirmDate).select(this.confirmAgeButton).deselect(this.confirmDobButton).deselect(this.dobButton);
        new ToggleButtonAssociation(this.dobButton).enable(this.date).enable(this.confirmDate).disable(this.ageTextField).disable(this.confirmAgeTextField).reset(this.ageTextField).reset(this.confirmAgeTextField).select(this.confirmDobButton).deselect(this.confirmAgeButton).deselect(this.ageButton);
        new ToggleButtonAssociation(this.confirmAgeButton).enable(this.ageTextField).enable(this.confirmAgeTextField).disable(this.date).disable(this.confirmDate).reset(this.date).reset(this.confirmDate).select(this.ageButton).deselect(this.dobButton).deselect(this.confirmDobButton);
        new ToggleButtonAssociation(this.confirmDobButton).enable(this.date).enable(this.confirmDate).disable(this.confirmAgeTextField).disable(this.ageTextField).reset(this.confirmAgeTextField).reset(this.ageTextField).select(this.dobButton).deselect(this.ageButton).deselect(this.confirmAgeButton);
        this.ageTextField.addActionListener(e -> agePanel.requestFocusInWindow());
        this.confirmAgeTextField.addActionListener(e -> agePanel.requestFocusInWindow());
        this.date.addActionListener(e -> agePanel.requestFocusInWindow());
        this.confirmDate.addActionListener(e -> agePanel.requestFocusInWindow());
        return agePanel;
    }

    public void setDobFields(String day, String month, String year) {
        this.date.setText(day + "-" + month + "-" + year);
        this.confirmDate.setText(day + "-" + month + "-" + year);
        if (day.equalsIgnoreCase("") || month.equalsIgnoreCase("") || year.equalsIgnoreCase("")) {
            this.locAgeDobField.setText("");
        } else {
            String locDobDate = day + "-" + month + "-" + year;
            this.locAgeDobField.setText(locDobDate);
        }
    }

    public void setDefault() {
        this.ageTextField.setText("");
        this.date.setText("");
        this.confirmAgeTextField.setText("");
        this.confirmDate.setText("");
        this.locAgeDobField.setText("");
    }

    public void setEnable(boolean enable) {
        this.ageTextField.setEnabled(enable);
        this.date.setEnabled(enable);
        this.confirmAgeTextField.setEnabled(enable);
        this.confirmDate.setEnabled(enable);
        this.locAgeDobField.setEnabled(enable);
    }

    public void setMandatory(boolean isMandatory) {
        if (isMandatory) {
            this.heading.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADD_AGEDOB.toString(), new Object[0])));
            this.heading3.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONFIRM_DOB.toString(), new Object[0])));
            this.heading4.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DOB.toString(), new Object[0])));
            this.heading1.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADD_CONFIRM_AGEDOB.toString(), new Object[0])));
            this.heading2 = new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrolMandatory("label-tlit:demotab.agedob");
        } else {
            this.heading.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADD_AGEDOB.toString(), new Object[0]));
            this.heading3.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.CONFIRM_DOB.toString(), new Object[0]));
            this.heading4.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.DOB.toString(), new Object[0]));
            this.heading1.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ADD_CONFIRM_AGEDOB.toString(), new Object[0]));
            this.heading2 = new MandatoryLabelBuilder(this.enrolRbctx).createLocalUCenrol("label-tlit:demotab.agedob");
        }
    }
}

