/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.ui.enrol.universalClient.basic;

import in.gov.uidai.ec.icas.text.IResourceBundleContext;
import in.gov.uidai.ec.swing.shared.ViewUtils;
import in.gov.uidai.ec.ui.enrol.universalClient.common.CommonUtilsUC;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.PlaceholderTextField;
import in.gov.uidai.ec.ui.enrol.universalClient.customUI.RadioButtonCustom;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysDemoTab;
import in.gov.uidai.ec.ui.shared.l10n.LabelKeysHeader;
import in.gov.uidai.litef.beans.stdview.ExportViewElement;
import in.gov.uidai.litef.beans.stdview.IViewElementComposite;
import in.gov.uidai.litef.widgets.StandardSwingElementFactory;
import in.gov.uidai.swing.ScrollToVisibleFocusHandler;
import in.gov.uidai.swing.border.RoundedBorder;
import in.gov.uidai.swing.border.SingleLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class BRNDetailsPanel
implements IViewElementComposite {
    @ExportViewElement(as="BrnYesRadioButton", using=StandardSwingElementFactory.class)
    protected RadioButtonCustom haveBRNNumberButton;
    @ExportViewElement(as="BrnNoRadioButton", using=StandardSwingElementFactory.class)
    protected RadioButtonCustom notHaveBRNNumberButton;
    protected ButtonGroup brnNumberButtonGroup;
    @ExportViewElement(as="BrnTextField", using=StandardSwingElementFactory.class)
    protected PlaceholderTextField brnTextField;
    @ExportViewElement(as="BrnStateDropdown", using=StandardSwingElementFactory.class)
    protected JComboBox<String> stateList;
    private final IResourceBundleContext enrolRbctx;
    private JLabel titleLabel;
    private JLabel brnQueryLabel;
    private JLabel brnStateLabel;
    private JLabel brnNumberLabel;

    public BRNDetailsPanel(IResourceBundleContext enrolRbctx) {
        this.enrolRbctx = enrolRbctx;
    }

    public JComponent createNew() {
        this.initialise();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 30));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.weightx = 1.0;
        GridBagConstraints gbcColumn1 = new GridBagConstraints();
        gbcColumn1.fill = 2;
        gbcColumn1.gridx = 0;
        gbcColumn1.gridwidth = 1;
        gbcColumn1.weightx = 0.06;
        gbcColumn1.insets = new Insets(0, 10, 0, 13);
        GridBagConstraints gbcColumn2 = new GridBagConstraints();
        gbcColumn2.fill = 2;
        gbcColumn2.gridx = 1;
        gbcColumn2.gridwidth = 1;
        gbcColumn2.weightx = 0.3;
        gbcColumn2.insets = new Insets(0, 0, 0, 15);
        GridBagConstraints gbcColumn3 = new GridBagConstraints();
        gbcColumn3.fill = 2;
        gbcColumn3.gridx = 2;
        gbcColumn3.gridwidth = 1;
        gbcColumn3.weightx = 0.25;
        gbcColumn3.insets = new Insets(0, 30, 0, 0);
        GridBagConstraints gbcColumn4 = new GridBagConstraints();
        gbcColumn4.fill = 2;
        gbcColumn4.gridx = 3;
        gbcColumn4.gridwidth = 1;
        gbcColumn4.weightx = 0.25;
        gbcColumn4.insets = new Insets(0, 10, 0, 0);
        gbc.gridy = 0;
        mainPanel.add((Component)this.createTitlePanel(), gbc);
        gbcColumn3.gridy = 1;
        gbcColumn2.gridy = 1;
        gbcColumn1.gridy = 1;
        mainPanel.add((Component)this.brnQueryLabel, gbcColumn1);
        mainPanel.add((Component)this.brnNumberLabel, gbcColumn3);
        mainPanel.add((Component)this.brnStateLabel, gbcColumn4);
        gbcColumn3.gridy = 2;
        gbcColumn2.gridy = 2;
        gbcColumn1.gridy = 2;
        mainPanel.add((Component)this.haveBRNNumberButton, gbcColumn1);
        mainPanel.add((Component)this.notHaveBRNNumberButton, gbcColumn2);
        mainPanel.add((Component)this.brnTextField, gbcColumn3);
        mainPanel.add(this.stateList, gbcColumn4);
        return mainPanel;
    }

    private JPanel createTitlePanel() {
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(this.titleLabel);
        JLabel label = new JLabel();
        label.setBorder((Border)new SingleLineBorder().drawEdges(false, false, true, false).lineColor("#cccccc"));
        JPanel linePanel = new JPanel();
        linePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        linePanel.add((Component)label, gbc);
        titlePanel.add(linePanel);
        return titlePanel;
    }

    private void initialise() {
        this.titleLabel = new JLabel();
        this.brnQueryLabel = new JLabel();
        this.haveBRNNumberButton = new RadioButtonCustom();
        this.notHaveBRNNumberButton = new RadioButtonCustom();
        this.haveBRNNumberButton.setActionCommand("brn_yes_action_command");
        this.notHaveBRNNumberButton.setActionCommand("brn_no_action_command");
        this.brnNumberButtonGroup = new ButtonGroup();
        this.brnNumberButtonGroup.add(this.haveBRNNumberButton);
        this.brnNumberButtonGroup.add(this.notHaveBRNNumberButton);
        this.brnStateLabel = new JLabel();
        this.brnTextField = new PlaceholderTextField();
        this.brnNumberLabel = new JLabel();
        this.stateList = new JComboBox();
        this.titleLabel.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.titleLabel.setForeground(Color.decode("#297FB8"));
        this.titleLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysHeader.BRN, new Object[0]));
        this.brnQueryLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.brnQueryLabel.setForeground(Color.decode("#34495E"));
        this.haveBRNNumberButton.setBackground(Color.decode("#297FB8"));
        this.haveBRNNumberButton.setForeground(Color.decode("#34495E"));
        this.haveBRNNumberButton.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_YES, new Object[0]));
        this.haveBRNNumberButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.haveBRNNumberButton.setEnabled(false);
        this.notHaveBRNNumberButton.setBackground(Color.decode("#297FB8"));
        this.notHaveBRNNumberButton.setForeground(Color.decode("#34495E"));
        this.notHaveBRNNumberButton.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_NO, new Object[0]));
        this.notHaveBRNNumberButton.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.notHaveBRNNumberButton.setSelected(true);
        this.notHaveBRNNumberButton.setEnabled(false);
        this.brnNumberLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.brnNumberLabel.setForeground(Color.decode("#34495E"));
        this.brnNumberLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_NUMBER.toString(), new Object[0]));
        this.brnTextField.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.brnTextField.setPlaceholder(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.ENTER_BRN_NUMBER.toString(), new Object[0]));
        this.brnTextField.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.brnTextField.setPreferredSize(new Dimension(-1, 40));
        this.brnTextField.setEnabled(false);
        this.brnStateLabel.setFont(CommonUtilsUC.semiBoldFont.deriveFont(0, 14.0f));
        this.brnStateLabel.setForeground(Color.decode("#34495E"));
        this.brnStateLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_STATE.toString(), new Object[0]));
        this.stateList.setActionCommand("brn_state_selected_action_command");
        this.stateList.addFocusListener((FocusListener)new ScrollToVisibleFocusHandler());
        this.stateList.setBorder((Border)new RoundedBorder().lineColor("#cccccc").lineThickness(1.0f).rounding(3, 3));
        this.stateList.addPropertyChangeListener(new ViewUtils.ClearOnDisableHandler());
        this.stateList.setFont(CommonUtilsUC.regularFont.deriveFont(0, 14.0f));
        this.stateList.setPreferredSize(new Dimension(-1, 40));
        this.stateList.setEnabled(false);
        this.stateList.setLightWeightPopupEnabled(false);
    }

    public RadioButtonCustom getHaveBRNNumberButton() {
        return this.haveBRNNumberButton;
    }

    public RadioButtonCustom getNotHaveBRNNumberButton() {
        return this.notHaveBRNNumberButton;
    }

    public PlaceholderTextField getBrnTextField() {
        return this.brnTextField;
    }

    public JComboBox<String> getStateList() {
        return this.stateList;
    }

    public void setDefault() {
        this.stateList.setSelectedItem("Select");
        this.brnTextField.setText("");
    }

    public void setEnabled(boolean enabled) {
        this.setDefault();
        this.notHaveBRNNumberButton.setSelected(true);
        this.haveBRNNumberButton.setSelected(false);
        this.notHaveBRNNumberButton.setEnabled(enabled);
        this.haveBRNNumberButton.setEnabled(enabled);
        this.stateList.setEnabled(false);
    }

    public void setMandatory(boolean mandatory) {
        if (mandatory) {
            this.brnQueryLabel.setText(CommonUtilsUC.setMandatoryText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_QUERY, new Object[0])));
        } else {
            this.brnQueryLabel.setText(this.enrolRbctx.getMessage((Object)LabelKeysDemoTab.BRN_QUERY, new Object[0]));
        }
    }
}

